/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.xmp.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.verapdf.xmp.XMPDateTime;
import org.verapdf.xmp.XMPDateTimeFactory;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.XMPMeta;
import org.verapdf.xmp.XMPMetaFactory;
import org.verapdf.xmp.XMPSchemaRegistry;
import org.verapdf.xmp.impl.VeraPDFXMPNode;
import org.verapdf.xmp.impl.XMPMetaImpl;
import org.verapdf.xmp.impl.XMPNode;
import org.verapdf.xmp.options.ParseOptions;
import org.verapdf.xmp.options.PropertyOptions;
import org.verapdf.xmp.options.SerializeOptions;
import org.verapdf.xmp.properties.XMPProperty;

public class VeraPDFMeta {
    public static final String PDFAID_PREFIX = "pdfaid";
    public static final String CONFORMANCE = "conformance";
    public static final String PART = "part";
    public static final String REVISION_YEAR = "rev";
    public static final String CORR = "corr";
    public static final String AMD = "amd";
    private final XMPMetaImpl meta;
    private VeraPDFXMPNode extensionSchemasNode;
    private final List<VeraPDFXMPNode> properties = new ArrayList<VeraPDFXMPNode>();
    private String packetHeader;

    private VeraPDFMeta(XMPMetaImpl meta) {
        this.meta = meta;
    }

    private void update() {
        List rootChildren;
        this.packetHeader = this.meta.getPacketHeader();
        this.extensionSchemasNode = null;
        this.properties.clear();
        XMPNode root = this.meta.getRoot();
        if (root != null && (rootChildren = root.getUnmodifiableChildren()) != null) {
            for (Object schema : rootChildren) {
                XMPNode xmpSchema = (XMPNode)schema;
                this.addSchema(xmpSchema);
            }
        }
    }

    private void addSchema(XMPNode xmpSchema) {
        List children = xmpSchema.getUnmodifiableChildren();
        if (children != null) {
            XMPSchemaRegistry registry = XMPMetaFactory.getSchemaRegistry();
            for (Object child : children) {
                XMPNode xmpChild = (XMPNode)child;
                String originalName = xmpChild.getName();
                int prefixEndIndex = originalName.indexOf(":");
                String name = originalName.substring(prefixEndIndex + 1, originalName.length());
                String namespaceURI = registry.getNamespaceURI(originalName.substring(0, Math.max(prefixEndIndex, 0)));
                if ("http://www.aiim.org/pdfa/ns/extension/".equals(namespaceURI) && "schemas".equals(name)) {
                    this.extensionSchemasNode = VeraPDFXMPNode.fromXMPNode(xmpChild);
                    continue;
                }
                this.properties.add(VeraPDFXMPNode.fromXMPNode(xmpChild));
            }
        }
    }

    public static VeraPDFMeta create() {
        XMPMetaImpl xmpMeta = (XMPMetaImpl)XMPMetaFactory.create();
        VeraPDFMeta node = new VeraPDFMeta(xmpMeta);
        node.update();
        return node;
    }

    public static VeraPDFMeta parse(InputStream in) throws XMPException {
        if (in == null) {
            throw new IllegalArgumentException("Metadata InputStream can not be null");
        }
        XMPMetaImpl xmpMeta = (XMPMetaImpl)XMPMetaFactory.parse(in, new ParseOptions().setOmitNormalization(true));
        VeraPDFMeta node = new VeraPDFMeta(xmpMeta);
        node.update();
        return node;
    }

    public static void serialize(VeraPDFMeta veraPDFMeta, OutputStream out) throws XMPException {
        XMPMetaFactory.serialize(veraPDFMeta.meta, out, new SerializeOptions().setUseCanonicalFormat(true));
    }

    public List<VeraPDFXMPNode> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public String getPacketHeader() {
        return this.packetHeader;
    }

    public String getActualEncoding() {
        return this.meta.getActualEncoding();
    }

    public VeraPDFXMPNode getExtensionSchemasNode() {
        return this.extensionSchemasNode;
    }

    public VeraPDFXMPNode getProperty(String namespaceURI, String name) {
        for (VeraPDFXMPNode node : this.properties) {
            String nodeNamespaceURI = node.getNamespaceURI();
            boolean isNamespaceURIEquals = Objects.equals(namespaceURI, nodeNamespaceURI);
            String nodeName = node.getName();
            boolean isNameEquals = Objects.equals(name, nodeName);
            if (!isNamespaceURIEquals || !isNameEquals) continue;
            return node;
        }
        return null;
    }

    public boolean deleteIdentificationSchema() {
        return this.deleteSchema("http://www.aiim.org/pdfa/ns/id/");
    }

    public boolean deleteUAIdentificationSchema() {
        return this.deleteSchema("http://www.aiim.org/pdfua/ns/id/");
    }

    private boolean deleteSchema(String schemaNS) {
        XMPNode xmpNode;
        boolean isDeleted = false;
        XMPNode schemaRoot = null;
        for (Object child : this.meta.getRoot().getUnmodifiableChildren()) {
            xmpNode = (XMPNode)child;
            if (!schemaNS.equals(xmpNode.getName())) continue;
            schemaRoot = xmpNode;
            break;
        }
        if (schemaRoot != null) {
            for (Object child : schemaRoot.getUnmodifiableChildren()) {
                xmpNode = (XMPNode)child;
                this.meta.deleteProperty(schemaNS, xmpNode.getName());
                isDeleted = true;
            }
            this.update();
        }
        return isDeleted;
    }

    private VeraPDFMeta setSimpleTextProperty(String namespaceURI, String propertyName, String value) throws XMPException {
        if (value == null) {
            this.meta.deleteProperty(namespaceURI, propertyName);
            return this;
        }
        XMPProperty property = this.meta.getProperty(namespaceURI, propertyName);
        if (property != null && !property.getOptions().isSimple()) {
            throw new XMPException("Can not set text value to not simple property", 5);
        }
        this.meta.setProperty(namespaceURI, propertyName, value);
        this.update();
        return this;
    }

    private String getSimpleTextProperty(String namespaceURI, String propertyName) throws XMPException {
        XMPProperty property = this.meta.getProperty(namespaceURI, propertyName);
        if (property != null && !property.getOptions().isSimple()) {
            throw new XMPException("Required property is not simple", 5);
        }
        return property == null ? null : property.getValue();
    }

    private VeraPDFMeta setDefaultAltTextPropertyForDCSchema(String propertyName, String defaultValue) throws XMPException {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Argument defaultValue can not be null");
        }
        this.meta.setLocalizedText("http://purl.org/dc/elements/1.1/", propertyName, "x", "x-default", defaultValue);
        this.update();
        return this;
    }

    private String getDefaultAltTextPropertyForDCSchema(String propertyName) throws XMPException {
        XMPProperty title = this.meta.getLocalizedText("http://purl.org/dc/elements/1.1/", propertyName, "x", "x-default");
        return title == null ? null : title.getValue();
    }

    public String getTitle() throws XMPException {
        return this.getDefaultAltTextPropertyForDCSchema("title");
    }

    public VeraPDFMeta setTitle(String title) throws XMPException {
        return this.setDefaultAltTextPropertyForDCSchema("title", title);
    }

    public List<String> getCreator() throws XMPException {
        XMPProperty creator = this.meta.getProperty("http://purl.org/dc/elements/1.1/", "creator");
        if (creator == null) {
            return null;
        }
        if (!creator.getOptions().isArrayOrdered()) {
            throw new XMPException("Creator property of dublin core schema is not an ordered array", 5);
        }
        int size = this.meta.countArrayItems("http://purl.org/dc/elements/1.1/", "creator");
        ArrayList<String> res = new ArrayList<String>(size);
        for (int i = 1; i <= size; ++i) {
            XMPProperty item = this.meta.getArrayItem("http://purl.org/dc/elements/1.1/", "creator", i);
            if (!item.getOptions().isSimple()) {
                throw new XMPException("Some entry in creator property of dublin core schema is not simple text", 5);
            }
            res.add(item.getValue());
        }
        return res;
    }

    public VeraPDFMeta setCreator(List<String> creator) throws XMPException {
        if (creator == null) {
            throw new IllegalArgumentException("Argument creator can not be null");
        }
        this.meta.deleteProperty("http://purl.org/dc/elements/1.1/", "creator");
        for (String entry : creator) {
            this.meta.appendArrayItem("http://purl.org/dc/elements/1.1/", "creator", new PropertyOptions().setArrayOrdered(true), entry, new PropertyOptions());
        }
        this.update();
        return this;
    }

    public String getDescription() throws XMPException {
        return this.getDefaultAltTextPropertyForDCSchema("description");
    }

    public VeraPDFMeta setDescription(String description) throws XMPException {
        return this.setDefaultAltTextPropertyForDCSchema("description", description);
    }

    public String getKeywords() throws XMPException {
        return this.getSimpleTextProperty("http://ns.adobe.com/pdf/1.3/", "Keywords");
    }

    public VeraPDFMeta setKeywords(String keywords) throws XMPException {
        return this.setSimpleTextProperty("http://ns.adobe.com/pdf/1.3/", "Keywords", keywords);
    }

    public String getCreatorTool() throws XMPException {
        return this.getSimpleTextProperty("http://ns.adobe.com/xap/1.0/", "CreatorTool");
    }

    public VeraPDFMeta setCreatorTool(String creatorTool) throws XMPException {
        return this.setSimpleTextProperty("http://ns.adobe.com/xap/1.0/", "CreatorTool", creatorTool);
    }

    public String getProducer() throws XMPException {
        return this.getSimpleTextProperty("http://ns.adobe.com/pdf/1.3/", "Producer");
    }

    public VeraPDFMeta setProducer(String producer) throws XMPException {
        return this.setSimpleTextProperty("http://ns.adobe.com/pdf/1.3/", "Producer", producer);
    }

    public Calendar getCreateDate() throws XMPException {
        String value = this.getSimpleTextProperty("http://ns.adobe.com/xap/1.0/", "CreateDate");
        return value == null ? null : XMPDateTimeFactory.createFromISO8601(value).getCalendar();
    }

    public VeraPDFMeta setCreateDate(Calendar createDate) throws XMPException {
        if (createDate == null) {
            throw new IllegalArgumentException("Argument createDate can not be null");
        }
        XMPDateTime date = XMPDateTimeFactory.createFromCalendar(createDate);
        return this.setSimpleTextProperty("http://ns.adobe.com/xap/1.0/", "CreateDate", date.getISO8601String());
    }

    public Calendar getModifyDate() throws XMPException {
        String value = this.getSimpleTextProperty("http://ns.adobe.com/xap/1.0/", "ModifyDate");
        return value == null ? null : XMPDateTimeFactory.createFromISO8601(value).getCalendar();
    }

    public VeraPDFMeta setModifyDate(Calendar modifyDate) throws XMPException {
        if (modifyDate == null) {
            throw new IllegalArgumentException("Argument modifyDate can not be null");
        }
        XMPDateTime date = XMPDateTimeFactory.createFromCalendar(modifyDate);
        return this.setSimpleTextProperty("http://ns.adobe.com/xap/1.0/", "ModifyDate", date.getISO8601String());
    }

    public Integer getIdentificationPart() throws XMPException {
        String stringValue = this.getSimpleTextProperty("http://www.aiim.org/pdfa/ns/id/", PART);
        try {
            return stringValue == null ? null : Integer.valueOf(Integer.parseInt(stringValue));
        }
        catch (NumberFormatException e) {
            throw new XMPException("Property part of PDFA Identification schema contains not integer value", 5, e);
        }
    }

    public Integer getUAIdentificationPart() throws XMPException {
        String stringValue = this.getSimpleTextProperty("http://www.aiim.org/pdfua/ns/id/", PART);
        try {
            return stringValue == null ? null : Integer.valueOf(Integer.parseInt(stringValue));
        }
        catch (NumberFormatException e) {
            throw new XMPException("Property part of PDFUA Identification schema contains not integer value", 5, e);
        }
    }

    public VeraPDFMeta setIdentificationPart(Integer identificationPart) throws XMPException {
        String value = identificationPart == null ? null : identificationPart.toString();
        return this.setSimpleTextProperty("http://www.aiim.org/pdfa/ns/id/", PART, value);
    }

    public VeraPDFMeta setUAIdentificationPart(Integer identificationPart) throws XMPException {
        String value = identificationPart == null ? null : identificationPart.toString();
        return this.setSimpleTextProperty("http://www.aiim.org/pdfua/ns/id/", PART, value);
    }

    public String getIdentificationConformance() throws XMPException {
        return this.getSimpleTextProperty("http://www.aiim.org/pdfa/ns/id/", CONFORMANCE);
    }

    public String getRevisionYear() throws XMPException {
        return this.getSimpleTextProperty("http://www.aiim.org/pdfa/ns/id/", REVISION_YEAR);
    }

    public VeraPDFMeta setIdentificationConformance(String identificationConformance) throws XMPException {
        return this.setSimpleTextProperty("http://www.aiim.org/pdfa/ns/id/", CONFORMANCE, identificationConformance);
    }

    public VeraPDFMeta setIdentificationRevisionYear(String identificationConformance) throws XMPException {
        return this.setSimpleTextProperty("http://www.aiim.org/pdfa/ns/id/", REVISION_YEAR, identificationConformance);
    }

    public XMPMeta getCloneOfInitialMeta() {
        return (XMPMeta)this.meta.clone();
    }
}

