/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.impl.XMPNode;
import com.adobe.xmp.options.PropertyOptions;
import java.util.ArrayList;
import java.util.List;

public class VeraPDFXMPNode {
    private XMPNode originalNode;
    private String namespaceURI;
    private String prefix;
    private String name;
    private String value;
    private List<VeraPDFXMPNode> children;
    private PropertyOptions options;

    private VeraPDFXMPNode(String prefix, String namespaceURI, String name, String value, List<VeraPDFXMPNode> children, PropertyOptions options, XMPNode originalNode) {
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
        this.name = name;
        this.value = value;
        this.children = children;
        this.options = options;
        this.originalNode = originalNode;
    }

    static VeraPDFXMPNode fromXMPNode(XMPNode original) {
        if (original == null) {
            return null;
        }
        String prefix = original.getOriginalPrefix();
        String originalName = original.getName();
        int prefixEndIndex = originalName.indexOf(":");
        String name = originalName.substring(prefixEndIndex + 1, originalName.length());
        String value = original.getValue();
        PropertyOptions options = original.getOptions();
        List originalChildren = original.getUnmodifiableChildren();
        ArrayList<VeraPDFXMPNode> children = new ArrayList<VeraPDFXMPNode>(originalChildren.size());
        for (Object child : originalChildren) {
            children.add(VeraPDFXMPNode.fromXMPNode((XMPNode)child));
        }
        String namespaceURI = XMPMetaFactory.getSchemaRegistry().getNamespaceURI(originalName.substring(0, Math.max(prefixEndIndex, 0)));
        return new VeraPDFXMPNode(prefix, namespaceURI, name, value, children, options, original);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isLanguageAlternative() {
        if (this.children.isEmpty()) {
            return false;
        }
        for (VeraPDFXMPNode node : this.children) {
            List elems = node.getQualifier();
            boolean hasLanguageNode = false;
            for (Object elem : elems) {
                if (!((XMPNode)elem).isLanguageNode()) continue;
                hasLanguageNode = true;
            }
            if (hasLanguageNode) continue;
            return false;
        }
        return true;
    }

    public List getQualifier() {
        return this.originalNode.getQualifier();
    }

    public List<VeraPDFXMPNode> getChildren() {
        return this.children;
    }

    public PropertyOptions getOptions() {
        return this.options;
    }
}

