/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.impl.ByteBuffer;
import com.adobe.xmp.impl.FixASCIIControlsReader;
import com.adobe.xmp.impl.Latin1Converter;
import com.adobe.xmp.impl.ParameterAsserts;
import com.adobe.xmp.impl.ParseRDF;
import com.adobe.xmp.impl.XMPMetaImpl;
import com.adobe.xmp.impl.XMPNormalizer;
import com.adobe.xmp.options.ParseOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMPMetaParser {
    private static final Object XMP_RDF = new Object();
    private static DocumentBuilderFactory factory = XMPMetaParser.createDocumentBuilderFactory();
    private String actualEncoding;

    private XMPMetaParser() {
    }

    public static XMPMeta parse(Object input, ParseOptions options) throws XMPException {
        ParameterAsserts.assertNotNull(input);
        options = options != null ? options : new ParseOptions();
        XMPMetaParser xmpMetaParser = new XMPMetaParser();
        Document document = xmpMetaParser.parseXml(input, options);
        if (xmpMetaParser.actualEncoding == null) {
            xmpMetaParser.actualEncoding = document.getInputEncoding();
        }
        boolean xmpmetaRequired = options.getRequireXMPMeta();
        Object[] result = new Object[3];
        if ((result = XMPMetaParser.findRootNode(document, xmpmetaRequired, result)) != null && result[1] == XMP_RDF) {
            XMPMetaImpl xmp = ParseRDF.parse((Node)result[0]);
            xmp.setActualEncoding(xmpMetaParser.actualEncoding);
            xmp.setPacketHeader((String)result[2]);
            if (!options.getOmitNormalization()) {
                return XMPNormalizer.process(xmp, options);
            }
            return xmp;
        }
        return new XMPMetaImpl();
    }

    private Document parseXml(Object input, ParseOptions options) throws XMPException {
        if (input instanceof InputStream) {
            return this.parseXmlFromInputStream((InputStream)input, options);
        }
        if (input instanceof byte[]) {
            return this.parseXmlFromBytebuffer(new ByteBuffer((byte[])input), options);
        }
        return this.parseXmlFromString((String)input, options);
    }

    private Document parseXmlFromInputStream(InputStream stream, ParseOptions options) throws XMPException {
        if (!options.getAcceptLatin1() && !options.getFixControlChars()) {
            return this.parseInputSource(new InputSource(stream));
        }
        try {
            ByteBuffer buffer = new ByteBuffer(stream);
            return this.parseXmlFromBytebuffer(buffer, options);
        }
        catch (IOException e) {
            throw new XMPException("Error reading the XML-file", 204, e);
        }
    }

    private Document parseXmlFromBytebuffer(ByteBuffer buffer, ParseOptions options) throws XMPException {
        InputSource source = new InputSource(buffer.getByteStream());
        try {
            return this.parseInputSource(source);
        }
        catch (XMPException e) {
            if (e.getErrorCode() == 201 || e.getErrorCode() == 204) {
                if (options.getAcceptLatin1()) {
                    buffer = Latin1Converter.convert(buffer);
                }
                if (options.getFixControlChars()) {
                    try {
                        String encoding = buffer.getEncoding();
                        if (this.actualEncoding == null) {
                            this.actualEncoding = encoding;
                        }
                        FixASCIIControlsReader fixReader = new FixASCIIControlsReader(new InputStreamReader(buffer.getByteStream(), encoding));
                        return this.parseInputSource(new InputSource(fixReader));
                    }
                    catch (UnsupportedEncodingException e1) {
                        throw new XMPException("Unsupported Encoding", 9, e);
                    }
                }
                source = new InputSource(buffer.getByteStream());
                return this.parseInputSource(source);
            }
            throw e;
        }
    }

    private Document parseXmlFromString(String input, ParseOptions options) throws XMPException {
        InputSource source = new InputSource(new StringReader(input));
        try {
            return this.parseInputSource(source);
        }
        catch (XMPException e) {
            if (e.getErrorCode() == 201 && options.getFixControlChars()) {
                source = new InputSource(new FixASCIIControlsReader(new StringReader(input)));
                return this.parseInputSource(source);
            }
            throw e;
        }
    }

    private Document parseInputSource(InputSource source) throws XMPException {
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(null);
            return builder.parse(source);
        }
        catch (SAXException e) {
            throw new XMPException("XML parsing failure", 201, e);
        }
        catch (ParserConfigurationException e) {
            throw new XMPException("XML Parser not correctly configured", 0, e);
        }
        catch (IOException e) {
            throw new XMPException("Error reading the XML-file", 204, e);
        }
    }

    private static Object[] findRootNode(Node root, boolean xmpmetaRequired, Object[] result) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            root = children.item(i);
            if (7 == root.getNodeType() && "xpacket".equals(((ProcessingInstruction)root).getTarget())) {
                if (result == null) continue;
                result[2] = ((ProcessingInstruction)root).getData();
                continue;
            }
            if (3 == root.getNodeType() || 7 == root.getNodeType()) continue;
            String rootNS = root.getNamespaceURI();
            String rootLocal = root.getLocalName();
            if (("xmpmeta".equals(rootLocal) || "xapmeta".equals(rootLocal)) && "adobe:ns:meta/".equals(rootNS)) {
                return XMPMetaParser.findRootNode(root, false, result);
            }
            if (!xmpmetaRequired && "RDF".equals(rootLocal) && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(rootNS)) {
                if (result != null) {
                    result[0] = root;
                    result[1] = XMP_RDF;
                }
                return result;
            }
            Object[] newResult = XMPMetaParser.findRootNode(root, xmpmetaRequired, result);
            if (newResult == null) continue;
            return newResult;
        }
        return null;
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return factory;
    }
}

