/**
 * This file is part of veraPDF PDF/A XMP Library Core, a module of the veraPDF project.
 * Copyright (c) 2015-2024, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF PDF/A XMP Library Core is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF PDF/A XMP Library Core as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF PDF/A XMP Library Core as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.xmp.containers;

import java.util.*;

public class StaticXmpCoreContainers {

    /**
     * a map from a namespace URI to its registered prefix
     */
    private static final ThreadLocal<Map<String, String>> namespaceToPrefixMap = new ThreadLocal<>();

    /**
     * a map from a prefix to the associated namespace URI
     */
    private static final ThreadLocal<Map<String, String>> prefixToNamespaceMap = new ThreadLocal<>();

    public static void clearAllContainers() {
        namespaceToPrefixMap.set(new HashMap<>());
        prefixToNamespaceMap.set(new HashMap<>());
    }

    public static Map<String, String> getNamespaceToPrefixMap() {
        return namespaceToPrefixMap.get();
    }

    public static Map<String, String> getPrefixToNamespaceMap() {
        return prefixToNamespaceMap.get();
    }

    public static void setNamespaceToPrefixMap(Map<String, String> namespaceToPrefixMap) {
        StaticXmpCoreContainers.namespaceToPrefixMap.set(namespaceToPrefixMap);
    }

    public static void setPrefixToNamespaceMap(Map<String, String> prefixToNamespaceMap) {
        StaticXmpCoreContainers.prefixToNamespaceMap.set(prefixToNamespaceMap);
    }
}
