/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.content;

import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;

public abstract class InfoChunk
implements IChunk {
    private BoundingBox boundingBox;

    public InfoChunk() {
        this.boundingBox = new BoundingBox();
    }

    public InfoChunk(BoundingBox bbox) {
        this.setBoundingBox(bbox);
    }

    @Override
    public double getLeftX() {
        return this.boundingBox.getLeftX();
    }

    @Override
    public double getBottomY() {
        return this.boundingBox.getBottomY();
    }

    @Override
    public double getRightX() {
        return this.boundingBox.getRightX();
    }

    @Override
    public double getTopY() {
        return this.boundingBox.getTopY();
    }

    @Override
    public double getCenterX() {
        return this.boundingBox.getCenterX();
    }

    @Override
    public double getCenterY() {
        return this.boundingBox.getCenterY();
    }

    @Override
    public void setLastPageNumber(int lastPageNumber) {
        this.boundingBox.setLastPageNumber(lastPageNumber);
    }

    @Override
    public void setPageNumber(int pageNumber) {
        this.boundingBox.setPageNumber(pageNumber);
    }

    @Override
    public Integer getPageNumber() {
        return this.boundingBox.getPageNumber();
    }

    @Override
    public Integer getLastPageNumber() {
        return this.boundingBox.getLastPageNumber();
    }

    @Override
    public void setBoundingBox(BoundingBox bbox) {
        this.boundingBox = bbox instanceof MultiBoundingBox ? new MultiBoundingBox(bbox) : new BoundingBox(bbox);
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public int hashCode() {
        return Objects.hashCode(this.boundingBox);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfoChunk that = (InfoChunk)o;
        return that.boundingBox.equals(this.boundingBox);
    }

    protected void unionBoundingBox(BoundingBox bbox) {
        this.boundingBox.union(bbox);
    }
}

