/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.IDocument;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.geometry.Vertex;
import org.verapdf.wcag.algorithms.entities.tables.TableBorderBuilder;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;

public class LinesPreprocessingConsumer {
    private static final double MAX_LINE_WIDTH = 5.0;
    private final IDocument document;
    private List<List<TableBorderBuilder>> tableBorders;

    public LinesPreprocessingConsumer(IDocument document) {
        this.document = document;
    }

    public List<List<TableBorderBuilder>> getTableBorders() {
        if (this.tableBorders == null) {
            this.findTableBorders();
        }
        return this.tableBorders;
    }

    public void findTableBorders() {
        this.tableBorders = new LinkedList<List<TableBorderBuilder>>();
        for (int pageNumber = 0; pageNumber < this.document.getPages().size(); ++pageNumber) {
            this.tableBorders.add(this.findTableBorders(pageNumber));
        }
    }

    private List<TableBorderBuilder> findTableBorders(Integer pageNumber) {
        TableBorderBuilder border4;
        LinkedList<TableBorderBuilder> tableBorders = new LinkedList<TableBorderBuilder>();
        HashSet<LineChunk> set = new HashSet<LineChunk>(StaticContainers.getLinesCollection().getHorizontalLines(pageNumber));
        set.addAll(StaticContainers.getLinesCollection().getVerticalLines(pageNumber));
        set.addAll(StaticContainers.getLinesCollection().getSquares(pageNumber));
        for (LineChunk line : set) {
            if (line.getWidth() > 5.0) continue;
            boolean separateTableBorder = true;
            for (TableBorderBuilder border2 : tableBorders) {
                Vertex vv;
                boolean isCross = false;
                if (line.isHorizontalLine()) {
                    for (LineChunk verticalLine : border2.getVerticalLines()) {
                        vv = LineChunk.getIntersectionVertex(line, verticalLine);
                        if (vv == null) continue;
                        border2.addVertex(vv);
                        isCross = true;
                    }
                } else if (line.isVerticalLine()) {
                    for (LineChunk horizontalLine : border2.getHorizontalLines()) {
                        vv = LineChunk.getIntersectionVertex(horizontalLine, line);
                        if (vv == null) continue;
                        border2.addVertex(vv);
                        isCross = true;
                    }
                }
                if (!isCross) continue;
                border2.addLine(line);
                separateTableBorder = false;
                break;
            }
            if (!separateTableBorder) continue;
            TableBorderBuilder border3 = new TableBorderBuilder(line);
            tableBorders.add(border3);
        }
        this.mergeTableBorders(tableBorders);
        int i = 0;
        while (i < tableBorders.size()) {
            border4 = (TableBorderBuilder)tableBorders.get(i);
            if (border4.getVertexesNumber() <= 2 || border4.getHorizontalLinesNumber() == 0 || border4.getVerticalLinesNumber() == 0) {
                tableBorders.remove(i);
                continue;
            }
            ++i;
        }
        for (TableBorderBuilder border4 : tableBorders) {
            for (LineChunk lineChunk : border4.getVerticalLines()) {
                StaticContainers.getLinesCollection().getVerticalLines(pageNumber).remove(lineChunk);
            }
            for (LineChunk lineChunk : border4.getHorizontalLines()) {
                StaticContainers.getLinesCollection().getHorizontalLines(pageNumber).remove(lineChunk);
            }
        }
        i = 0;
        while (i < tableBorders.size()) {
            border4 = (TableBorderBuilder)tableBorders.get(i);
            if (border4.getHorizontalLinesNumber() <= 2 && border4.getVerticalLinesNumber() <= 1 || border4.getHorizontalLinesNumber() <= 1 && border4.getVerticalLinesNumber() <= 2) {
                tableBorders.remove(i);
                continue;
            }
            ++i;
        }
        return tableBorders;
    }

    private void mergeTableBorders(List<TableBorderBuilder> tableBorders) {
        for (int i = tableBorders.size() - 2; i >= 0; --i) {
            TableBorderBuilder border = tableBorders.get(i);
            int j = i + 1;
            while (j < tableBorders.size()) {
                TableBorderBuilder border2 = tableBorders.get(j);
                if (border.isConnectedBorder(border2)) {
                    border.mergeBorder(border2);
                    tableBorders.remove(j);
                    continue;
                }
                ++j;
            }
        }
    }
}

