/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.content;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.enums.TextFormat;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;

public class TextLine
extends TextInfoChunk {
    private final List<TextChunk> textChunks = new ArrayList<TextChunk>();
    private boolean isLineStart = true;
    private boolean isLineEnd = true;

    public TextLine() {
    }

    public TextLine(TextChunk chunk) {
        super(chunk.getBoundingBox(), chunk.getFontSize(), chunk.getBaseLine(), chunk.getSlantDegree());
        this.textChunks.add(chunk);
    }

    public TextLine(TextLine line) {
        super(line.getBoundingBox(), line.getFontSize(), line.getBaseLine(), line.getSlantDegree());
        this.textChunks.addAll(line.getTextChunks());
    }

    public List<TextChunk> getTextChunks() {
        return this.textChunks;
    }

    public TextChunk getFirstTextChunk() {
        if (this.textChunks.isEmpty()) {
            return null;
        }
        return this.textChunks.get(0);
    }

    public TextChunk getLastTextChunk() {
        if (this.textChunks.isEmpty()) {
            return null;
        }
        return this.textChunks.get(this.textChunks.size() - 1);
    }

    public TextChunk getLastNormalTextChunk() {
        for (int i = this.textChunks.size() - 2; i >= 0; --i) {
            TextChunk textChunk = this.textChunks.get(i);
            if (!TextFormat.NORMAL.equals((Object)textChunk.getTextFormat())) continue;
            return textChunk;
        }
        return null;
    }

    public void add(TextChunk chunk) {
        this.textChunks.add(chunk);
        super.add(chunk);
    }

    public void add(TextLine line) {
        double size = this.fontSize;
        this.textChunks.addAll(line.getTextChunks());
        super.add(line);
        if (line.isSpaceLine()) {
            this.fontSize = size;
        } else if (this.isSpaceLine()) {
            this.fontSize = line.getFontSize();
        }
    }

    @Override
    public String getValue() {
        if (this.textChunks.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(this.textChunks.get(0).getValue());
        for (int i = 1; i < this.textChunks.size(); ++i) {
            result.append(this.textChunks.get(i).getValue());
        }
        return result.toString();
    }

    public boolean isEmpty() {
        return this.textChunks.isEmpty() || this.textChunks.stream().allMatch(TextChunk::isEmpty);
    }

    public boolean isSpaceLine() {
        for (TextChunk textChunk : this.textChunks) {
            if (TextChunkUtils.isWhiteSpaceChunk(textChunk)) continue;
            return false;
        }
        return true;
    }

    public boolean isFullLine() {
        return this.isLineStart && this.isLineEnd;
    }

    public boolean isLineStart() {
        return this.isLineStart;
    }

    public void setNotLineStart() {
        this.isLineStart = false;
    }

    public boolean isLineEnd() {
        return this.isLineEnd;
    }

    public void setNotLineEnd() {
        this.isLineEnd = false;
    }

    public String toString() {
        if (this.textChunks.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(this.textChunks.get(0).getValue());
        for (int i = 1; i < this.textChunks.size(); ++i) {
            result.append(' ').append(this.textChunks.get(i).getValue());
        }
        return result.toString();
    }
}

