/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticCaption;
import org.verapdf.wcag.algorithms.entities.SemanticFigure;
import org.verapdf.wcag.algorithms.entities.SemanticHeading;
import org.verapdf.wcag.algorithms.entities.SemanticImageNode;
import org.verapdf.wcag.algorithms.entities.SemanticNode;
import org.verapdf.wcag.algorithms.entities.SemanticNumberHeading;
import org.verapdf.wcag.algorithms.entities.SemanticParagraph;
import org.verapdf.wcag.algorithms.entities.SemanticPart;
import org.verapdf.wcag.algorithms.entities.SemanticSpan;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.content.TextBlock;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextColumn;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.enums.TextFormat;
import org.verapdf.wcag.algorithms.entities.lists.ListInterval;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.CaptionUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ChunksMergeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ListLabelsUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ListUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;

public class AccumulatedNodeConsumer
implements Consumer<INode> {
    private static final Logger LOGGER = Logger.getLogger(AccumulatedNodeConsumer.class.getCanonicalName());
    public static final double MERGE_PROBABILITY_THRESHOLD = 0.75;
    public static final double ONE_LINE_MIN_PROBABILITY_THRESHOLD = 0.1;
    public static final double FOOTNOTE_MIN_PROBABILITY_THRESHOLD = 0.1;

    @Override
    public void accept(INode node) {
        if (node.getChildren().isEmpty()) {
            StaticContainers.getAccumulatedNodeMapper().updateNode(node, node, 1.0, node.getSemanticType());
            return;
        }
        boolean isLeafChild = node.getChildren().stream().allMatch(child -> child instanceof SemanticSpan || child instanceof SemanticImageNode || child instanceof SemanticFigure || child.getSemanticType() == null);
        this.acceptSpanParagraphPart(node, isLeafChild);
        this.acceptSemanticImage(node);
        this.checkSemanticSpanChildren(node);
        if (!isLeafChild) {
            this.acceptChildrenSemanticHeading(node);
            this.acceptSemanticList(node);
            this.acceptChildrenSemanticCaption(node);
        }
    }

    private void checkSemanticSpanChildren(INode node) {
        INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
        if (!(accumulatedNode instanceof SemanticTextNode)) {
            return;
        }
        if (node.getChildren().stream().noneMatch(child -> child instanceof SemanticSpan)) {
            return;
        }
        SemanticTextNode textNode = (SemanticTextNode)accumulatedNode;
        for (INode child2 : node.getChildren()) {
            if (!(child2 instanceof SemanticSpan)) continue;
            for (TextColumn textColumn : ((SemanticSpan)child2).getColumns()) {
                for (TextLine textLine : textColumn.getLines()) {
                    for (TextChunk textChunk : textLine.getTextChunks()) {
                        if (TextChunkUtils.isWhiteSpaceChunk(textChunk) || Objects.equals(textNode.getFontSize(), textChunk.getFontSize()) && Objects.equals(textNode.getItalicAngle(), textChunk.getItalicAngle()) && Arrays.equals(textNode.getTextColor(), textChunk.getFontColor()) && Objects.equals(textNode.getFontWeight(), textChunk.getFontWeight())) continue;
                        textChunk.setHasSpecialStyle();
                    }
                }
            }
        }
    }

    private void acceptSemanticImage(INode node) {
        SemanticNode imageNode = null;
        SemanticNode lineArtNode = null;
        for (INode child : node.getChildren()) {
            INode accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(child);
            if (accumulatedChild instanceof SemanticTextNode) {
                if (((SemanticTextNode)accumulatedChild).isEmpty() || ((SemanticTextNode)accumulatedChild).isSpaceNode()) continue;
                return;
            }
            if (accumulatedChild instanceof SemanticImageNode) {
                if (imageNode != null || lineArtNode != null) {
                    return;
                }
                imageNode = (SemanticImageNode)accumulatedChild;
                continue;
            }
            if (!(accumulatedChild instanceof SemanticFigure)) continue;
            if (imageNode != null || lineArtNode != null) {
                return;
            }
            lineArtNode = (SemanticFigure)accumulatedChild;
        }
        if (imageNode != null) {
            StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticImageNode((SemanticImageNode)imageNode), imageNode.getCorrectSemanticScore(), SemanticType.FIGURE);
        } else if (lineArtNode != null) {
            StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticFigure((SemanticFigure)lineArtNode), lineArtNode.getCorrectSemanticScore(), SemanticType.FIGURE);
        }
    }

    private void acceptSpanParagraphPart(INode node, boolean isLeafChild) {
        double probability = 1.0;
        SemanticTextNode part = null;
        for (INode child2 : node.getChildren()) {
            if (child2.getSemanticType() == null || SemanticType.isIgnoredStandardType(child2.getInitialSemanticType()) || child2.getSemanticType().equals((Object)SemanticType.FIGURE)) continue;
            INode accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(child2);
            if (part == null) {
                part = this.buildPartFromNode(accumulatedChild);
                probability = accumulatedChild.getCorrectSemanticScore();
                continue;
            }
            probability = Math.min(probability, this.toPartMergeProbability((SemanticPart)part, accumulatedChild));
        }
        SemanticType semanticType = SemanticType.PART;
        SemanticTextNode accumulatedNode = part;
        if (part != null && part.getColumns().stream().allMatch(TextColumn::hasOnlyOneBlock)) {
            boolean isSpan;
            boolean bl = isSpan = SemanticType.SPAN.equals((Object)node.getInitialSemanticType()) && (isLeafChild || node.getChildren().stream().allMatch(child -> child instanceof SemanticSpan || child instanceof SemanticImageNode || child instanceof SemanticFigure || child.getSemanticType() == SemanticType.SPAN || child.getSemanticType() == null));
            if (isSpan) {
                semanticType = SemanticType.SPAN;
                accumulatedNode = new SemanticSpan(part.getBoundingBox(), part.getColumns());
            } else {
                semanticType = SemanticType.PARAGRAPH;
                accumulatedNode = new SemanticParagraph(part.getBoundingBox(), part.getColumns());
            }
        }
        StaticContainers.getAccumulatedNodeMapper().updateNode(node, accumulatedNode, probability, semanticType);
    }

    private SemanticPart buildPartFromNode(INode node) {
        if (this.isNullableSemanticType(node)) {
            return null;
        }
        if (node instanceof SemanticTextNode) {
            SemanticTextNode textNode = (SemanticTextNode)node;
            return new SemanticPart(textNode.getBoundingBox(), textNode.getColumns());
        }
        return null;
    }

    private double toPartMergeProbability(SemanticPart part, INode node) {
        if (this.isNullableSemanticType(node)) {
            return 0.0;
        }
        if (node instanceof SemanticTextNode) {
            return this.toTextNodeMergeProbability(part, (SemanticTextNode)node);
        }
        return 0.0;
    }

    private boolean isNullableSemanticType(INode node) {
        if (node.getSemanticType() == null) {
            LOGGER.log(Level.WARNING, "Node with nullable semantic type: {}", node);
            return true;
        }
        return false;
    }

    private double toTextNodeMergeProbability(SemanticPart currentTextNode, SemanticTextNode nextTextNode) {
        double mergeProbability;
        if (nextTextNode.isEmpty()) {
            return 1.0;
        }
        List<TextLine> lines = nextTextNode.getFirstColumn().getLines();
        TextLine lastLine = currentTextNode.getLastLine();
        TextLine nextLine = nextTextNode.getFirstLine();
        double oneLineProbability = ChunksMergeUtils.countOneLineProbability(nextTextNode, lastLine, nextLine);
        double differentLinesProbability = currentTextNode.getLastColumn().getLinesNumber() > 1 && nextTextNode.getFirstColumn().getLinesNumber() > 1 ? ChunksMergeUtils.toParagraphMergeProbability(lastLine, nextLine) : ChunksMergeUtils.mergeLeadingProbability(lastLine, nextLine);
        double toColumnsMergeProbability = ChunksMergeUtils.toColumnsMergeProbability(lastLine, nextLine);
        double footnoteProbability = ChunksMergeUtils.getFootnoteProbability(currentTextNode, nextTextNode, lastLine, nextLine);
        if (footnoteProbability > Math.max(toColumnsMergeProbability, Math.max(oneLineProbability, differentLinesProbability)) && footnoteProbability > 0.1) {
            mergeProbability = footnoteProbability;
        } else if (oneLineProbability < Math.max(Math.max(differentLinesProbability, toColumnsMergeProbability), 0.1)) {
            if (Math.max(differentLinesProbability, toColumnsMergeProbability) < 0.75) {
                double toPartMergeProbability = 0.0;
                TextLine penultLine = currentTextNode.getPenultLine();
                TextLine secondLine = nextTextNode.getSecondLine();
                if (penultLine != null && secondLine != null) {
                    toPartMergeProbability = ChunksMergeUtils.toPartMergeProbability(lastLine, nextLine, penultLine, secondLine);
                }
                mergeProbability = toPartMergeProbability;
                TextColumn lastColumn = new TextColumn(currentTextNode.getLastColumn());
                lastColumn.getBlocks().addAll(nextTextNode.getFirstColumn().getBlocks());
                currentTextNode.setLastColumn(lastColumn);
                if (nextTextNode.getColumnsNumber() > 1) {
                    currentTextNode.addAll(nextTextNode.getColumns().subList(1, nextTextNode.getColumnsNumber()));
                }
            } else if (differentLinesProbability >= toColumnsMergeProbability) {
                mergeProbability = differentLinesProbability;
                TextColumn lastColumn = new TextColumn(currentTextNode.getLastColumn());
                TextBlock lastBlock = new TextBlock(lastColumn.getLastTextBlock());
                lastBlock.getLines().addAll(lines);
                lastColumn.setLastTextBlock(lastBlock);
                currentTextNode.setLastColumn(lastColumn);
                if (nextTextNode.getColumnsNumber() > 1) {
                    currentTextNode.addAll(nextTextNode.getColumns().subList(1, nextTextNode.getColumnsNumber()));
                }
            } else {
                mergeProbability = toColumnsMergeProbability;
                currentTextNode.addAll(nextTextNode.getColumns());
            }
            nextTextNode.setTextFormat(TextFormat.NORMAL);
        } else {
            this.updateTextChunksFormat(nextTextNode);
            mergeProbability = oneLineProbability;
            lastLine.setNotLineEnd();
            nextLine.setNotLineStart();
            currentTextNode.setLastColumn(new TextColumn(currentTextNode.getLastColumn()));
            TextBlock lastBlock = new TextBlock(currentTextNode.getLastColumn().getLastTextBlock());
            lastLine = new TextLine(lastLine);
            lastLine.add(nextLine);
            lastBlock.setLastLine(lastLine);
            currentTextNode.getLastColumn().setLastTextBlock(lastBlock);
            if (lines.size() > 1) {
                if (currentTextNode.getLastColumn().getLinesNumber() > 2 && lines.size() > 1) {
                    mergeProbability *= ChunksMergeUtils.toParagraphMergeProbability(currentTextNode.getPenultLine(), lastLine);
                }
                if (currentTextNode.getLastColumn().getLinesNumber() > 1 && lines.size() > 2) {
                    mergeProbability *= ChunksMergeUtils.toParagraphMergeProbability(lastLine, lines.get(1));
                }
                currentTextNode.getLastColumn().getLastTextBlock().getLines().addAll(lines.subList(1, lines.size()));
            }
            if (nextTextNode.getColumnsNumber() > 1) {
                currentTextNode.addAll(nextTextNode.getColumns().subList(1, nextTextNode.getColumnsNumber()));
            }
        }
        return nextTextNode.getCorrectSemanticScore() == null ? mergeProbability : Math.min(mergeProbability, nextTextNode.getCorrectSemanticScore());
    }

    private void acceptChildrenSemanticHeading(INode node) {
        ArrayList<INode> children = new ArrayList<INode>(node.getChildren().size());
        for (INode child : node.getChildren()) {
            SemanticTextNode textNode;
            INode accumulatedChild;
            if (child == null || SemanticType.BLOCK_QUOTE.equals((Object)child.getInitialSemanticType()) || !((accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(child)) instanceof SemanticTextNode) || (textNode = (SemanticTextNode)accumulatedChild).isSpaceNode() || textNode.isEmpty()) continue;
            children.add(child);
        }
        if (children.size() <= 1) {
            return;
        }
        if (children.size() == 2) {
            this.acceptSemanticHeading((INode)children.get(0), null, (INode)children.get(1), null);
            return;
        }
        this.acceptSemanticHeading((INode)children.get(0), null, (INode)children.get(1), (INode)children.get(2));
        for (int i = 1; i < children.size() - 2; ++i) {
            this.acceptSemanticHeading((INode)children.get(i), (INode)children.get(i - 1), (INode)children.get(i + 1), (INode)children.get(i + 2));
        }
        this.acceptSemanticHeading((INode)children.get(children.size() - 2), (INode)children.get(children.size() - 3), (INode)children.get(children.size() - 1), null);
        if (node.getNextNode() == null || !((INode)children.get(children.size() - 1)).getPageNumber().equals(node.getNextNode().getPageNumber())) {
            return;
        }
        this.acceptSemanticHeading((INode)children.get(children.size() - 1), (INode)children.get(children.size() - 2), null, null);
    }

    private void acceptSemanticHeading(INode node, INode previousNode, INode nextNode, INode nextNextNode) {
        if (SemanticType.LIST.equals((Object)node.getSemanticType())) {
            return;
        }
        double headingProbability = NodeUtils.headingProbability(StaticContainers.getAccumulatedNodeMapper().get(node), StaticContainers.getAccumulatedNodeMapper().get(previousNode), StaticContainers.getAccumulatedNodeMapper().get(nextNode), StaticContainers.getAccumulatedNodeMapper().get(nextNextNode), node);
        if (headingProbability >= 0.75) {
            INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
            if (node.getInitialSemanticType() == SemanticType.NUMBER_HEADING) {
                if (accumulatedNode instanceof SemanticSpan) {
                    StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticNumberHeading((SemanticSpan)accumulatedNode), headingProbability * node.getCorrectSemanticScore(), SemanticType.NUMBER_HEADING);
                } else if (accumulatedNode instanceof SemanticParagraph) {
                    StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticNumberHeading((SemanticParagraph)accumulatedNode), headingProbability * node.getCorrectSemanticScore(), SemanticType.NUMBER_HEADING);
                } else if (accumulatedNode instanceof SemanticPart) {
                    StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticNumberHeading((SemanticPart)accumulatedNode), headingProbability * node.getCorrectSemanticScore(), SemanticType.NUMBER_HEADING);
                }
            } else if (accumulatedNode instanceof SemanticSpan) {
                StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticHeading((SemanticSpan)accumulatedNode), headingProbability * node.getCorrectSemanticScore(), SemanticType.HEADING);
            } else if (accumulatedNode instanceof SemanticParagraph) {
                StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticHeading((SemanticParagraph)accumulatedNode), headingProbability * node.getCorrectSemanticScore(), SemanticType.HEADING);
            } else if (accumulatedNode instanceof SemanticPart) {
                StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticHeading((SemanticPart)accumulatedNode), headingProbability * node.getCorrectSemanticScore(), SemanticType.HEADING);
            }
        }
    }

    private void acceptChildrenSemanticCaption(INode node) {
        INode imageNode = null;
        INode lastTextNode = null;
        for (INode child : node.getChildren()) {
            if (child == null) continue;
            INode accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(child);
            if (accumulatedChild instanceof SemanticTextNode) {
                SemanticTextNode textNode = (SemanticTextNode)accumulatedChild;
                if (textNode.isSpaceNode() || textNode.isEmpty()) continue;
                if (imageNode != null) {
                    this.acceptImageCaption(imageNode, lastTextNode, child);
                    imageNode = null;
                }
                lastTextNode = child;
                continue;
            }
            if (!(accumulatedChild instanceof SemanticImageNode)) continue;
            if (imageNode != null) {
                this.acceptImageCaption(imageNode, lastTextNode, null);
                lastTextNode = null;
            }
            imageNode = child;
        }
        if (imageNode != null) {
            this.acceptImageCaption(imageNode, lastTextNode, null);
        }
    }

    private void acceptImageCaption(INode imageNode, INode previousNode, INode nextNode) {
        INode captionNode;
        double captionProbability;
        double nextCaptionProbability;
        SemanticImageNode image = (SemanticImageNode)StaticContainers.getAccumulatedNodeMapper().get(imageNode);
        double previousCaptionProbability = CaptionUtils.imageCaptionProbability(previousNode, image);
        if (previousCaptionProbability > (nextCaptionProbability = CaptionUtils.imageCaptionProbability(nextNode, image))) {
            captionProbability = previousCaptionProbability;
            captionNode = previousNode;
        } else {
            captionProbability = nextCaptionProbability;
            captionNode = nextNode;
        }
        if (captionProbability >= 0.75) {
            StaticContainers.getAccumulatedNodeMapper().updateNode(captionNode, new SemanticCaption((SemanticTextNode)StaticContainers.getAccumulatedNodeMapper().get(captionNode)), captionProbability * captionNode.getCorrectSemanticScore(), SemanticType.CAPTION);
        }
    }

    private void acceptSemanticList(INode node) {
        INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
        TableBorder tableBorder = StaticContainers.getTableBordersCollection().getTableBorder(node.getBoundingBox());
        if (accumulatedNode != null && tableBorder != null && tableBorder.getTableBorderCell(accumulatedNode.getBoundingBox()) == null) {
            return;
        }
        ArrayList<INode> textChildren = new ArrayList<INode>(node.getChildren().size());
        ArrayList<TextLine> childrenFirstLines = new ArrayList<TextLine>(node.getChildren().size());
        ArrayList<INode> imageChildren = new ArrayList<INode>(node.getChildren().size());
        ArrayList<ImageChunk> childrenImages = new ArrayList<ImageChunk>(node.getChildren().size());
        ArrayList<INode> lineArtChildren = new ArrayList<INode>(node.getChildren().size());
        ArrayList<LineArtChunk> childrenLineArts = new ArrayList<LineArtChunk>(node.getChildren().size());
        for (INode child : node.getChildren()) {
            LineArtChunk lineArt;
            SemanticTextNode textNode;
            INode accumulatedChild;
            if (child == null || SemanticType.LIST.equals((Object)child.getSemanticType()) || !((accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(child)) instanceof SemanticTextNode) || (textNode = (SemanticTextNode)accumulatedChild).isSpaceNode() || textNode.isEmpty()) continue;
            TextLine line = textNode.getFirstNonSpaceLine();
            textChildren.add(child);
            childrenFirstLines.add(line);
            INode newChild = child;
            while (!newChild.getChildren().isEmpty()) {
                newChild = newChild.getChildren().get(0);
            }
            if (newChild instanceof SemanticImageNode) {
                ImageChunk image = ((SemanticImageNode)newChild).getImage();
                if (!(image.getRightX() <= line.getLeftX()) || !(image.getBoundingBox().getHeight() < 2.5 * line.getBoundingBox().getHeight())) continue;
                imageChildren.add(child);
                childrenImages.add(image);
                continue;
            }
            if (!(newChild instanceof SemanticFigure) || !((lineArt = ((SemanticFigure)newChild).getLineArt()).getRightX() <= line.getLeftX()) || !(lineArt.getBoundingBox().getHeight() < 2.5 * line.getBoundingBox().getHeight())) continue;
            lineArtChildren.add(child);
            childrenLineArts.add(lineArt);
        }
        if (textChildren.size() > 1) {
            ArrayList<String> listItems = new ArrayList<String>(node.getChildren().size());
            for (TextLine line : childrenFirstLines) {
                listItems.add(line.getValue().trim());
            }
            ListUtils.updateTreeWithRecognizedLists(node, textChildren, ListUtils.getChildrenListIntervals(ListLabelsUtils.getListItemsIntervals(listItems), textChildren, childrenFirstLines));
        } else if (textChildren.size() == 1 && SemanticType.LIST.equals((Object)node.getInitialSemanticType()) && ListLabelsUtils.isListLabel(((TextLine)childrenFirstLines.get(0)).getValue().trim())) {
            ListUtils.updateTreeWithRecognizedList(node, textChildren, new ListInterval(0, 0, 1));
        }
        if (imageChildren.size() > 1) {
            ListUtils.updateTreeWithRecognizedLists(node, imageChildren, ListUtils.getChildrenListIntervals(ListLabelsUtils.getImageListItemsIntervals(childrenImages), imageChildren, childrenImages));
        }
        if (lineArtChildren.size() > 1) {
            ListUtils.updateTreeWithRecognizedLists(node, lineArtChildren, ListUtils.getChildrenListIntervals(ListLabelsUtils.getImageListItemsIntervals(childrenLineArts), lineArtChildren, childrenLineArts));
        }
    }

    private void updateTextChunksFormat(SemanticTextNode textNode) {
        TextFormat format = textNode.getTextFormat();
        for (TextColumn column : textNode.getColumns()) {
            for (TextLine line : column.getLines()) {
                for (TextChunk chunk : line.getTextChunks()) {
                    chunk.setTextFormat(format);
                }
            }
        }
    }
}

