/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.containers;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.IDocument;
import org.verapdf.wcag.algorithms.entities.RepeatedCharacters;
import org.verapdf.wcag.algorithms.entities.content.LinesCollection;
import org.verapdf.wcag.algorithms.entities.maps.AccumulatedNodeMapper;
import org.verapdf.wcag.algorithms.entities.tables.TableBordersCollection;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.IdMapper;

public class StaticContainers {
    private static final ThreadLocal<AccumulatedNodeMapper> accumulatedNodeMapper = new ThreadLocal();
    private static final ThreadLocal<TableBordersCollection> tableBordersCollection = new ThreadLocal();
    private static final ThreadLocal<LinesCollection> linesCollection = new ThreadLocal();
    private static final ThreadLocal<List<RepeatedCharacters>> repeatedCharacters = new ThreadLocal();
    private static final ThreadLocal<IdMapper> idMapper = new ThreadLocal();

    public static void clearAllContainers(IDocument document) {
        accumulatedNodeMapper.set(new AccumulatedNodeMapper());
        tableBordersCollection.set(new TableBordersCollection());
        linesCollection.set(new LinesCollection(document));
        repeatedCharacters.set(new ArrayList());
        idMapper.set(new IdMapper());
    }

    public static AccumulatedNodeMapper getAccumulatedNodeMapper() {
        return accumulatedNodeMapper.get();
    }

    public static void setAccumulatedNodeMapper(AccumulatedNodeMapper accumulatedNodeMapper) {
        StaticContainers.accumulatedNodeMapper.set(accumulatedNodeMapper);
    }

    public static TableBordersCollection getTableBordersCollection() {
        return tableBordersCollection.get();
    }

    public static void setTableBordersCollection(TableBordersCollection tableBordersCollection) {
        StaticContainers.tableBordersCollection.set(tableBordersCollection);
    }

    public static LinesCollection getLinesCollection() {
        return linesCollection.get();
    }

    public static void setLinesCollection(LinesCollection linesCollection) {
        StaticContainers.linesCollection.set(linesCollection);
    }

    public static List<RepeatedCharacters> getRepeatedCharacters() {
        return repeatedCharacters.get();
    }

    public static void setRepeatedCharacters(List<RepeatedCharacters> repeatedCharacters) {
        StaticContainers.repeatedCharacters.set(repeatedCharacters);
    }

    public static IdMapper getIdMapper() {
        return idMapper.get();
    }

    public static void setIdMapper(IdMapper idMapper) {
        StaticContainers.idMapper.set(idMapper);
    }
}

