/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.tables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextColumn;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.entities.tables.TableTokenRow;
import org.verapdf.wcag.algorithms.semanticalgorithms.tables.TableClusterGap;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ChunksMergeUtils;

public class TableCluster
extends TextInfoChunk {
    private Long id = null;
    private TableCluster header = null;
    private Integer colNumber = null;
    private List<TableTokenRow> rows = new ArrayList<TableTokenRow>();
    private TableClusterGap minLeftGap = null;
    private TableClusterGap minRightGap = null;

    public TableCluster() {
        super(new MultiBoundingBox());
    }

    public TableCluster(TableToken token) {
        this(new TableTokenRow(token));
    }

    public TableCluster(TableTokenRow row) {
        super(row.getBoundingBox(), row.getFontSize(), row.getBaseLine());
        this.rows.add(row);
    }

    public TableCluster(SemanticTextNode textNode, INode node) {
        super(textNode.getBoundingBox(), textNode.getFontSize(), textNode.getLastBaseline());
        for (TextColumn column : textNode.getColumns()) {
            for (TextLine line : column.getLines()) {
                if (line.isEmpty()) continue;
                TableTokenRow row = new TableTokenRow(new TableToken(line.getTextChunks().get(0), node));
                for (int i = 1; i < line.getTextChunks().size(); ++i) {
                    TextChunk chunk = line.getTextChunks().get(i);
                    row.add(new TableToken(chunk, node));
                }
                this.rows.add(row);
            }
        }
    }

    public static TableCluster getTableCluster(TextInfoChunk chunk) {
        if (chunk instanceof TableCluster) {
            return (TableCluster)chunk;
        }
        if (chunk instanceof TableToken) {
            return new TableCluster((TableToken)chunk);
        }
        throw new IllegalArgumentException();
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setMinLeftGap(TableClusterGap leftGap) {
        this.minLeftGap = leftGap;
    }

    public TableClusterGap getMinLeftGap() {
        return this.minLeftGap;
    }

    public void setMinRightGap(TableClusterGap rightGap) {
        this.minRightGap = rightGap;
    }

    public TableClusterGap getMinRightGap() {
        return this.minRightGap;
    }

    public void setRowNumber(int rowIndex, int rowNumber) {
        this.rows.get(rowIndex).setRowNumber(rowNumber);
    }

    public Integer getRowNumber(int rowIndex) {
        return this.rows.get(rowIndex).getRowNumber();
    }

    public void setColNumber(int colNumber) {
        this.colNumber = colNumber;
    }

    public Integer getColNumber() {
        return this.colNumber;
    }

    public void add(TableToken token) {
        this.add(token, false);
    }

    public void add(TableToken token, boolean newLine) {
        if (newLine || this.rows.isEmpty()) {
            this.rows.add(new TableTokenRow(token));
        } else {
            this.rows.get(this.rows.size() - 1).add(token);
        }
        super.add(token);
    }

    public void add(TableTokenRow row) {
        this.add(row, false);
    }

    public void add(TableTokenRow row, boolean newLine) {
        if (newLine || this.rows.isEmpty()) {
            this.rows.add(row);
        } else {
            TableTokenRow lastLine = this.rows.get(this.rows.size() - 1);
            lastLine.add(row);
        }
        super.add(row);
    }

    public void mergeWithoutRowNumbers(TableCluster other) {
        ArrayList<TableTokenRow> result = new ArrayList<TableTokenRow>();
        int i = 0;
        int j = 0;
        while (i < this.rows.size() && j < other.rows.size()) {
            double tolerance;
            double otherBaseLine;
            TableTokenRow line = this.rows.get(i);
            TableTokenRow otherLine = other.rows.get(j);
            double baseLine = line.getBaseLine();
            if (baseLine > (otherBaseLine = otherLine.getBaseLine()) + (tolerance = 0.9 * Math.min(line.getFontSize(), otherLine.getFontSize()))) {
                result.add(line);
                ++i;
                continue;
            }
            if (baseLine < otherBaseLine - tolerance) {
                result.add(otherLine);
                ++j;
                continue;
            }
            TableTokenRow unitedLine = new TableTokenRow(line);
            unitedLine.add(otherLine);
            result.add(unitedLine);
            ++i;
            ++j;
        }
        while (i < this.rows.size()) {
            result.add(this.rows.get(i));
            ++i;
        }
        while (j < other.rows.size()) {
            result.add(other.rows.get(j));
            ++j;
        }
        this.rows = result;
        super.add(other);
    }

    public List<TableTokenRow> getRows() {
        return this.rows;
    }

    public TableTokenRow getFirstRow() {
        if (this.rows.isEmpty()) {
            return null;
        }
        return this.rows.get(0);
    }

    public TableTokenRow getLastRow() {
        if (this.rows.isEmpty()) {
            return null;
        }
        return this.rows.get(this.rows.size() - 1);
    }

    public TextChunk getFirstToken() {
        if (this.rows.isEmpty()) {
            return null;
        }
        return this.rows.get(0).getFirstTextChunk();
    }

    public TextChunk getLastToken() {
        if (this.rows.isEmpty()) {
            return null;
        }
        return this.rows.get(this.rows.size() - 1).getLastTextChunk();
    }

    public void setHeader(TableCluster header) {
        this.header = header;
    }

    public TableCluster getHeader() {
        return this.header;
    }

    public boolean isHeader() {
        return this == this.header;
    }

    public void updateMinGaps() {
        this.updateMinGap(Side.LEFT);
        this.updateMinGap(Side.RIGHT);
    }

    public void updateMinGap(Side side) {
        TableClusterGap minGap;
        HashMap<TableCluster, Double> gapsMap = new HashMap<TableCluster, Double>();
        HashMap<TableCluster, Integer> countersMap = new HashMap<TableCluster, Integer>();
        for (TableTokenRow row : this.rows) {
            TableClusterGap rowGap = side == Side.LEFT ? row.getLeftGap() : row.getRightGap();
            if (rowGap == null) continue;
            if (gapsMap.containsKey(rowGap.getLink())) {
                gapsMap.put(rowGap.getLink(), (Double)gapsMap.get(rowGap.getLink()) + rowGap.getGap());
                countersMap.put(rowGap.getLink(), (Integer)countersMap.get(rowGap.getLink()) + 1);
                continue;
            }
            gapsMap.put(rowGap.getLink(), rowGap.getGap());
            countersMap.put(rowGap.getLink(), 1);
        }
        if (gapsMap.isEmpty()) {
            return;
        }
        TableClusterGap tableClusterGap = minGap = side == Side.LEFT ? this.getMinLeftGap() : this.getMinRightGap();
        if (minGap == null) {
            minGap = new TableClusterGap(null, Double.MAX_VALUE);
            if (side == Side.LEFT) {
                this.setMinLeftGap(minGap);
            } else {
                this.setMinRightGap(minGap);
            }
        }
        minGap.setGap(Double.MAX_VALUE);
        for (Map.Entry gapEntry : gapsMap.entrySet()) {
            double gap = (Double)gapEntry.getValue() / (double)((Integer)countersMap.get(gapEntry.getKey())).intValue();
            if (!(gap < minGap.getGap())) continue;
            minGap.setLink((TableCluster)gapEntry.getKey());
            minGap.setGap((Double)gapEntry.getValue());
        }
    }

    public void merge(TableCluster other, boolean update) {
        if (this.header == null) {
            this.header = other.getHeader();
        }
        for (TableTokenRow row : this.rows) {
            if (row.getLeftGap() != null && row.getLeftGap().getLink() == other) {
                row.setLeftGap(null);
            }
            if (row.getRightGap() == null || row.getRightGap().getLink() != other) continue;
            row.setRightGap(null);
        }
        HashSet<TableCluster> leftSet = new HashSet<TableCluster>();
        HashSet<TableCluster> rightSet = new HashSet<TableCluster>();
        for (TableTokenRow row : other.getRows()) {
            if (row.getLeftGap() != null) {
                if (row.getLeftGap().getLink() == this) {
                    row.setLeftGap(null);
                } else {
                    leftSet.add(row.getLeftGap().getLink());
                }
            }
            if (row.getRightGap() != null) {
                if (row.getRightGap().getLink() == this) {
                    row.setRightGap(null);
                } else {
                    rightSet.add(row.getRightGap().getLink());
                }
            }
            this.rows.add(row);
        }
        for (TableCluster leftCluster : leftSet) {
            Object rightGap;
            for (TableTokenRow row : leftCluster.getRows()) {
                if (row.getRightGap() == null || row.getRightGap().getLink() != other) continue;
                row.getRightGap().setLink(this);
            }
            if (!update || (rightGap = leftCluster.getMinRightGap()) == null || ((TableClusterGap)rightGap).getLink() != this && ((TableClusterGap)rightGap).getLink() != other) continue;
            leftCluster.updateMinGap(Side.RIGHT);
        }
        for (TableCluster rightCluster : rightSet) {
            TableClusterGap leftGap;
            for (TableTokenRow row : rightCluster.getRows()) {
                if (row.getLeftGap() == null || row.getLeftGap().getLink() != other) continue;
                row.getLeftGap().setLink(this);
            }
            if (!update || (leftGap = rightCluster.getMinLeftGap()) == null || leftGap.getLink() != this && leftGap.getLink() != other) continue;
            rightCluster.updateMinGap(Side.LEFT);
        }
        if (update) {
            if (leftSet.size() > 0) {
                this.updateMinGap(Side.LEFT);
            }
            if (rightSet.size() > 0) {
                this.updateMinGap(Side.RIGHT);
            }
        }
        super.add(other);
    }

    public void sortAndMergeRows() {
        if (this.rows.isEmpty()) {
            return;
        }
        Collections.sort(this.rows, Comparator.comparingInt(TableTokenRow::getRowNumber).thenComparingDouble(y -> -y.getBaseLine()).thenComparingDouble(InfoChunk::getLeftX));
        ArrayList<TableTokenRow> result = new ArrayList<TableTokenRow>();
        TableTokenRow currentRow = this.rows.get(0);
        result.add(currentRow);
        for (int i = 1; i < this.rows.size(); ++i) {
            TableTokenRow row = this.rows.get(i);
            if (Math.abs(row.getBaseLine() - currentRow.getBaseLine()) < 0.9 * row.getFontSize() && ChunksMergeUtils.toLineMergeProbability(currentRow, row) > 0.75) {
                currentRow.add(row);
                continue;
            }
            currentRow = row;
            result.add(currentRow);
        }
        this.rows = result;
    }

    @Override
    public double getFirstBaseLine() {
        return this.getFirstRow().getFirstBaseLine();
    }

    public String toString() {
        if (this.rows.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(this.rows.get(0).toString());
        for (int i = 1; i < this.rows.size(); ++i) {
            result.append('\n').append(this.rows.get(i));
        }
        return result.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public static enum Side {
        LEFT,
        RIGHT;


        public static Side opposite(Side side) {
            if (side == LEFT) {
                return RIGHT;
            }
            return LEFT;
        }
    }
}

