/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils;

import java.util.Arrays;
import java.util.LinkedList;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextColumn;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.TextFormat;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;

public class ChunksMergeUtils {
    private static final double FLOATING_POINT_OPERATIONS_EPS = 1.0E-7;
    private static final double FONT_METRIC_UNIVERSAL_TEMPORARY_THRESHOLD = 0.1;
    private static final double FONT_SIZE_COMPARISON_THRESHOLD = 0.05;
    private static final double FONT_WHITESPACE_COMPARISON_THRESHOLD = 0.33;
    private static final double FONT_LEADING_INTERVAL_STANDARD = 1.0;
    private static final double[] DEFAULT_FONT_CHAR_SPACING_INTERVAL = new double[]{0.0, 0.67};
    private static final double[] DEFAULT_FONT_LEADING_INTERVAL = new double[]{0.2, 1.5};
    private static final double[] PART_FONT_LEADING_INTERVAL = new double[]{0.2, 1.5};
    private static final double TO_LINE_PROBABILITY_THRESHOLD = 0.75;
    private static final double[] NORMAL_LINE_PROBABILITY_PARAMS = new double[]{2.0, 0.033};
    private static final double[] SUPERSCRIPT_PROBABILITY_PARAMS = new double[]{0.69438, 1.70575, 1.43819};
    private static final double[] SUBSCRIPT_PROBABILITY_PARAMS = new double[]{0.71932, 1.0483, 0.37555};
    private static final double[] COLUMNS_PROBABILITY_PARAMS = new double[]{0.75, 0.75};
    private static final double[] FONT_SIZE_DIFFERENCE_PARAMS = new double[]{0.95, 3.97};
    private static final double SUPERSCRIPT_BASELINE_THRESHOLD = 0.1;
    private static final double SUPERSCRIPT_FONTSIZE_THRESHOLD = 0.1;
    private static final double SUBSCRIPT_BASELINE_THRESHOLD = 0.08;
    private static final double SUBSCRIPT_FONTSIZE_THRESHOLD = 0.1;
    private static final double[] FOOTNOTE_PROBABILITY_PARAMS = new double[]{0.35, 0.5, 0.15, 0.4, 0.55, 0.2, 0.05};

    private ChunksMergeUtils() {
    }

    public static double toChunkMergeProbability(TextChunk x, TextChunk y) {
        double resultProbability = 1.0;
        resultProbability *= ChunksMergeUtils.mergeByFontNameProbability(x, y);
        resultProbability *= ChunksMergeUtils.mergeByFontSizeProbability(x, y);
        resultProbability *= ChunksMergeUtils.mergeByFontColorProbability(x, y);
        resultProbability *= ChunksMergeUtils.mergeByBaseLineProbability(x, y);
        return resultProbability *= ChunksMergeUtils.mergeByCharSpacingProbability(x, y);
    }

    public static double getBaseLineDifference(TextInfoChunk x, TextInfoChunk y) {
        double baseLineDiff = x.getBaseLine() - y.getBaseLine();
        if (x.isRightLeftHorizontalText() || x.isBottomUpVerticalText()) {
            baseLineDiff = -baseLineDiff;
        }
        return baseLineDiff /= Math.max(x.getFontSize(), y.getFontSize());
    }

    public static double getCentersDifference(TextChunk x, TextChunk y) {
        double centersDiff = x.getCenterY() - y.getCenterY();
        if (x.isVerticalText()) {
            centersDiff = x.getCenterX() - y.getCenterX();
        }
        return Math.abs(centersDiff /= Math.max(x.getFontSize(), y.getFontSize()));
    }

    public static double getFontSizeDifference(TextInfoChunk x, TextInfoChunk y) {
        double fontSizeDiff = x.getFontSize() - y.getFontSize();
        return fontSizeDiff /= Math.max(x.getFontSize(), y.getFontSize());
    }

    public static double toLineMergeProbability(TextInfoChunk x, TextInfoChunk y) {
        double baseLineDiff = ChunksMergeUtils.getBaseLineDifference(x, y);
        double fontSizeDiff = ChunksMergeUtils.getFontSizeDifference(x, y);
        double charSpacingProbability = ChunksMergeUtils.mergeByCharSpacingProbability(x, y);
        double resultProbability = charSpacingProbability * ChunksMergeUtils.mergeNormalLineProbability(Math.abs(baseLineDiff), Math.abs(fontSizeDiff), NORMAL_LINE_PROBABILITY_PARAMS);
        if (resultProbability < 0.75 && charSpacingProbability > 0.75) {
            double superscriptProbability = charSpacingProbability;
            double subscriptProbability = charSpacingProbability;
            superscriptProbability = fontSizeDiff > 0.1 && baseLineDiff < -0.1 || fontSizeDiff < -0.1 && baseLineDiff > 0.1 ? (superscriptProbability *= ChunksMergeUtils.toLineProbabilityFunction(Math.abs(baseLineDiff), Math.abs(fontSizeDiff), SUPERSCRIPT_PROBABILITY_PARAMS)) : 0.0;
            subscriptProbability = fontSizeDiff > 0.1 && baseLineDiff > 0.08 || fontSizeDiff < -0.1 && baseLineDiff < -0.08 ? (subscriptProbability *= ChunksMergeUtils.toLineProbabilityFunction(Math.abs(baseLineDiff), Math.abs(fontSizeDiff), SUBSCRIPT_PROBABILITY_PARAMS)) : 0.0;
            return Math.max(resultProbability, Math.max(superscriptProbability, subscriptProbability));
        }
        return resultProbability;
    }

    public static double countOneLineProbability(SemanticTextNode secondNode, TextLine lastLine, TextLine nextLine) {
        double oneLineProbability;
        double subscriptProbability;
        TextChunk z;
        TextChunk x = lastLine.getLastTextChunk();
        TextChunk y = nextLine.getFirstTextChunk();
        if (!NodeUtils.areCloseNumbers(x.getSlantDegree(), y.getSlantDegree())) {
            return 0.0;
        }
        double baseLineDiff = ChunksMergeUtils.getBaseLineDifference(x, y);
        double centersDiff = ChunksMergeUtils.getCentersDifference(x, y);
        double fontSizeDiff = ChunksMergeUtils.getFontSizeDifference(x, y);
        if (!TextFormat.NORMAL.equals((Object)x.getTextFormat()) && (z = lastLine.getLastNormalTextChunk()) != null) {
            baseLineDiff = ChunksMergeUtils.getBaseLineDifference(z, y);
            centersDiff = ChunksMergeUtils.getCentersDifference(z, y);
            fontSizeDiff = ChunksMergeUtils.getFontSizeDifference(z, y);
        }
        double normalTextProbability = ChunksMergeUtils.getNormalTextProbabilitySecondChunk(x, y, Math.abs(baseLineDiff) < centersDiff ? baseLineDiff : centersDiff, fontSizeDiff);
        double superscriptProbability = ChunksMergeUtils.getSuperscriptProbabilitySecondChunk(x, y, baseLineDiff, fontSizeDiff);
        if (Math.max(superscriptProbability, subscriptProbability = ChunksMergeUtils.getSubscriptProbabilitySecondChunk(x, y, baseLineDiff, fontSizeDiff)) > normalTextProbability) {
            if (superscriptProbability > subscriptProbability) {
                oneLineProbability = superscriptProbability;
                secondNode.setTextFormat(TextFormat.SUPERSCRIPT);
            } else {
                oneLineProbability = subscriptProbability;
                secondNode.setTextFormat(TextFormat.SUBSCRIPT);
            }
        } else {
            double subscriptProbabilityFirst;
            double superscriptProbabilityFirst = ChunksMergeUtils.getSuperscriptProbabilityFirstChunk(x, y, baseLineDiff, fontSizeDiff);
            if (Math.max(superscriptProbabilityFirst, subscriptProbabilityFirst = ChunksMergeUtils.getSubscriptProbabilityFirstChunk(x, y, baseLineDiff, fontSizeDiff)) > normalTextProbability) {
                if (superscriptProbabilityFirst > subscriptProbabilityFirst) {
                    oneLineProbability = superscriptProbabilityFirst;
                    x.setTextFormat(TextFormat.SUPERSCRIPT);
                } else {
                    oneLineProbability = subscriptProbabilityFirst;
                    x.setTextFormat(TextFormat.SUBSCRIPT);
                }
            } else {
                oneLineProbability = normalTextProbability;
                secondNode.setTextFormat(TextFormat.NORMAL);
            }
        }
        return oneLineProbability;
    }

    public static double getNormalTextProbabilitySecondChunk(TextChunk x, TextChunk y, double baseLineDiff, double fontSizeDiff) {
        return ChunksMergeUtils.mergeByCharSpacingProbability(x, y) * ChunksMergeUtils.mergeNormalLineProbability(Math.abs(baseLineDiff), Math.abs(fontSizeDiff), NORMAL_LINE_PROBABILITY_PARAMS);
    }

    public static double getSuperscriptProbabilitySecondChunk(TextChunk x, TextChunk y, double baseLineDiff, double fontSizeDiff) {
        if (fontSizeDiff > 0.1 && baseLineDiff < -0.1) {
            return ChunksMergeUtils.mergeByCharSpacingProbability(x, y) * ChunksMergeUtils.toLineProbabilityFunction(Math.abs(baseLineDiff), Math.abs(fontSizeDiff), SUPERSCRIPT_PROBABILITY_PARAMS);
        }
        return 0.0;
    }

    public static double getSubscriptProbabilitySecondChunk(TextChunk x, TextChunk y, double baseLineDiff, double fontSizeDiff) {
        if (fontSizeDiff > 0.1 && baseLineDiff > 0.08) {
            return ChunksMergeUtils.mergeByCharSpacingProbability(x, y) * ChunksMergeUtils.toLineProbabilityFunction(Math.abs(baseLineDiff), Math.abs(fontSizeDiff), SUBSCRIPT_PROBABILITY_PARAMS);
        }
        return 0.0;
    }

    public static double getSuperscriptProbabilityFirstChunk(TextChunk x, TextChunk y, double baseLineDiff, double fontSizeDiff) {
        if (fontSizeDiff < -0.1 && baseLineDiff > 0.1) {
            return ChunksMergeUtils.mergeByCharSpacingProbability(x, y) * ChunksMergeUtils.toLineProbabilityFunction(Math.abs(baseLineDiff), Math.abs(fontSizeDiff), SUPERSCRIPT_PROBABILITY_PARAMS);
        }
        return 0.0;
    }

    public static double getSubscriptProbabilityFirstChunk(TextChunk x, TextChunk y, double baseLineDiff, double fontSizeDiff) {
        if (fontSizeDiff < -0.1 && baseLineDiff < -0.08) {
            return ChunksMergeUtils.mergeByCharSpacingProbability(x, y) * ChunksMergeUtils.toLineProbabilityFunction(Math.abs(baseLineDiff), Math.abs(fontSizeDiff), SUBSCRIPT_PROBABILITY_PARAMS);
        }
        return 0.0;
    }

    public static double getFootnoteProbability(SemanticTextNode firstNode, SemanticTextNode secondNode, TextLine lastLine, TextLine nextLine) {
        if (!firstNode.getPageNumber().equals(secondNode.getPageNumber()) || lastLine.getBaseLine() < nextLine.getBaseLine() + FOOTNOTE_PROBABILITY_PARAMS[6]) {
            return 0.0;
        }
        double footnoteProbability = 0.0;
        TextChunk y = nextLine.getFirstTextChunk();
        LinkedList<TextChunk> superscriptTextChunks = new LinkedList<TextChunk>();
        for (TextColumn column : firstNode.getColumns()) {
            for (TextLine line : column.getLines()) {
                for (TextChunk chunk : line.getTextChunks()) {
                    if (chunk.getTextFormat() != TextFormat.SUPERSCRIPT) continue;
                    superscriptTextChunks.add(chunk);
                }
            }
        }
        footnoteProbability = !superscriptTextChunks.isEmpty() ? (footnoteProbability += FOOTNOTE_PROBABILITY_PARAMS[0]) : (footnoteProbability -= FOOTNOTE_PROBABILITY_PARAMS[3]);
        String yValue = y.getValue();
        for (TextChunk chunk : superscriptTextChunks) {
            if (!chunk.getValue().equals(yValue.substring(0, Math.min(chunk.getValue().length(), yValue.length())))) continue;
            footnoteProbability += FOOTNOTE_PROBABILITY_PARAMS[1];
            break;
        }
        if (firstNode.getFontSize() > secondNode.getFontSize() + FOOTNOTE_PROBABILITY_PARAMS[6]) {
            footnoteProbability += FOOTNOTE_PROBABILITY_PARAMS[2];
        } else if (secondNode.getFontSize() > firstNode.getFontSize() + FOOTNOTE_PROBABILITY_PARAMS[6]) {
            footnoteProbability -= FOOTNOTE_PROBABILITY_PARAMS[5];
        }
        return footnoteProbability;
    }

    private static double mergeNormalLineProbability(double x, double y, double[] params) {
        return 1.0 - params[0] * x - params[1] * y;
    }

    private static double toLineProbabilityFunction(double x, double y, double[] params) {
        double result = 1.0 - params[0] * x * x - (params[1] * y - params[2] * x) * y;
        return result;
    }

    public static double toLineMergeProbability(TextLine x, TextLine y) {
        return ChunksMergeUtils.toLineMergeProbability(x.getLastTextChunk(), y.getFirstTextChunk());
    }

    public static double toParagraphMergeProbability(TextLine x, TextLine y) {
        double resultProbability = 1.0;
        resultProbability *= ChunksMergeUtils.mergeLeadingProbability(x, y);
        return resultProbability *= ChunksMergeUtils.mergeIndentationProbability(x, y);
    }

    public static double toPartMergeProbability(TextLine x, TextLine y, TextLine penultLine, TextLine secondLine) {
        double resultProbability = 1.0;
        resultProbability *= ChunksMergeUtils.mergeLeadingProbability(x, y, PART_FONT_LEADING_INTERVAL);
        return resultProbability *= ChunksMergeUtils.mergeIndentationProbability(secondLine, penultLine);
    }

    public static double toColumnsMergeProbability(TextLine x, TextLine y) {
        if (Math.abs(x.getFontSize() - y.getFontSize()) > FONT_SIZE_DIFFERENCE_PARAMS[0]) {
            return 0.0;
        }
        if (x.getLastPageNumber() == null || y.getPageNumber() == null) {
            return 0.0;
        }
        if (x.getLastPageNumber() > y.getPageNumber()) {
            return 0.0;
        }
        if (x.getLastPageNumber().equals(y.getPageNumber())) {
            if (x.getTextEnd() > y.getTextStart()) {
                return 0.0;
            }
            double maxFontSize = Math.max(x.getFontSize(), y.getFontSize());
            if ((y.getTextStart() - x.getTextEnd()) / maxFontSize < COLUMNS_PROBABILITY_PARAMS[0] && Math.abs(x.getBaseLine() - y.getBaseLine()) / maxFontSize < COLUMNS_PROBABILITY_PARAMS[1]) {
                return 0.0;
            }
        }
        return ChunksMergeUtils.mergeByFontSizeProbability(x, y);
    }

    public static double mergeLeadingProbability(TextLine x, TextLine y) {
        return ChunksMergeUtils.mergeLeadingProbability(x, y, DEFAULT_FONT_LEADING_INTERVAL);
    }

    public static double mergeLeadingProbability(TextLine x, TextLine y, double[] fontLeadingInterval) {
        if (Math.abs(x.getFontSize() - y.getFontSize()) > FONT_SIZE_DIFFERENCE_PARAMS[1]) {
            return 0.0;
        }
        if (x.getLastPageNumber() == null || y.getPageNumber() == null) {
            return 0.0;
        }
        if (x.getLastPageNumber() < y.getPageNumber()) {
            return 1.0;
        }
        if (!x.getLastPageNumber().equals(y.getPageNumber())) {
            return 0.0;
        }
        double maxFontSize = Math.max(x.getFontSize(), y.getFontSize());
        double baseLineDifference = x.getBaseLine() - y.getBaseLine();
        return ChunksMergeUtils.getUniformProbability(fontLeadingInterval, baseLineDifference / maxFontSize, 1.0);
    }

    private static double mergeByFontNameProbability(TextChunk x, TextChunk y) {
        return x.getFontName().equals(y.getFontName()) ? 1.0 : 0.0;
    }

    private static double mergeByFontSizeProbability(TextChunk x, TextChunk y) {
        double fontSize2;
        double fontSize1 = x.getFontSize();
        double ratio = fontSize1 < (fontSize2 = y.getFontSize()) ? fontSize1 / fontSize2 : fontSize2 / fontSize1;
        return ChunksMergeUtils.getUniformProbability(new double[]{1.0, 1.0}, ratio, 0.05);
    }

    private static double mergeByFontSizeProbability(TextLine x, TextLine y) {
        double fontSize2;
        double fontSize1 = x.getFontSize();
        double ratio = fontSize1 < (fontSize2 = y.getFontSize()) ? fontSize1 / fontSize2 : fontSize2 / fontSize1;
        return ChunksMergeUtils.getUniformProbability(new double[]{1.0, 1.0}, ratio, 0.05);
    }

    private static double mergeByFontColorProbability(TextChunk x, TextChunk y) {
        return Arrays.equals(x.getFontColor(), y.getFontColor()) ? 1.0 : 0.0;
    }

    private static double mergeByBaseLineProbability(TextChunk x, TextChunk y) {
        return ChunksMergeUtils.getUniformProbability(new double[]{0.0, 1.0E-7}, Math.abs(x.getBaseLine() - y.getBaseLine()), 0.1);
    }

    private static double mergeByCharSpacingProbability(TextInfoChunk x, TextInfoChunk y) {
        if (!NodeUtils.areCloseNumbers(y.getSlantDegree(), x.getSlantDegree())) {
            return 0.0;
        }
        double firstChunkEnd = x.getTextEnd();
        double secondChunkStart = y.getTextStart();
        double distanceBetweenChunks = Math.abs((firstChunkEnd -= (double)ChunksMergeUtils.numberOfEndWhiteSpaces(x.getValue()) * ChunksMergeUtils.whitespaceSize(x.getFontSize())) - (secondChunkStart += (double)ChunksMergeUtils.numberOfStartsWhiteSpaces(y.getValue()) * ChunksMergeUtils.whitespaceSize(y.getFontSize())));
        double maxFontSize = Math.max(x.getFontSize(), y.getFontSize());
        return ChunksMergeUtils.getUniformProbability(DEFAULT_FONT_CHAR_SPACING_INTERVAL, distanceBetweenChunks / maxFontSize, 0.33);
    }

    public static double mergeIndentationProbability(TextLine x, TextLine y) {
        double maxFontSize = Math.max(x.getFontSize(), y.getFontSize());
        double leftXDifference = Math.abs(x.getTextStart() - y.getTextStart());
        double rightXDifference = Math.abs(x.getTextEnd() - y.getTextEnd());
        double centerXDifference = Math.abs(x.getTextCenter() - y.getTextCenter());
        double minDifference = Math.min(leftXDifference, rightXDifference);
        minDifference = Math.min(minDifference, centerXDifference);
        return ChunksMergeUtils.getUniformProbability(new double[]{0.0, 1.0E-7}, minDifference /= maxFontSize, 0.1);
    }

    private static double mergeYAlmostNestedProbability(TextChunk x, TextChunk y) {
        double minBottomY = Math.min(x.getBottomY(), y.getBottomY());
        double maxBottomY = Math.max(x.getBottomY(), y.getBottomY());
        double minTopY = Math.min(x.getTopY(), y.getTopY());
        double maxTopY = Math.max(x.getTopY(), y.getTopY());
        double boundingBoxYIntersection = minTopY - maxBottomY;
        double minBoundingBoxDifference = Math.min(maxBottomY - minBottomY, maxTopY - minTopY);
        double ratio = minBoundingBoxDifference / boundingBoxYIntersection;
        return ChunksMergeUtils.getUniformProbability(new double[]{0.0, 0.0}, ratio, 0.1);
    }

    public static double getUniformProbability(double[] probability1Interval, double point, double initIntervalLength) {
        if (point + 1.0E-7 > probability1Interval[0] && point < probability1Interval[1] + 1.0E-7) {
            return 1.0;
        }
        if (point < probability1Interval[0] - initIntervalLength - 1.0E-7 || point > probability1Interval[1] + initIntervalLength + 1.0E-7) {
            return 0.0;
        }
        double deviation = point < probability1Interval[0] + 1.0E-7 ? probability1Interval[0] - point : point - probability1Interval[1];
        double[] targetProbabilityInterval = new double[]{0.0, 1.0};
        double probabilityFactor = (targetProbabilityInterval[1] - targetProbabilityInterval[0]) / initIntervalLength;
        return (initIntervalLength - deviation) * probabilityFactor + targetProbabilityInterval[0];
    }

    private static int numberOfEndWhiteSpaces(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (TextChunkUtils.isWhiteSpaceChar(str.charAt(i))) continue;
            return str.length() - 1 - i;
        }
        return str.length();
    }

    private static int numberOfStartsWhiteSpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (TextChunkUtils.isWhiteSpaceChar(str.charAt(i))) continue;
            return i;
        }
        return str.length();
    }

    private static double whitespaceSize(double fontSize) {
        return 0.25 * fontSize;
    }
}

