/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.lists;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.lists.ListItem;
import org.verapdf.wcag.algorithms.entities.tables.Table;
import org.verapdf.wcag.algorithms.entities.tables.TableCell;
import org.verapdf.wcag.algorithms.entities.tables.TableRow;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.entities.tables.TableTokenRow;

public class PDFList
extends InfoChunk {
    private final List<ListItem> listItems;

    public PDFList(Table table) {
        super(table.getBoundingBox());
        this.setRecognizedStructureId(table.getId());
        this.listItems = new ArrayList<ListItem>();
        this.createListItemsFromTableRows(table.getRows());
    }

    public PDFList(Long id) {
        this.setRecognizedStructureId(id);
        this.listItems = new ArrayList<ListItem>();
    }

    public int getNumberOfListItems() {
        return this.listItems.size();
    }

    public List<ListItem> getListItems() {
        return this.listItems;
    }

    public void add(ListItem listItem) {
        this.listItems.add(listItem);
        this.getBoundingBox().union(listItem.getBoundingBox());
    }

    public void add(int index, ListItem listItem) {
        this.listItems.add(index, listItem);
        this.getBoundingBox().union(listItem.getBoundingBox());
    }

    private void createListItemsFromTableRows(List<TableRow> tableRows) {
        ListItem lastListItem = null;
        TableCell previousFirstCell = null;
        for (TableRow row : tableRows) {
            TableCell firstCell = row.getCells().get(0);
            if (firstCell.getString().trim().isEmpty() && (firstCell.getContent().isEmpty() || firstCell.getContent().get(0).getType() == TableToken.TableTokenType.TEXT) && lastListItem != null) {
                if (firstCell.getContent().isEmpty() && lastListItem.getLabel().getRightX() > row.getCells().get(1).getLeftX()) {
                    return;
                }
                this.addContentToPreviousListItem(this.listItems.size() > 1 ? this.listItems.get(this.listItems.size() - 2) : null, row.getCells().get(1), previousFirstCell);
                lastListItem.add(row);
                continue;
            }
            this.addContentToPreviousListItem(lastListItem, row.getCells().get(1), firstCell);
            lastListItem = new ListItem(row);
            this.add(lastListItem);
            previousFirstCell = firstCell;
        }
    }

    private void addContentToPreviousListItem(ListItem previousListItem, TableCell secondCell, TableCell firstCell) {
        if (previousListItem == null || firstCell == null) {
            return;
        }
        if (firstCell.getBoundingBox().getTopY() >= secondCell.getBoundingBox().getTopY()) {
            return;
        }
        for (TableTokenRow tokenRow : secondCell.getContent()) {
            if (!(tokenRow.getBoundingBox().getTopY() > firstCell.getBoundingBox().getTopY())) continue;
            previousListItem.getBody().add(tokenRow);
        }
        secondCell.getContent().removeAll(previousListItem.getBody().getContent());
    }
}

