/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.verapdf.wcag.algorithms.entities.IAnnotation;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticHeading;
import org.verapdf.wcag.algorithms.entities.SemanticNumberHeading;
import org.verapdf.wcag.algorithms.entities.SemanticSpan;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextColumn;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.tocs.TOCIInfo;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;

public class TOCDetectionConsumer
implements Consumer<INode> {
    private static final String LINK = "Link";
    private static final String SPACES = "\\s\u00a0\u2007\u202f";
    private static final String SPACES_REGEX = "[\\s\u00a0\u2007\u202f]+";
    private static final String SPACES_DOTS_SPACES_REGEX = "[\\s\u00a0\u2007\u202f]*\\.*[\\s\u00a0\u2007\u202f]*";
    private static final String NON_CONTENT_REGEX = "[\\s\u00a0\u2007\u202f\u2011-]";
    private static final double MAX_RIGHT_ALIGNMENT_GAP = 0.1;
    private static final double LENGTH_HEADING_DIFFERENCE = 1.5;
    private Double right = null;
    private Double maxRight = -1.7976931348623157E308;
    private Integer pagesGap = null;
    private Integer lastPageNumber = null;

    @Override
    public void accept(INode node) {
        this.checkTOC(node);
        this.checkNeighborTOCs(node);
    }

    public void checkTOC(INode node) {
        if (node.getInitialSemanticType() != SemanticType.TABLE_OF_CONTENT) {
            return;
        }
        List<TOCIInfo> infos = this.getTOCIInfos(node);
        ArrayList<Integer> tociIndexes = new ArrayList<Integer>(node.getChildren().size());
        this.right = null;
        this.maxRight = -1.7976931348623157E308;
        this.pagesGap = null;
        this.lastPageNumber = null;
        for (int index = 0; index < node.getChildren().size(); ++index) {
            INode child = node.getChildren().get(index);
            if (child.getInitialSemanticType() == SemanticType.TABLE_OF_CONTENT || !this.checkTOCI(child, infos.get(index))) continue;
            tociIndexes.add(index);
        }
        Long id = StaticContainers.getNextID();
        Iterator iterator = tociIndexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            INode child = node.getChildren().get(index);
            child.setRecognizedStructureId(id);
            StaticContainers.getAccumulatedNodeMapper().updateNode(child, StaticContainers.getAccumulatedNodeMapper().get(child), 1.0, SemanticType.TABLE_OF_CONTENT_ITEM);
        }
        if (tociIndexes.size() > 1 || tociIndexes.size() == 1 && node.getChildren().size() == 1) {
            node.setRecognizedStructureId(id);
            StaticContainers.getAccumulatedNodeMapper().updateNode(node, StaticContainers.getAccumulatedNodeMapper().get(node), 1.0, SemanticType.TABLE_OF_CONTENT);
        }
    }

    private boolean checkTOCI(INode child, TOCIInfo tociInfo) {
        if (tociInfo.getText() == null) {
            child.getErrorCodes().add(1000);
            return false;
        }
        if (tociInfo.getDestinationPageNumber() == null) {
            child.getErrorCodes().add(1001);
            return false;
        }
        if (tociInfo.getPageNumberLabel() != null) {
            if (this.pagesGap == null) {
                this.pagesGap = tociInfo.getPageNumberLabel() - tociInfo.getDestinationPageNumber();
            } else if (tociInfo.getDestinationPageNumber() + this.pagesGap != tociInfo.getPageNumberLabel()) {
                child.getErrorCodes().add(1002);
                return false;
            }
        }
        if (this.lastPageNumber != null && !this.lastPageNumber.equals(child.getPageNumber())) {
            this.right = null;
            this.maxRight = -1.7976931348623157E308;
        }
        this.lastPageNumber = child.getPageNumber();
        if (child.getLeftX() > this.maxRight) {
            this.right = null;
        }
        this.maxRight = Math.max(this.maxRight, tociInfo.getRight());
        if (tociInfo.getPageNumberLabel() != null) {
            if (this.right == null) {
                this.right = tociInfo.getRight();
            } else if (!NodeUtils.areCloseNumbers(this.right, tociInfo.getRight(), 0.1 * tociInfo.getMaxTextSize())) {
                child.getErrorCodes().add(1003);
                return false;
            }
        }
        if (!this.findText(StaticContainers.getDocument().getTree().getRoot(), tociInfo.getText().replaceAll(NON_CONTENT_REGEX, "").toUpperCase(), tociInfo.getDestinationPageNumber())) {
            child.getErrorCodes().add(1005);
            return false;
        }
        return true;
    }

    private List<TOCIInfo> getTOCIInfos(INode node) {
        ArrayList<TOCIInfo> infos = new ArrayList<TOCIInfo>(node.getChildren().size());
        for (int index = 0; index < node.getChildren().size(); ++index) {
            INode child = node.getChildren().get(index);
            if (child.getSemanticType() != SemanticType.TABLE_OF_CONTENT) {
                infos.add(this.getTOCIInfo(child));
                continue;
            }
            infos.add(null);
        }
        return infos;
    }

    private TOCIInfo getTOCIInfo(INode node) {
        TOCIInfo info = new TOCIInfo();
        info.setDestinationPageNumber(this.getDestinationPageNumber(node));
        info.setRight(node.getRightX());
        List<TextChunk> textChunks = TOCDetectionConsumer.getTextChunks(node);
        info.setMaxTextSize(textChunks.stream().map(TextInfoChunk::getFontSize).max(Double::compare).orElse(0.0));
        if (!textChunks.isEmpty()) {
            String pageLabel;
            TextChunk lastChunk = textChunks.get(textChunks.size() - 1);
            String textValue = lastChunk.getValue();
            int pageLabelLength = 0;
            int numberOfSpaces = TOCDetectionConsumer.getNumberOfEndSpaces(textValue);
            info.setRight(lastChunk.getSymbolEndCoordinate(textValue.length() - numberOfSpaces - 1));
            textValue = textValue.substring(0, textValue.length() - numberOfSpaces);
            if (info.getDestinationPageNumber() != null && info.getDestinationPageNumber() < StaticContainers.getDocument().getPages().size() && (pageLabel = StaticContainers.getDocument().getPage(info.getDestinationPageNumber()).getPageLabel()) != null && textValue.toUpperCase().endsWith(pageLabel.toUpperCase())) {
                info.setPageNumberLabel(info.getDestinationPageNumber());
                pageLabelLength = pageLabel.length();
            }
            if (info.getPageNumberLabel() == null) {
                pageLabelLength = TOCDetectionConsumer.getNumberOfEndDigits(textValue);
                info.setPageNumberLabel(TOCDetectionConsumer.getPageNumberLabel(textValue, textValue.length() - pageLabelLength));
            }
            textValue = textChunks.stream().map(TextChunk::getValue).collect(Collectors.joining(""));
            textValue = textValue.substring(0, textValue.length() - numberOfSpaces - pageLabelLength);
            textValue = textValue.substring(0, TOCDetectionConsumer.getLastRegexIndex(textValue, SPACES_DOTS_SPACES_REGEX));
            info.setText(textValue);
        }
        return info;
    }

    private Integer getDestinationPageNumber(INode node) {
        List linkAnnotations = TOCDetectionConsumer.getInheritorAnnotations(node).stream().filter(x -> LINK.equals(x.getAnnotationType())).collect(Collectors.toList());
        for (IAnnotation goToAnnotation : linkAnnotations) {
            Integer number = goToAnnotation.getDestinationPageNumber();
            if (number == null) continue;
            BoundingBox annotationBoundingBox = new BoundingBox(goToAnnotation.getBoundingBox());
            if (annotationBoundingBox.getPageNumber() == null) {
                annotationBoundingBox.setPageNumber(node.getPageNumber());
            }
            if (!annotationBoundingBox.overlaps(node.getBoundingBox())) continue;
            return number;
        }
        return null;
    }

    private static List<TextChunk> getTextChunks(INode node) {
        LinkedList<TextChunk> textChunks = new LinkedList<TextChunk>();
        for (INode child : node.getChildren()) {
            if (child.getInitialSemanticType() == SemanticType.TABLE_OF_CONTENT) continue;
            if (child instanceof SemanticSpan) {
                for (TextColumn column : ((SemanticSpan)child).getColumns()) {
                    for (TextLine line : column.getLines()) {
                        for (TextChunk chunk : line.getTextChunks()) {
                            if (chunk.isEmpty() || TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                            textChunks.add(chunk);
                        }
                    }
                }
                continue;
            }
            textChunks.addAll(TOCDetectionConsumer.getTextChunks(child));
        }
        return textChunks;
    }

    private static List<IAnnotation> getInheritorAnnotations(INode node) {
        if (node instanceof IAnnotation) {
            return Collections.singletonList((IAnnotation)node);
        }
        LinkedList<IAnnotation> annotations = new LinkedList<IAnnotation>();
        for (INode child : node.getChildren()) {
            annotations.addAll(TOCDetectionConsumer.getInheritorAnnotations(child));
        }
        return annotations;
    }

    private static int getNumberOfEndDigits(String string) {
        return TOCDetectionConsumer.getNumberOfEndRegex(string, "\\d+");
    }

    private static int getNumberOfEndSpaces(String string) {
        return TOCDetectionConsumer.getNumberOfEndRegex(string, SPACES_REGEX);
    }

    private static int getLastRegexIndex(String string, String regex) {
        Pattern pattern = Pattern.compile(regex + "$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.start();
        }
        return string.length();
    }

    private static int getNumberOfEndRegex(String string, String regex) {
        return string.length() - TOCDetectionConsumer.getLastRegexIndex(string, regex);
    }

    private static Integer getPageNumberLabel(String string, int end) {
        if (end == string.length()) {
            return null;
        }
        try {
            return Integer.parseUnsignedInt(string.substring(end));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private boolean findText(INode node, String text, int pageNumber) {
        for (INode child : node.getChildren()) {
            if (child.getPageNumber() == null || child.getPageNumber() != pageNumber || child.getLastPageNumber() != pageNumber) continue;
            INode parent = node;
            while (parent.getInitialSemanticType() == SemanticType.TABLE_OF_CONTENT && parent.getParent() != null) {
                parent = parent.getParent();
            }
            if (parent.getInitialSemanticType() == SemanticType.TABLE_OF_CONTENT) {
                return false;
            }
            String textValue = TOCDetectionConsumer.getTextChunks(parent).stream().filter(textChunk -> pageNumber == textChunk.getPageNumber()).map(TextChunk::getValue).collect(Collectors.joining("")).replaceAll(NON_CONTENT_REGEX, "").toUpperCase();
            boolean isTextFound = textValue.contains(text);
            if (isTextFound) {
                this.findHeading(parent, text, pageNumber);
            }
            return isTextFound;
        }
        for (INode child : node.getChildren()) {
            if (child.getPageNumber() == null || child.getPageNumber() > pageNumber || child.getLastPageNumber() < pageNumber || !this.findText(child, text, pageNumber)) continue;
            return true;
        }
        return false;
    }

    private boolean findHeading(INode node, String text, int pageNumber) {
        String textValue = null;
        if (!(node.getInitialSemanticType() != SemanticType.NUMBER_HEADING && node.getInitialSemanticType() != SemanticType.HEADING || (textValue = TOCDetectionConsumer.getTextChunks(node).stream().filter(textChunk -> pageNumber == textChunk.getPageNumber()).map(TextChunk::getValue).collect(Collectors.joining("")).replaceAll(NON_CONTENT_REGEX, "").toUpperCase()).contains(text))) {
            return false;
        }
        if (textValue == null || (double)textValue.length() > 1.5 * (double)text.length()) {
            for (INode child : node.getChildren()) {
                if (child.getInitialSemanticType() == SemanticType.TABLE_OF_CONTENT || !this.findHeading(child, text, pageNumber)) continue;
                return true;
            }
            return false;
        }
        if (node.getSemanticType() == SemanticType.HEADING || node.getSemanticType() == SemanticType.NUMBER_HEADING) {
            return true;
        }
        INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
        if (accumulatedNode instanceof SemanticTextNode) {
            if (node.getInitialSemanticType() == SemanticType.NUMBER_HEADING) {
                StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticNumberHeading((SemanticTextNode)accumulatedNode), 1.0, SemanticType.NUMBER_HEADING);
            } else if (node.getInitialSemanticType() == SemanticType.HEADING) {
                StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticHeading((SemanticTextNode)accumulatedNode), 1.0, SemanticType.HEADING);
            }
        }
        return true;
    }

    private void checkNeighborTOCs(INode node) {
        if (node.getSemanticType() == SemanticType.TABLE_OF_CONTENT) {
            return;
        }
        INode previousChild = null;
        for (INode child : node.getChildren()) {
            if (child.getSemanticType() == SemanticType.TABLE_OF_CONTENT) {
                if (previousChild != null && this.checkNeighborTOCs(child, previousChild)) {
                    child.getErrorCodes().add(1006);
                    previousChild.getErrorCodes().add(1006);
                    StaticContainers.getIdMapper().put(previousChild.getRecognizedStructureId(), child.getRecognizedStructureId());
                }
                previousChild = child;
                continue;
            }
            previousChild = null;
        }
    }

    private boolean checkNeighborTOCs(INode currentTOC, INode previousTOC) {
        INode previousTOCI = previousTOC.getChildren().get(previousTOC.getChildren().size() - 1);
        if (previousTOCI.getSemanticType() != SemanticType.TABLE_OF_CONTENT_ITEM) {
            return false;
        }
        INode currentTOCI = currentTOC.getChildren().get(0);
        if (currentTOCI.getSemanticType() != SemanticType.TABLE_OF_CONTENT_ITEM) {
            return false;
        }
        HashSet<Integer> previousTOCIErrorCodes = new HashSet<Integer>(previousTOCI.getErrorCodes());
        HashSet<Integer> currentTOCIErrorCodes = new HashSet<Integer>(currentTOCI.getErrorCodes());
        this.right = null;
        this.maxRight = -1.7976931348623157E308;
        this.pagesGap = null;
        this.lastPageNumber = null;
        boolean result = this.checkTOCI(previousTOCI, this.getTOCIInfo(previousTOCI)) && this.checkTOCI(currentTOCI, this.getTOCIInfo(currentTOCI));
        previousTOCI.setErrorCodes(previousTOCIErrorCodes);
        currentTOCI.setErrorCodes(currentTOCIErrorCodes);
        return result;
    }
}

