/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.lists;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.tables.TableCell;
import org.verapdf.wcag.algorithms.entities.tables.TableTokenRow;

public class ListElement
extends TextInfoChunk {
    private final List<TableTokenRow> content;
    private SemanticType semanticType;

    public ListElement(TableCell cell, SemanticType semanticType) {
        super(cell.getBoundingBox(), cell.getFontSize(), cell.getBaseLine());
        this.semanticType = semanticType;
        this.content = new ArrayList<TableTokenRow>();
        this.content.addAll(cell.getContent());
    }

    public void setSemanticType(SemanticType semanticType) {
        this.semanticType = semanticType;
    }

    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    public void add(TableTokenRow row) {
        this.content.add(row);
        super.add(row);
    }

    public void add(TableCell cell) {
        for (TableTokenRow tableTokenRow : cell.getContent()) {
            this.add(tableTokenRow);
        }
    }

    public List<TableTokenRow> getContent() {
        return this.content;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TableTokenRow tokenRow : this.content) {
            stringBuilder.append(tokenRow.getString());
        }
        return stringBuilder.toString();
    }
}

