/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.tables.tableBorders;

import org.verapdf.wcag.algorithms.entities.BaseObject;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderCell;

public class TableBorderRow
extends BaseObject {
    private int rowNumber;
    protected TableBorderCell[] cells;
    private SemanticType semanticType;
    private INode node;

    public TableBorderRow(int rowNumber, int numberOfColumns, Long id) {
        super(new BoundingBox());
        this.rowNumber = rowNumber;
        this.cells = new TableBorderCell[numberOfColumns];
        this.setRecognizedStructureId(id);
    }

    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    public void setSemanticType(SemanticType semanticType) {
        this.semanticType = semanticType;
    }

    public INode getNode() {
        return this.node;
    }

    public void setNode(INode node) {
        this.node = node;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int getNumberOfCellWithContent() {
        int numberOfCellsWithContent = 0;
        for (int colNumber = 0; colNumber < this.cells.length; ++colNumber) {
            TableBorderCell cell = this.cells[colNumber];
            if (cell.colNumber != colNumber || cell.rowNumber != this.rowNumber || cell.getContent().isEmpty()) continue;
            ++numberOfCellsWithContent;
        }
        return numberOfCellsWithContent;
    }

    public int getNumberOfCells() {
        int numberOfCells = 0;
        for (int colNumber = 0; colNumber < this.cells.length; ++colNumber) {
            TableBorderCell cell = this.cells[colNumber];
            if (cell.colNumber != colNumber || cell.rowNumber != this.rowNumber) continue;
            ++numberOfCells;
        }
        return numberOfCells;
    }

    public TableBorderCell[] getCells() {
        return this.cells;
    }

    public TableBorderCell getCell(int colNumber) {
        return this.cells[colNumber];
    }
}

