/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.wcag.algorithms.entities.BaseObject;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticAnnot;
import org.verapdf.wcag.algorithms.entities.SemanticFigure;
import org.verapdf.wcag.algorithms.entities.SemanticParagraph;
import org.verapdf.wcag.algorithms.entities.SemanticPart;
import org.verapdf.wcag.algorithms.entities.SemanticSpan;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.TextBlock;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextColumn;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.enums.TextFormat;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.WCAGConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ChunksMergeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.WCAGProgressStatus;

public class AccumulatedNodeConsumer
extends WCAGConsumer
implements Consumer<INode> {
    private static final Logger LOGGER = Logger.getLogger(AccumulatedNodeConsumer.class.getCanonicalName());
    public static final double MERGE_PROBABILITY_THRESHOLD = 0.75;
    public static final double ONE_LINE_MIN_PROBABILITY_THRESHOLD = 0.1;
    public static final double FOOTNOTE_MIN_PROBABILITY_THRESHOLD = 0.75;

    @Override
    public void accept(INode node) {
        if (node.getChildren().isEmpty()) {
            StaticContainers.getAccumulatedNodeMapper().updateNode(node, node, 1.0, node.getSemanticType());
            return;
        }
        boolean isLeafChild = node.getChildren().stream().allMatch(child -> child instanceof SemanticSpan || child instanceof SemanticFigure || child instanceof SemanticAnnot || child.getSemanticType() == null);
        this.acceptSpanParagraphPart(node, isLeafChild);
        this.acceptSemanticAnnot(node);
        this.acceptSemanticImage(node);
        this.checkSemanticSpanChildren(node);
    }

    private void checkSemanticSpanChildren(INode node) {
        INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
        if (!(accumulatedNode instanceof SemanticTextNode)) {
            return;
        }
        if (node.getChildren().stream().noneMatch(child -> child instanceof SemanticSpan)) {
            return;
        }
        SemanticTextNode textNode = (SemanticTextNode)accumulatedNode;
        for (INode child2 : node.getChildren()) {
            if (!(child2 instanceof SemanticSpan)) continue;
            for (TextColumn textColumn : ((SemanticSpan)child2).getColumns()) {
                for (TextLine textLine : textColumn.getLines()) {
                    for (TextChunk textChunk : textLine.getTextChunks()) {
                        if (TextChunkUtils.isWhiteSpaceChunk(textChunk)) continue;
                        if (!(Objects.equals(textNode.getFontSize(), textChunk.getFontSize()) && Objects.equals(textNode.getItalicAngle(), textChunk.getItalicAngle()) && Arrays.equals(textNode.getTextColor(), textChunk.getFontColor()) && Objects.equals(textNode.getFontWeight(), textChunk.getFontWeight()))) {
                            textChunk.setHasSpecialStyle();
                        }
                        if (textChunk.getBackgroundColor() == null || NodeUtils.hasSimilarBackgroundColor(textNode.getBackgroundColor(), textChunk.getBackgroundColor())) continue;
                        textChunk.setHasSpecialBackground();
                    }
                }
            }
        }
    }

    private void acceptSemanticImage(INode node) {
        SemanticFigure figureNode = null;
        for (INode child : node.getChildren()) {
            INode accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(child);
            if (accumulatedChild instanceof SemanticTextNode) {
                if (((SemanticTextNode)accumulatedChild).isEmpty() || ((SemanticTextNode)accumulatedChild).isSpaceNode()) continue;
                return;
            }
            if (!(accumulatedChild instanceof SemanticFigure)) continue;
            if (figureNode == null) {
                figureNode = new SemanticFigure((SemanticFigure)accumulatedChild);
                continue;
            }
            figureNode.addImages(((SemanticFigure)accumulatedChild).getImages());
            figureNode.addLineArts(((SemanticFigure)accumulatedChild).getLineArts());
        }
        if (figureNode != null) {
            StaticContainers.getAccumulatedNodeMapper().updateNode(node, figureNode, 1.0, SemanticType.FIGURE);
        }
    }

    private void acceptSemanticAnnot(INode node) {
        SemanticAnnot annot = null;
        for (INode child : node.getChildren()) {
            INode accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(child);
            if (accumulatedChild instanceof SemanticTextNode) {
                if (((SemanticTextNode)accumulatedChild).isEmpty() || ((SemanticTextNode)accumulatedChild).isSpaceNode()) continue;
                return;
            }
            if (!(accumulatedChild instanceof SemanticAnnot)) continue;
            if (annot == null) {
                annot = new SemanticAnnot((SemanticAnnot)accumulatedChild);
                continue;
            }
            annot.addAnnots(((SemanticAnnot)accumulatedChild).getAnnots());
        }
        if (annot != null) {
            StaticContainers.getAccumulatedNodeMapper().updateNode(node, annot, 1.0, SemanticType.ANNOT);
        }
    }

    private void acceptSpanParagraphPart(INode node, boolean isLeafChild) {
        double probability = 1.0;
        BaseObject part = null;
        MultiBoundingBox boundingBox = new MultiBoundingBox();
        for (INode child : node.getChildren()) {
            if (child.getSemanticType() == null || SemanticType.isIgnoredStandardType(child.getInitialSemanticType()) || child instanceof SemanticAnnot) continue;
            INode accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(child);
            if (accumulatedChild instanceof SemanticFigure) {
                boundingBox.union(child.getBoundingBox());
                continue;
            }
            if (child.getSemanticType().equals((Object)SemanticType.FIGURE)) continue;
            if (part == null) {
                part = this.buildPartFromNode(accumulatedChild);
                probability = accumulatedChild.getCorrectSemanticScore();
            } else {
                probability = Math.min(probability, this.toPartMergeProbability((SemanticPart)part, accumulatedChild));
            }
            if (child.getInitialSemanticType() != SemanticType.NOTE && accumulatedChild.getSemanticType() != SemanticType.NOTE) {
                boundingBox.union(child.getBoundingBox());
            }
            if (accumulatedChild.getSemanticType() != SemanticType.NOTE) continue;
            child.setSemanticType(SemanticType.NOTE);
        }
        if (part != null) {
            part.setBoundingBox(boundingBox);
            node.setBoundingBox(boundingBox);
        }
        SemanticType semanticType = SemanticType.PART;
        BaseObject accumulatedNode = part;
        if (part != null && ((SemanticTextNode)part).getColumns().stream().allMatch(TextColumn::hasOnlyOneBlock)) {
            boolean isSpan;
            boolean bl = isSpan = SemanticType.SPAN.equals((Object)node.getInitialSemanticType()) && (isLeafChild || node.getChildren().stream().allMatch(AccumulatedNodeConsumer::isAppropriateSpanChild));
            if (isSpan) {
                semanticType = SemanticType.SPAN;
                accumulatedNode = new SemanticSpan(part.getBoundingBox(), ((SemanticTextNode)part).getColumns());
            } else {
                semanticType = SemanticType.PARAGRAPH;
                accumulatedNode = new SemanticParagraph(part.getBoundingBox(), ((SemanticTextNode)part).getColumns());
            }
        }
        StaticContainers.getAccumulatedNodeMapper().updateNode(node, (INode)((Object)accumulatedNode), probability, semanticType);
    }

    private static boolean isAppropriateSpanChild(INode child) {
        return child instanceof SemanticSpan || child instanceof SemanticFigure || child instanceof SemanticAnnot || child.getInitialSemanticType() == SemanticType.LINK || child.getSemanticType() == SemanticType.SPAN || child.getSemanticType() == null;
    }

    private SemanticPart buildPartFromNode(INode node) {
        if (this.isNullableSemanticType(node)) {
            return null;
        }
        if (node instanceof SemanticTextNode) {
            SemanticTextNode textNode = (SemanticTextNode)node;
            return new SemanticPart(textNode.getBoundingBox(), textNode.getColumns());
        }
        return null;
    }

    private double toPartMergeProbability(SemanticPart part, INode node) {
        if (this.isNullableSemanticType(node)) {
            return 0.0;
        }
        if (node instanceof SemanticTextNode) {
            return this.toTextNodeMergeProbability(part, (SemanticTextNode)node);
        }
        return 0.0;
    }

    private boolean isNullableSemanticType(INode node) {
        if (node.getSemanticType() == null) {
            LOGGER.log(Level.WARNING, "Node with nullable semantic type: {}", node);
            return true;
        }
        return false;
    }

    private double toTextNodeMergeProbability(SemanticPart currentTextNode, SemanticTextNode nextTextNode) {
        double mergeProbability;
        if (nextTextNode.isEmpty()) {
            return 1.0;
        }
        List<TextLine> lines = nextTextNode.getFirstColumn().getLines();
        TextLine lastLine = currentTextNode.getLastLine();
        TextLine nextLine = nextTextNode.getFirstLine();
        double oneLineProbability = ChunksMergeUtils.countOneLineProbability(nextTextNode, lastLine, nextLine);
        double differentLinesProbability = currentTextNode.getLastColumn().getLinesNumber() > 1 && nextTextNode.getFirstColumn().getLinesNumber() > 1 ? ChunksMergeUtils.toParagraphMergeProbability(lastLine, nextLine) : ChunksMergeUtils.mergeLeadingProbability(lastLine, nextLine);
        double toColumnsMergeProbability = ChunksMergeUtils.toColumnsMergeProbability(lastLine, nextLine);
        double footnoteProbability = ChunksMergeUtils.getFootnoteProbability(currentTextNode, nextTextNode, lastLine, nextLine);
        if (footnoteProbability > Math.max(toColumnsMergeProbability, Math.max(oneLineProbability, differentLinesProbability)) && footnoteProbability > 0.75) {
            mergeProbability = footnoteProbability;
            nextTextNode.setSemanticType(SemanticType.NOTE);
        } else if (oneLineProbability < Math.max(Math.max(differentLinesProbability, toColumnsMergeProbability), 0.1)) {
            if (Math.max(differentLinesProbability, toColumnsMergeProbability) < 0.75) {
                double toPartMergeProbability = 0.0;
                TextLine penultLine = currentTextNode.getPenultLine();
                TextLine secondLine = nextTextNode.getSecondLine();
                if (penultLine != null && secondLine != null) {
                    toPartMergeProbability = ChunksMergeUtils.toPartMergeProbability(lastLine, nextLine, penultLine, secondLine);
                }
                mergeProbability = toPartMergeProbability;
                TextColumn lastColumn = new TextColumn(currentTextNode.getLastColumn());
                lastColumn.getBlocks().addAll(nextTextNode.getFirstColumn().getBlocks());
                currentTextNode.setLastColumn(lastColumn);
                if (nextTextNode.getColumnsNumber() > 1) {
                    currentTextNode.addAll(nextTextNode.getColumns().subList(1, nextTextNode.getColumnsNumber()));
                }
            } else if (differentLinesProbability >= toColumnsMergeProbability) {
                mergeProbability = differentLinesProbability;
                TextColumn lastColumn = new TextColumn(currentTextNode.getLastColumn());
                TextBlock lastBlock = new TextBlock(lastColumn.getLastTextBlock());
                lastBlock.getLines().addAll(lines);
                lastColumn.setLastTextBlock(lastBlock);
                currentTextNode.setLastColumn(lastColumn);
                if (nextTextNode.getColumnsNumber() > 1) {
                    currentTextNode.addAll(nextTextNode.getColumns().subList(1, nextTextNode.getColumnsNumber()));
                }
            } else {
                mergeProbability = toColumnsMergeProbability;
                currentTextNode.addAll(nextTextNode.getColumns());
            }
            nextTextNode.setTextFormat(TextFormat.NORMAL);
        } else {
            this.updateTextChunksFormat(nextTextNode);
            mergeProbability = oneLineProbability;
            lastLine.setNotLineEnd();
            nextLine.setNotLineStart();
            currentTextNode.setLastColumn(new TextColumn(currentTextNode.getLastColumn()));
            TextBlock lastBlock = new TextBlock(currentTextNode.getLastColumn().getLastTextBlock());
            lastLine = new TextLine(lastLine);
            lastLine.add(nextLine);
            lastBlock.setLastLine(lastLine);
            currentTextNode.getLastColumn().setLastTextBlock(lastBlock);
            if (lines.size() > 1) {
                if (currentTextNode.getLastColumn().getLinesNumber() > 2 && lines.size() > 1) {
                    mergeProbability *= ChunksMergeUtils.toParagraphMergeProbability(currentTextNode.getPenultLine(), lastLine);
                }
                if (currentTextNode.getLastColumn().getLinesNumber() > 1 && lines.size() > 2) {
                    mergeProbability *= ChunksMergeUtils.toParagraphMergeProbability(lastLine, lines.get(1));
                }
                currentTextNode.getLastColumn().getLastTextBlock().getLines().addAll(lines.subList(1, lines.size()));
            }
            if (nextTextNode.getColumnsNumber() > 1) {
                currentTextNode.addAll(nextTextNode.getColumns().subList(1, nextTextNode.getColumnsNumber()));
            }
        }
        return nextTextNode.getCorrectSemanticScore() == null ? mergeProbability : Math.min(mergeProbability, nextTextNode.getCorrectSemanticScore());
    }

    private void updateTextChunksFormat(SemanticTextNode textNode) {
        TextFormat format = textNode.getTextFormat();
        TextLine line = textNode.getFirstLine();
        for (TextChunk chunk : line.getTextChunks()) {
            if (chunk.getTextFormat() == format) break;
            chunk.setTextFormat(format);
        }
    }

    @Override
    public WCAGProgressStatus getWCAGProgressStatus() {
        return WCAGProgressStatus.PARAGRAPH_DETECTION;
    }
}

