/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.verapdf.wcag.algorithms.entities.IAnnotation;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticAnnot;
import org.verapdf.wcag.algorithms.entities.SemanticHeading;
import org.verapdf.wcag.algorithms.entities.SemanticNode;
import org.verapdf.wcag.algorithms.entities.SemanticNumberHeading;
import org.verapdf.wcag.algorithms.entities.SemanticSpan;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextColumn;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.WCAGConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.tocs.TOCIInfo;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ErrorCodes;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ListLabelsUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.WCAGProgressStatus;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.ArabicNumbersListLabelsDetectionAlgorithm;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.ListLabelsDetectionAlgorithm;

public class TOCDetectionConsumer
extends WCAGConsumer
implements Consumer<INode> {
    public static final double TOC_PROBABILITY_THRESHOLD = 0.75;
    private static final String LINK = "Link";
    private static final String SPACES = "\\s\u00a0\u2007\u202f";
    private static final String SPACES_REGEX = "[\\s\u00a0\u2007\u202f]+";
    private static final String SPACES_DOTS_SPACES_REGEX = "[\\s\u00a0\u2007\u202f]*\\.*[\\s\u00a0\u2007\u202f]*";
    public static final String NON_CONTENT_REGEX = "[\\s\u00a0\u2007\u202f\u2011\u2010:\\-]";
    private static final double MAX_RIGHT_ALIGNMENT_GAP = 0.1;
    private static final double LENGTH_HEADING_DIFFERENCE = 1.5;
    private final Map<Integer, INode> nodes = new HashMap<Integer, INode>();
    private INode currentNode;
    private long processedStructElements = 0L;
    private final Long structElementsNumber = StaticContainers.getStructElementsNumber();
    private Double right = null;
    private Double maxRight = -1.7976931348623157E308;
    private Integer pagesGap = null;
    private Integer lastPageNumber = null;

    @Override
    public void accept(INode node) {
        this.currentNode = node;
        this.detectTOC(node);
        this.checkTOC(node);
        this.checkNeighborTOCs(node);
        if (!node.getChildren().isEmpty()) {
            ++this.processedStructElements;
        }
    }

    public void detectTOC(INode node) {
        if (node.getInitialSemanticType() == SemanticType.TABLE_OF_CONTENT) {
            return;
        }
        if (node.getChildren().size() < 2) {
            return;
        }
        List<TOCIInfo> infos = this.getTOCIInfos(node);
        ArrayList<Integer> tocIndexes = new ArrayList<Integer>(infos.size());
        for (int index = 0; index < infos.size(); ++index) {
            INode child = node.getChildren().get(index);
            if (child.getInitialSemanticType() != SemanticType.TABLE_OF_CONTENT && child.getSemanticType() != SemanticType.TABLE_OF_CONTENT) continue;
            tocIndexes.add(index);
        }
        List<Integer> tociIndexes = this.detectTOCIs(infos, node, tocIndexes);
        if (tociIndexes.size() > 1) {
            Long id = StaticContainers.getNextID();
            for (int index : tociIndexes) {
                INode child = node.getChildren().get(index);
                child.setRecognizedStructureId(id);
                StaticContainers.getAccumulatedNodeMapper().updateNode(child, StaticContainers.getAccumulatedNodeMapper().get(child), 1.0, SemanticType.TABLE_OF_CONTENT_ITEM);
            }
            if ((double)(tociIndexes.size() + tocIndexes.size()) > 0.75 * (double)node.getChildren().size()) {
                node.setSemanticType(SemanticType.TABLE_OF_CONTENT);
                node.setRecognizedStructureId(id);
            }
        }
    }

    public void checkTOC(INode node) {
        if (node.getInitialSemanticType() != SemanticType.TABLE_OF_CONTENT) {
            return;
        }
        List<TOCIInfo> infos = this.getTOCIInfos(node);
        TOCDetectionConsumer.checkTOCIsNumbering(node.getChildren(), infos);
        this.right = null;
        this.maxRight = -1.7976931348623157E308;
        this.pagesGap = null;
        this.lastPageNumber = null;
        List<Integer> tociIndexes = this.checkTOCIs(node, infos, node.getChildren());
        Long id = StaticContainers.getNextID();
        for (INode child : node.getChildren()) {
            if (child.getInitialSemanticType() != SemanticType.TABLE_OF_CONTENT_ITEM) continue;
            child.setRecognizedStructureId(id);
        }
        Iterator<Object> iterator = tociIndexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            INode child = node.getChildren().get(index);
            if (child.getInitialSemanticType() != SemanticType.TABLE_OF_CONTENT_ITEM) {
                child.setRecognizedStructureId(id);
            }
            StaticContainers.getAccumulatedNodeMapper().updateNode(child, StaticContainers.getAccumulatedNodeMapper().get(child), 1.0, SemanticType.TABLE_OF_CONTENT_ITEM);
        }
        if (tociIndexes.size() > 1 || tociIndexes.size() == 1 && node.getChildren().size() == 1) {
            node.setRecognizedStructureId(id);
            StaticContainers.getAccumulatedNodeMapper().updateNode(node, StaticContainers.getAccumulatedNodeMapper().get(node), 1.0, SemanticType.TABLE_OF_CONTENT);
        }
    }

    private boolean checkTOCI(INode child, TOCIInfo tociInfo) {
        if (tociInfo.getText() == null) {
            ErrorCodes.addErrorCodeWithArguments(child, 1000, new Object[0]);
            return false;
        }
        if (this.lastPageNumber != null && !this.lastPageNumber.equals(child.getPageNumber())) {
            this.right = null;
            this.maxRight = -1.7976931348623157E308;
        }
        this.lastPageNumber = child.getPageNumber();
        if (child.getLeftX() > this.maxRight) {
            this.right = null;
        }
        this.maxRight = Math.max(this.maxRight, tociInfo.getRight());
        if (tociInfo.getPageNumberLabel() != null) {
            if (this.right == null) {
                this.right = tociInfo.getRight();
            } else if (!NodeUtils.areCloseNumbers(this.right, tociInfo.getRight(), 0.1 * tociInfo.getMaxTextSize())) {
                ErrorCodes.addErrorCodeWithArguments(child, 1003, new Object[0]);
                return false;
            }
        }
        if (tociInfo.getDestinationPageNumber() == null && tociInfo.getDestinationStructElem() == null) {
            ErrorCodes.addErrorCodeWithArguments(child, 1001, new Object[0]);
            return false;
        }
        if (tociInfo.getPageNumberLabel() != null) {
            if (this.pagesGap == null) {
                this.pagesGap = tociInfo.getPageNumberLabel() - tociInfo.getDestinationPageNumber();
            } else if (tociInfo.getDestinationPageNumber() + this.pagesGap != tociInfo.getPageNumberLabel()) {
                ErrorCodes.addErrorCodeWithArguments(child, 1002, new Object[0]);
                return false;
            }
        }
        if (!this.findText(tociInfo.getTextForSearching(), tociInfo.getDestinationPageNumber())) {
            ErrorCodes.addErrorCodeWithArguments(child, 1005, new Object[0]);
            return false;
        }
        return true;
    }

    private List<TOCIInfo> getTOCIInfos(INode node) {
        ArrayList<TOCIInfo> infos = new ArrayList<TOCIInfo>(node.getChildren().size());
        for (int index = 0; index < node.getChildren().size(); ++index) {
            INode child = node.getChildren().get(index);
            if (child.getSemanticType() != SemanticType.TABLE_OF_CONTENT) {
                infos.add(this.getTOCIInfo(child));
                continue;
            }
            infos.add(null);
        }
        return infos;
    }

    public List<Integer> detectTOCIs(List<TOCIInfo> infos, INode node, List<Integer> tocIndexes) {
        INode child;
        int i;
        ArrayList<Integer> indexes = new ArrayList<Integer>(infos.size());
        for (int index = 0; index < infos.size(); ++index) {
            TOCIInfo tociInfo = infos.get(index);
            INode child2 = node.getChildren().get(index);
            if (tociInfo == null || child2.getInitialSemanticType() == SemanticType.TABLE_OF_CONTENT || child2.getSemanticType() == SemanticType.TABLE_OF_CONTENT || child2.getInitialSemanticType() == SemanticType.LINK || tociInfo.getText() == null || tociInfo.getText().isEmpty() || tociInfo.getDestinationPageNumber() == null && tociInfo.getDestinationStructElem() == null && (tociInfo.getPageNumberLabel() == null || tociInfo.getPageNumberLabel() > StaticContainers.getDocument().getNumberOfPages())) continue;
            indexes.add(index);
        }
        if (indexes.size() < 2) {
            return indexes;
        }
        ArrayList<INode> children = new ArrayList<INode>(node.getChildren().size());
        for (INode child2 : node.getChildren()) {
            children.add(new SemanticNode(child2.getBoundingBox(), child2.getInitialSemanticType(), child2.getSemanticType()));
        }
        ArrayList<Integer> tociIndexes = new ArrayList<Integer>(indexes);
        Integer gap = this.checkTOCIsWithDestinationPage(node, indexes, infos, children);
        this.checkTOCIsWithWrongDestination(node, indexes, tociIndexes, infos, children, gap);
        for (i = tociIndexes.size() - 1; i >= 0; --i) {
            child = (INode)children.get((Integer)tociIndexes.get(i));
            if (!child.getErrorCodes().contains(1007) && (infos.get((Integer)tociIndexes.get(i)).getDestinationPageNumber() != null || infos.get((Integer)tociIndexes.get(i)).getDestinationStructElem() != null || !child.getErrorCodes().contains(1010))) continue;
            tociIndexes.remove(i);
        }
        this.checkLeftAndRightAlignments(tociIndexes, infos, children);
        for (i = tociIndexes.size() - 1; i >= 0; --i) {
            child = (INode)children.get((Integer)tociIndexes.get(i));
            if (!child.getErrorCodes().contains(1003)) continue;
            tociIndexes.remove(i);
        }
        this.removeSingleTOCIIndexes(tociIndexes, tocIndexes);
        return tociIndexes;
    }

    private void removeSingleTOCIIndexes(List<Integer> tociIndexes, List<Integer> tocIndexes) {
        for (int i = tociIndexes.size() - 2; i >= 1; --i) {
            if (tociIndexes.get(i) - 1 == tociIndexes.get(i - 1) || tociIndexes.get(i) + 1 == tociIndexes.get(i + 1) || tocIndexes.contains(tociIndexes.get(i) + 1) || tocIndexes.contains(tociIndexes.get(i) - 1)) continue;
            tociIndexes.remove(i);
        }
        if (tociIndexes.size() >= 2 && tociIndexes.get(tociIndexes.size() - 2) + 1 != tociIndexes.get(tociIndexes.size() - 1) && !tocIndexes.contains(tociIndexes.get(tociIndexes.size() - 1) - 1)) {
            tociIndexes.remove(tociIndexes.size() - 1);
        }
        if (tociIndexes.size() >= 2 && tociIndexes.get(0) + 1 != tociIndexes.get(1) && !tocIndexes.contains(tociIndexes.get(0) + 1)) {
            tociIndexes.remove(0);
        }
    }

    public List<Integer> checkTOCIs(INode node, List<TOCIInfo> infos, List<INode> children) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(infos.size());
        for (int index = 0; index < infos.size(); ++index) {
            TOCIInfo tociInfo = infos.get(index);
            INode child = children.get(index);
            if (tociInfo == null || child.getInitialSemanticType() == SemanticType.TABLE_OF_CONTENT || child.getSemanticType() == SemanticType.TABLE_OF_CONTENT) continue;
            if (tociInfo.getText() == null || tociInfo.getText().isEmpty()) {
                ErrorCodes.addErrorCodeWithArguments(child, 1000, new Object[0]);
                continue;
            }
            indexes.add(index);
        }
        ArrayList<Integer> tociIndexes = new ArrayList<Integer>(indexes);
        this.checkLeftAndRightAlignments(indexes, infos, children);
        Integer gap = this.checkTOCIsWithDestinationPage(node, indexes, infos, children);
        this.checkTOCIsWithWrongDestination(node, indexes, tociIndexes, infos, children, gap);
        return tociIndexes;
    }

    private void checkLeftAndRightAlignments(List<Integer> indexes, List<TOCIInfo> infos, List<INode> children) {
        for (int index : indexes) {
            TOCIInfo tociInfo = infos.get(index);
            INode child = children.get(index);
            if (this.lastPageNumber != null && !this.lastPageNumber.equals(child.getPageNumber())) {
                this.right = null;
                this.maxRight = -1.7976931348623157E308;
            }
            this.lastPageNumber = child.getPageNumber();
            if (child.getLeftX() > this.maxRight) {
                this.right = null;
            }
            this.maxRight = Math.max(this.maxRight, tociInfo.getRight());
            if (tociInfo.getPageNumberLabel() == null) continue;
            if (this.right == null) {
                this.right = tociInfo.getRight();
                continue;
            }
            if (NodeUtils.areCloseNumbers(this.right, tociInfo.getRight(), 0.1 * tociInfo.getMaxTextSize())) continue;
            ErrorCodes.addErrorCodeWithArguments(child, 1003, new Object[0]);
        }
    }

    private Integer checkTOCIsWithDestinationPage(INode node, List<Integer> indexes, List<TOCIInfo> infos, List<INode> children) {
        Object info;
        ArrayList<Integer> newIndexes = new ArrayList<Integer>(indexes.size());
        for (int index : indexes) {
            this.currentNode = node != null ? node.getChildren().get(index) : this.currentNode;
            info = infos.get(index);
            if (((TOCIInfo)info).getDestinationStructElem() != null && ((TOCIInfo)info).getDestinationStructElem().getPageNumber() != null && this.findText(((TOCIInfo)info).getTextForSearching(), ((TOCIInfo)info).getDestinationStructElem(), ((TOCIInfo)info).getDestinationStructElem().getPageNumber())) {
                newIndexes.add(index);
                ((TOCIInfo)info).setDestinationPageNumber(((TOCIInfo)info).getDestinationStructElem().getPageNumber());
                this.findHeading(((TOCIInfo)info).getDestinationStructElem(), ((TOCIInfo)info).getTextForSearching(), ((TOCIInfo)info).getDestinationPageNumber());
                continue;
            }
            if (((TOCIInfo)info).getDestinationPageNumber() == null || !this.findText(((TOCIInfo)info).getTextForSearching(), ((TOCIInfo)info).getDestinationPageNumber())) continue;
            newIndexes.add(index);
            this.findHeading(this.getNode(((TOCIInfo)info).getDestinationPageNumber()), ((TOCIInfo)info).getTextForSearching(), ((TOCIInfo)info).getDestinationPageNumber());
        }
        this.currentNode = node;
        if (newIndexes.isEmpty()) {
            return null;
        }
        LinkedList<List<Integer>> possiblePages = new LinkedList<List<Integer>>();
        LinkedList<Integer> pageLabels = new LinkedList<Integer>();
        info = newIndexes.iterator();
        while (info.hasNext()) {
            int index = (Integer)info.next();
            TOCIInfo info2 = infos.get(index);
            if (info2.getPageNumberLabel() == null) continue;
            LinkedList<Integer> destinationPage = new LinkedList<Integer>();
            destinationPage.add(info2.getDestinationPageNumber());
            possiblePages.add(destinationPage);
            pageLabels.add(info2.getPageNumberLabel());
        }
        Integer gap = this.getMostCommonGap(possiblePages, pageLabels);
        if (gap != null) {
            for (Integer index : newIndexes) {
                TOCIInfo info3 = infos.get(index);
                if (info3.getPageNumberLabel() == null || info3.getPageNumberLabel() - info3.getDestinationPageNumber() == gap) continue;
                ErrorCodes.addErrorCodeWithArguments(children.get(index), 1002, info3.getDestinationPageNumber() + gap);
            }
        }
        indexes.removeAll(newIndexes);
        return gap;
    }

    private void checkTOCIsWithWrongDestination(INode node, List<Integer> indexes, List<Integer> tociIndexes, List<TOCIInfo> infos, List<INode> children, Integer gap) {
        ArrayList<Object> possiblePages = new ArrayList<Object>(Collections.nCopies(children.size(), null));
        ArrayList<Object> pageLabels = new ArrayList<Object>(Collections.nCopies(children.size(), null));
        LinkedList<Integer> notTOCIIndexes = new LinkedList<Integer>();
        for (Integer index : indexes) {
            TOCIInfo info = infos.get(index);
            this.currentNode = node != null ? node.getChildren().get(index) : this.currentNode;
            List<Integer> pages = this.getPagesWithText(info.getTextForSearching());
            if (pages.isEmpty()) {
                ErrorCodes.addErrorCodeWithArguments(children.get(index), 1007, new Object[0]);
                tociIndexes.remove(index);
                notTOCIIndexes.add(index);
                continue;
            }
            String possiblePagesArgument = pages.stream().map(x -> x + 1).map(Object::toString).collect(Collectors.joining(","));
            if (info.getDestinationPageNumber() != null) {
                ErrorCodes.addErrorCodeWithArguments(children.get(index), 1008, possiblePagesArgument, info.getDestinationPageNumber() + 1);
            } else {
                ErrorCodes.addErrorCodeWithArguments(children.get(index), 1009, possiblePagesArgument);
            }
            if (info.getPageNumberLabel() == null) continue;
            possiblePages.set(index, pages);
            pageLabels.set(index, info.getPageNumberLabel());
        }
        this.currentNode = node;
        indexes.removeAll(notTOCIIndexes);
        if (!indexes.isEmpty() && gap == null) {
            gap = this.getMostCommonGap(possiblePages, pageLabels);
        }
        if (gap != null) {
            this.checkTOCIPageLabels(indexes, infos, possiblePages, children, gap);
        }
    }

    private void checkTOCIPageLabels(List<Integer> indexes, List<TOCIInfo> infos, List<List<Integer>> possiblePages, List<INode> children, Integer gap) {
        for (int index : indexes) {
            TOCIInfo info = infos.get(index);
            if (info.getPageNumberLabel() == null) continue;
            boolean wrongPageNumberLabel = true;
            for (Integer textPageNumber : possiblePages.get(index)) {
                if (info.getPageNumberLabel() - textPageNumber != gap) continue;
                wrongPageNumberLabel = false;
                break;
            }
            if (!wrongPageNumberLabel) continue;
            ErrorCodes.addErrorCodeWithArguments(children.get(index), 1010, possiblePages.get(index).stream().map(x -> x + 1).map(Object::toString).collect(Collectors.joining(",")));
        }
    }

    private TOCIInfo getTOCIInfo(INode node) {
        TOCIInfo info = new TOCIInfo();
        info.setDestinationPageNumber(TOCDetectionConsumer.getDestinationNumber(node, true));
        info.setDestinationStructElem(StaticContainers.getObjectKeyMapper().get(TOCDetectionConsumer.getDestinationNumber(node, false)));
        info.setRight(node.getRightX());
        List<TextChunk> textChunks = this.getTextChunks(node);
        info.setMaxTextSize(textChunks.stream().map(TextInfoChunk::getFontSize).max(Double::compare).orElse(0.0));
        if (!textChunks.isEmpty()) {
            String pageLabel;
            TextChunk lastChunk = textChunks.get(textChunks.size() - 1);
            String textValue = lastChunk.getValue();
            int pageLabelLength = 0;
            int numberOfSpaces = TOCDetectionConsumer.getNumberOfEndSpaces(textValue);
            info.setRight(lastChunk.getSymbolEndCoordinate(textValue.length() - numberOfSpaces - 1));
            textValue = textValue.substring(0, textValue.length() - numberOfSpaces);
            if (info.getDestinationPageNumber() != null && info.getDestinationPageNumber() < StaticContainers.getDocument().getNumberOfPages() && (pageLabel = StaticContainers.getDocument().getPage(info.getDestinationPageNumber()).getPageLabel()) != null && textValue.toUpperCase().endsWith(pageLabel.toUpperCase())) {
                info.setPageNumberLabel(info.getDestinationPageNumber());
                pageLabelLength = pageLabel.length();
            }
            if (info.getPageNumberLabel() == null) {
                pageLabelLength = TOCDetectionConsumer.getNumberOfEndDigits(textValue);
                info.setPageNumberLabel(TOCDetectionConsumer.getPageNumberLabel(textValue, textValue.length() - pageLabelLength));
            }
            if ((textValue = textChunks.stream().map(TextChunk::getValue).collect(Collectors.joining(""))).matches("\\d+\\.\\d+")) {
                textValue = null;
            } else {
                textValue = textValue.substring(0, textValue.length() - numberOfSpaces - pageLabelLength);
                textValue = textValue.substring(0, TOCDetectionConsumer.getLastRegexIndex(textValue, SPACES_DOTS_SPACES_REGEX));
            }
            info.setText(textValue);
        }
        return info;
    }

    private static Integer getDestinationNumber(INode node, boolean usePageDestination) {
        List linkAnnotations = TOCDetectionConsumer.getInheritorAnnotations(node).stream().filter(x -> LINK.equals(x.getAnnotationType())).collect(Collectors.toList());
        for (IAnnotation goToAnnotation : linkAnnotations) {
            Integer number = usePageDestination ? goToAnnotation.getDestinationPageNumber() : goToAnnotation.getDestinationObjectKeyNumber();
            if (number == null) continue;
            BoundingBox annotationBoundingBox = new BoundingBox(goToAnnotation.getBoundingBox());
            if (annotationBoundingBox.getPageNumber() == null) {
                annotationBoundingBox.setPageNumber(node.getPageNumber());
            }
            if (!annotationBoundingBox.overlaps(node.getBoundingBox())) continue;
            return number;
        }
        return null;
    }

    private List<TextChunk> getTextChunks(INode node) {
        return this.getTextChunks(node, null);
    }

    private List<TextChunk> getTextChunks(INode node, Integer pageNumber) {
        LinkedList<TextChunk> textChunks = new LinkedList<TextChunk>();
        if (node == this.currentNode) {
            return textChunks;
        }
        for (INode child : node.getChildren()) {
            if (child == this.currentNode || child.getInitialSemanticType() == SemanticType.TABLE_OF_CONTENT || child.getPageNumber() == null || pageNumber != null && (pageNumber < child.getPageNumber() || pageNumber > child.getLastPageNumber())) continue;
            if (child instanceof SemanticSpan) {
                for (TextColumn column : ((SemanticSpan)child).getColumns()) {
                    for (TextLine line : column.getLines()) {
                        for (TextChunk chunk : line.getTextChunks()) {
                            if (chunk.isEmpty() || TextChunkUtils.isWhiteSpaceChunk(chunk) || pageNumber != null && !pageNumber.equals(chunk.getPageNumber())) continue;
                            textChunks.add(chunk);
                        }
                    }
                }
                continue;
            }
            textChunks.addAll(this.getTextChunks(child, pageNumber));
        }
        return textChunks;
    }

    private static List<IAnnotation> getInheritorAnnotations(INode node) {
        if (node instanceof SemanticAnnot) {
            return Collections.singletonList((IAnnotation)((SemanticAnnot)node).getAnnots().get(0));
        }
        LinkedList<IAnnotation> annotations = new LinkedList<IAnnotation>();
        for (INode child : node.getChildren()) {
            annotations.addAll(TOCDetectionConsumer.getInheritorAnnotations(child));
        }
        return annotations;
    }

    private static int getNumberOfEndDigits(String string) {
        return TOCDetectionConsumer.getNumberOfEndRegex(string, "\\d+");
    }

    private static int getNumberOfEndSpaces(String string) {
        return TOCDetectionConsumer.getNumberOfEndRegex(string, SPACES_REGEX);
    }

    private static int getLastRegexIndex(String string, String regex) {
        Pattern pattern = Pattern.compile(regex + "$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.start();
        }
        return string.length();
    }

    private static int getNumberOfEndRegex(String string, String regex) {
        return string.length() - TOCDetectionConsumer.getLastRegexIndex(string, regex);
    }

    private static Integer getPageNumberLabel(String string, int end) {
        if (end == string.length()) {
            return null;
        }
        try {
            return Integer.parseUnsignedInt(string.substring(end));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private boolean findText(String text, int pageNumber) {
        INode currentNode = this.getNode(pageNumber);
        if (currentNode == null) {
            return false;
        }
        return this.findText(text, currentNode, pageNumber);
    }

    private boolean findText(String text, INode node, int pageNumber) {
        String textValue = this.getTextChunks(node, pageNumber).stream().map(TextChunk::getValue).collect(Collectors.joining("")).replaceAll(NON_CONTENT_REGEX, "").toUpperCase();
        return textValue.contains(text);
    }

    private INode getNode(Integer pageNumber) {
        if (!this.nodes.containsKey(pageNumber)) {
            this.nodes.put(pageNumber, this.findNode(pageNumber));
        }
        return this.nodes.get(pageNumber);
    }

    private INode findNode(int pageNumber) {
        INode currentNode = StaticContainers.getDocument().getTree().getRoot();
        while (currentNode.getPageNumber() != pageNumber || currentNode.getLastPageNumber() != pageNumber) {
            if (currentNode.getChildren().isEmpty()) {
                return null;
            }
            int depth = currentNode.getDepth();
            for (INode child : currentNode.getChildren()) {
                if (child.getPageNumber() == null || child.getPageNumber() > pageNumber || child.getLastPageNumber() < pageNumber) continue;
                currentNode = child;
                break;
            }
            if (currentNode.getDepth() != depth) continue;
            return null;
        }
        if (currentNode.getParent() != null) {
            currentNode = currentNode.getParent();
        }
        while (currentNode.getParent() != null) {
            INode previousNode = currentNode.getPreviousNode();
            INode nextNode = currentNode.getNextNode();
            if (currentNode.getInitialSemanticType() != SemanticType.TABLE_OF_CONTENT && (nextNode == null || nextNode.getPageNumber() != null && nextNode.getPageNumber() > pageNumber) && (previousNode == null || previousNode.getLastPageNumber() != null && previousNode.getLastPageNumber() < pageNumber)) break;
            currentNode = currentNode.getParent();
        }
        if (currentNode.getInitialSemanticType() == SemanticType.TABLE_OF_CONTENT) {
            return null;
        }
        return currentNode;
    }

    private List<Integer> getPagesWithText(String text) {
        LinkedList<Integer> pageNumbers = new LinkedList<Integer>();
        for (int pageNumber = 0; pageNumber < StaticContainers.getDocument().getNumberOfPages(); ++pageNumber) {
            if (!this.findText(text, pageNumber)) continue;
            pageNumbers.add(pageNumber);
        }
        return pageNumbers;
    }

    private boolean findHeading(INode node, String text, int pageNumber) {
        String textValue = null;
        if (node == null) {
            return false;
        }
        if (!(node.getInitialSemanticType() != SemanticType.NUMBER_HEADING && node.getInitialSemanticType() != SemanticType.HEADING || (textValue = this.getTextChunks(node, pageNumber).stream().map(TextChunk::getValue).collect(Collectors.joining("")).replaceAll(NON_CONTENT_REGEX, "").toUpperCase()).contains(text))) {
            return false;
        }
        if (textValue == null || (double)textValue.length() > 1.5 * (double)text.length()) {
            for (INode child : node.getChildren()) {
                if (child.getInitialSemanticType() == SemanticType.TABLE_OF_CONTENT || !this.findHeading(child, text, pageNumber)) continue;
                return true;
            }
            return false;
        }
        if (node.getSemanticType() == SemanticType.HEADING || node.getSemanticType() == SemanticType.NUMBER_HEADING) {
            return true;
        }
        INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
        if (accumulatedNode instanceof SemanticTextNode) {
            if (node.getInitialSemanticType() == SemanticType.NUMBER_HEADING) {
                StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticNumberHeading((SemanticTextNode)accumulatedNode), 1.0, SemanticType.NUMBER_HEADING);
            } else if (node.getInitialSemanticType() == SemanticType.HEADING) {
                StaticContainers.getAccumulatedNodeMapper().updateNode(node, new SemanticHeading((SemanticTextNode)accumulatedNode), 1.0, SemanticType.HEADING);
            }
        }
        return true;
    }

    private Integer getMostCommonGap(List<List<Integer>> possiblePages, List<Integer> pageLabels) {
        HashMap<Integer, Integer> gaps = new HashMap<Integer, Integer>();
        for (int index = 0; index < possiblePages.size(); ++index) {
            Integer pageLabel = pageLabels.get(index);
            if (pageLabel == null || possiblePages.get(index) == null) continue;
            for (Integer textPageNumber : possiblePages.get(index)) {
                int gap = pageLabel - textPageNumber;
                if (gaps.containsKey(gap)) {
                    gaps.replace(gap, (Integer)gaps.get(gap) + 1);
                    continue;
                }
                gaps.put(gap, 1);
            }
        }
        Integer mostCommonGap = null;
        int number = 0;
        for (Map.Entry entry : gaps.entrySet()) {
            if ((Integer)entry.getValue() <= number) continue;
            mostCommonGap = (Integer)entry.getKey();
            number = (Integer)entry.getValue();
        }
        return mostCommonGap;
    }

    private void checkNeighborTOCs(INode node) {
        if (node.getSemanticType() == SemanticType.TABLE_OF_CONTENT) {
            return;
        }
        INode previousChild = null;
        for (INode child : node.getChildren()) {
            if (child.getSemanticType() == SemanticType.TABLE_OF_CONTENT) {
                if (previousChild != null && this.checkNeighborTOCs(child, previousChild)) {
                    ErrorCodes.addErrorCodeWithArguments(child, 1006, new Object[0]);
                    ErrorCodes.addErrorCodeWithArguments(previousChild, 1006, new Object[0]);
                    StaticContainers.getIdMapper().put(previousChild.getRecognizedStructureId(), child.getRecognizedStructureId());
                }
                previousChild = child;
                continue;
            }
            previousChild = null;
        }
    }

    private boolean checkNeighborTOCs(INode currentTOC, INode previousTOC) {
        INode previousTOCI = previousTOC.getChildren().get(previousTOC.getChildren().size() - 1);
        if (previousTOCI.getSemanticType() != SemanticType.TABLE_OF_CONTENT_ITEM) {
            return false;
        }
        INode currentTOCI = currentTOC.getChildren().get(0);
        if (currentTOCI.getSemanticType() != SemanticType.TABLE_OF_CONTENT_ITEM) {
            return false;
        }
        int numberOfPreviousTOCIErrors = previousTOCI.getErrorCodes().size();
        int numberOfCurrentTOCIErrors = previousTOCI.getErrorCodes().size();
        this.right = null;
        this.maxRight = -1.7976931348623157E308;
        this.pagesGap = null;
        this.lastPageNumber = null;
        ArrayList<TOCIInfo> tociInfos = new ArrayList<TOCIInfo>(2);
        tociInfos.add(this.getTOCIInfo(previousTOCI));
        tociInfos.add(this.getTOCIInfo(currentTOCI));
        ArrayList<INode> tocis = new ArrayList<INode>(2);
        tocis.add(previousTOCI);
        tocis.add(currentTOCI);
        List<Integer> indexes = this.checkTOCIs(null, tociInfos, tocis);
        ErrorCodes.removeErrorCodeWithArgumentsAfterIndex(previousTOCI, numberOfPreviousTOCIErrors);
        ErrorCodes.removeErrorCodeWithArgumentsAfterIndex(currentTOCI, numberOfCurrentTOCIErrors);
        return indexes.size() == 2;
    }

    private static void checkTOCIsNumbering(List<INode> children, List<TOCIInfo> infos) {
        for (int i = 0; i < children.size() - 1; ++i) {
            if (infos.get(i) == null || infos.get(i + 1) == null) continue;
            String firstTOCI = infos.get(i).getText();
            String secondTOCI = infos.get(i + 1).getText();
            if (firstTOCI == null || secondTOCI == null) continue;
            int commonStartLength = ListLabelsUtils.getCommonStartLength(firstTOCI, secondTOCI);
            String prefix = firstTOCI.substring(0, commonStartLength);
            if (commonStartLength != 0) {
                firstTOCI = firstTOCI.substring(commonStartLength);
                secondTOCI = secondTOCI.substring(commonStartLength);
            }
            TOCDetectionConsumer.checkArabicNumbering(children.get(i + 1), firstTOCI, secondTOCI, prefix);
        }
    }

    private static boolean checkArabicNumbering(INode child, String firstTOCI, String secondTOCI, String prefix) {
        String firstSubstring = firstTOCI.substring(0, ListLabelsDetectionAlgorithm.getRegexStartLength(firstTOCI, "\\d+"));
        String secondSubstring = secondTOCI.substring(0, ListLabelsDetectionAlgorithm.getRegexStartLength(secondTOCI, "\\d+"));
        if (firstSubstring.isEmpty() || secondSubstring.isEmpty()) {
            return false;
        }
        Integer firstNumber = ArabicNumbersListLabelsDetectionAlgorithm.getIntegerFromString(firstSubstring);
        Integer secondNumber = ArabicNumbersListLabelsDetectionAlgorithm.getIntegerFromString(secondSubstring);
        if (firstNumber == null || secondNumber == null) {
            return false;
        }
        if (firstNumber + 1 != secondNumber) {
            ErrorCodes.addErrorCodeWithArguments(child, 1011, prefix + secondSubstring, prefix + (firstNumber + 1));
            return false;
        }
        return true;
    }

    @Override
    public WCAGProgressStatus getWCAGProgressStatus() {
        return WCAGProgressStatus.TOC_DETECTION;
    }

    @Override
    public Double getPercent() {
        return 100.0 * (double)this.processedStructElements / (double)this.structElementsNumber.longValue();
    }
}

