/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.AttributesDictionary;
import org.verapdf.wcag.algorithms.entities.BaseObject;
import org.verapdf.wcag.algorithms.entities.IAttributesDictionary;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.NodeInfo;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;

public class SemanticNode
extends BaseObject
implements INode {
    private Double correctSemanticScore;
    private SemanticType semanticType;
    private Integer index = null;
    private Integer objectKeyNumber = null;
    private INode parent = null;
    private final List<INode> children;
    private final SemanticType initialSemanticType;
    private int depth;
    private boolean hasLowestDepthError = false;
    private IAttributesDictionary attributesDictionary;
    public NodeInfo nodeInfo = new NodeInfo();

    public SemanticNode() {
        this((SemanticType)null);
    }

    public SemanticNode(SemanticType initialSemanticType) {
        this(initialSemanticType, null);
    }

    public SemanticNode(SemanticType initialSemanticType, Integer objectKeyNumber) {
        this(initialSemanticType, new LinkedList<Integer>(), new LinkedList<List<Object>>(), objectKeyNumber);
    }

    public SemanticNode(SemanticType initialSemanticType, List<Integer> errorCodes, List<List<Object>> errorArguments, Integer objectKeyNumber) {
        super(new BoundingBox(), errorCodes, errorArguments);
        this.children = new ArrayList<INode>();
        this.initialSemanticType = initialSemanticType;
        this.objectKeyNumber = objectKeyNumber;
    }

    public SemanticNode(BoundingBox bbox, SemanticType initialSemanticType, SemanticType semanticType) {
        this(bbox, initialSemanticType);
        this.semanticType = semanticType;
    }

    public SemanticNode(BoundingBox bbox, SemanticType initialSemanticType) {
        super(new MultiBoundingBox(bbox));
        this.children = new ArrayList<INode>();
        this.initialSemanticType = initialSemanticType;
    }

    public SemanticNode(BoundingBox bbox) {
        this(bbox, null);
    }

    @Override
    public Double getCorrectSemanticScore() {
        return this.correctSemanticScore;
    }

    @Override
    public void setCorrectSemanticScore(Double correctSemanticScore) {
        this.correctSemanticScore = correctSemanticScore;
    }

    @Override
    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    @Override
    public void setSemanticType(SemanticType semanticType) {
        this.semanticType = semanticType;
    }

    @Override
    public SemanticType getInitialSemanticType() {
        return this.initialSemanticType;
    }

    @Override
    public List<INode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(INode child) {
        this.children.add(child);
    }

    @Override
    public void setParent(INode node) {
        this.parent = node;
    }

    @Override
    public INode getParent() {
        return this.parent;
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Override
    public Integer getObjectKeyNumber() {
        return this.objectKeyNumber;
    }

    @Override
    public INode getNextNeighbor() {
        if (this.parent != null && this.index != null && this.index + 1 < this.parent.getChildren().size()) {
            return this.parent.getChildren().get(this.index + 1);
        }
        return null;
    }

    @Override
    public INode getPreviousNeighbor() {
        if (this.parent != null && this.index != null && this.index > 0) {
            return this.parent.getChildren().get(this.index - 1);
        }
        return null;
    }

    @Override
    public INode getNextNode() {
        INode nextNeighbor = this.getNextNeighbor();
        if (nextNeighbor != null) {
            return nextNeighbor;
        }
        return this.parent != null ? this.parent.getNextNode() : null;
    }

    @Override
    public INode getPreviousNode() {
        INode previousNeighbor = this.getPreviousNeighbor();
        if (previousNeighbor != null) {
            return previousNeighbor;
        }
        return this.parent != null ? this.parent.getPreviousNode() : null;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setHasLowestDepthError() {
        this.hasLowestDepthError = true;
    }

    @Override
    public IAttributesDictionary getAttributesDictionary() {
        return this.attributesDictionary != null ? this.attributesDictionary : new AttributesDictionary();
    }

    @Override
    public void setAttributesDictionary(IAttributesDictionary AttributesDictionary2) {
        this.attributesDictionary = AttributesDictionary2;
    }

    @Override
    public boolean getHasLowestDepthError() {
        return this.hasLowestDepthError;
    }

    @Override
    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getBoundingBox(), this.objectKeyNumber, this.index, this.initialSemanticType, this.depth});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        SemanticNode that = (SemanticNode)o;
        return Objects.equals(this.objectKeyNumber, that.objectKeyNumber) && Objects.equals(this.index, that.index) && Objects.equals(this.parent, that.parent) && Objects.equals((Object)this.initialSemanticType, (Object)that.initialSemanticType) && this.depth == that.depth;
    }

    public String toString() {
        return "SemanticNode{initialSemanticType=" + (Object)((Object)this.initialSemanticType) + ", correctSemanticScore=" + this.correctSemanticScore + ", pageNumber=" + this.getBoundingBox().getPageNumber() + ", boundingBox=" + this.getBoundingBox() + ", semanticType=" + (Object)((Object)this.semanticType) + ", children=" + this.children + '}';
    }
}

