/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.ITree;
import org.verapdf.wcag.algorithms.entities.SemanticFigure;
import org.verapdf.wcag.algorithms.entities.SemanticTable;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextColumn;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderCell;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderRow;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ClusterTableConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.WCAGConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TableUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.WCAGProgressStatus;

public class TableBorderConsumer
extends WCAGConsumer {
    public void recognizeTables(ITree tree) {
        for (INode node : tree) {
            if (!node.getChildren().isEmpty()) continue;
            if (node instanceof SemanticTextNode) {
                SemanticTextNode textNode = (SemanticTextNode)node;
                for (TextColumn column : textNode.getColumns()) {
                    for (TextLine line : column.getLines()) {
                        for (TextChunk chunk : line.getTextChunks()) {
                            this.add(new TableToken(chunk, node));
                        }
                    }
                }
                continue;
            }
            if (!(node instanceof SemanticFigure)) continue;
            SemanticFigure imageNode = (SemanticFigure)node;
            for (ImageChunk image : imageNode.getImages()) {
                this.add(new TableToken(image, (INode)imageNode));
            }
        }
        this.updateTreeWithRecognizedTables();
    }

    private void add(TableToken token) {
        TableBorderCell tableBorderCell;
        TableBorder tableBorder = StaticContainers.getTableBordersCollection().getTableBorder(token.getBoundingBox());
        if (tableBorder != null && (tableBorderCell = tableBorder.getTableBorderCell(token.getBoundingBox())) != null) {
            tableBorderCell.addContent(token);
        }
    }

    private void updateTreeWithRecognizedTables() {
        for (SortedSet<TableBorder> tables : StaticContainers.getTableBordersCollection().getTableBorders()) {
            for (TableBorder table : tables) {
                INode tableNode = this.getTableNode(table);
                if (tableNode == null) continue;
                table.setNode(tableNode);
                Integer depth = Arrays.stream(table.getRows()).map(TableBorderRow::getNode).filter(Objects::nonNull).map(INode::getDepth).min(Integer::compare).orElse(null);
                Set<INode> rowNodes = Arrays.stream(table.getRows()).map(TableBorderRow::getNode).collect(Collectors.toSet());
                if (depth != null) {
                    if (tableNode.getDepth() < depth - 1) {
                        TableBorderConsumer.updateTreeWithRecognizedTableRowsGroups(table, tableNode, rowNodes);
                    } else {
                        TableBorderConsumer.setTypesForEmptyRowNodes(table, tableNode.getChildren());
                    }
                    TableBorderConsumer.updateTreeWithRecognizedTableRows(table, depth);
                }
                if (!ClusterTableConsumer.isNodeInsideTable(tableNode, table.getRecognizedStructureId(), table.getBoundingBox(), SemanticType.TABLE)) continue;
                StaticContainers.getAccumulatedNodeMapper().updateNode(tableNode, new SemanticTable(table), 1.0, SemanticType.TABLE);
                ClusterTableConsumer.detectTableCaptions(table.getBoundingBox(), tableNode);
            }
        }
    }

    private static void setTypesForEmptyRowNodes(TableBorder table, List<INode> rowNodes) {
        if (rowNodes.size() == table.getNumberOfRows()) {
            for (int rowNumber = 0; rowNumber < table.getRows().length; ++rowNumber) {
                TableBorderRow row = table.getRow(rowNumber);
                INode rowNode = rowNodes.get(rowNumber);
                if (row.getNumberOfCellWithContent() == 0 && rowNode.getSemanticType() == null) {
                    rowNode.setSemanticType(SemanticType.TABLE_ROW);
                    rowNode.setBoundingBox(row.getBoundingBox());
                }
                row.setNode(rowNode);
            }
        }
    }

    private static void updateTreeWithRecognizedTableRows(TableBorder table, int depth) {
        for (TableBorderRow row : table.getRows()) {
            INode node = TableBorderConsumer.findParent(row.getNode(), depth);
            row.setNode(node);
            TableBorderConsumer.updateTreeWithRecognizedTableRow(row, table, depth);
            TableBorderConsumer.setType(node, SemanticType.TABLE_ROW, table.getRecognizedStructureId(), row.getBoundingBox());
        }
    }

    private static void updateTreeWithRecognizedTableRowsGroups(TableBorder table, INode tableNode, Set<INode> rowNodes) {
        SortedSet<INode> nodes = TableBorderConsumer.findParents(rowNodes, tableNode.getDepth() + 1);
        Iterator iterator = nodes.iterator();
        if (nodes.size() < 4) {
            if (nodes.size() == 1) {
                TableBorderConsumer.setType((INode)iterator.next(), SemanticType.TABLE_BODY, table.getRecognizedStructureId(), table.getBoundingBox());
            } else if (nodes.size() == 2) {
                TableBorderConsumer.setType((INode)iterator.next(), SemanticType.TABLE_HEADERS, table.getRecognizedStructureId(), table.getBoundingBox());
                TableBorderConsumer.setType((INode)iterator.next(), SemanticType.TABLE_BODY, table.getRecognizedStructureId(), table.getBoundingBox());
            } else if (nodes.size() == 3) {
                TableBorderConsumer.setType((INode)iterator.next(), SemanticType.TABLE_HEADERS, table.getRecognizedStructureId(), table.getBoundingBox());
                TableBorderConsumer.setType((INode)iterator.next(), SemanticType.TABLE_BODY, table.getRecognizedStructureId(), table.getBoundingBox());
                TableBorderConsumer.setType((INode)iterator.next(), SemanticType.TABLE_FOOTER, table.getRecognizedStructureId(), table.getBoundingBox());
            }
            ArrayList<INode> newRowNodes = new ArrayList<INode>();
            for (INode node : nodes) {
                newRowNodes.addAll(node.getChildren());
            }
            TableBorderConsumer.setTypesForEmptyRowNodes(table, newRowNodes);
        }
    }

    private static void updateTreeWithRecognizedTableRow(TableBorderRow row, TableBorder table, int depth) {
        INode rowNode = row.getNode();
        if (rowNode != null && rowNode.getChildren().size() == row.getNumberOfCells()) {
            int number = 0;
            for (int colNumber = 0; colNumber < row.getCells().length; ++colNumber) {
                TableBorderCell cell = row.getCell(colNumber);
                if (cell.getRowNumber() != row.getRowNumber() || cell.getColNumber() != colNumber) continue;
                INode cellNode = rowNode.getChildren().get(number);
                if (cell.getContent().isEmpty() && cellNode.getSemanticType() == null) {
                    cell.setNode(cellNode);
                    cellNode.setBoundingBox(cell.getBoundingBox());
                }
                ++number;
            }
        }
        List<INode> cells = TableBorderConsumer.findParents(Arrays.stream(row.getCells()).map(TableBorderCell::getNode).collect(Collectors.toList()), depth + 1);
        for (int colNumber = 0; colNumber < cells.size(); ++colNumber) {
            TableBorderCell cell = row.getCell(colNumber);
            if (cells.get(colNumber) == null || cell.getRowNumber() != row.getRowNumber() || cell.getColNumber() != colNumber) continue;
            MultiBoundingBox box = new MultiBoundingBox(cell.getBoundingBox());
            box.union(cell.getContentBoundingBox());
            if (TableBorderConsumer.isHeaderCell(cells.get(colNumber), cell, table)) {
                TableBorderConsumer.setType(cells.get(colNumber), SemanticType.TABLE_HEADER, table.getRecognizedStructureId(), box);
                cell.setSemanticType(SemanticType.TABLE_HEADER);
                continue;
            }
            TableBorderConsumer.setType(cells.get(colNumber), SemanticType.TABLE_CELL, table.getRecognizedStructureId(), box);
            cell.setSemanticType(SemanticType.TABLE_CELL);
        }
    }

    private static void setType(INode node, SemanticType type, Long id, BoundingBox boundingBox) {
        if (node != null) {
            if (TableUtils.isTableNode(node) && node.getRecognizedStructureId() != id || !ClusterTableConsumer.isNodeInsideTable(node, id, boundingBox, type)) {
                node.setRecognizedStructureId(null);
            } else {
                node.setRecognizedStructureId(id);
                node.setSemanticType(type);
                node.setCorrectSemanticScore(1.0);
                if (type != SemanticType.TABLE_FOOTER && type != SemanticType.TABLE_BODY && type != SemanticType.TABLE_HEADERS) {
                    node.getBoundingBox().union(boundingBox);
                }
            }
        }
    }

    private INode getTableNode(TableBorder table) {
        HashSet<INode> rowNodes = new HashSet<INode>();
        for (TableBorderRow row : table.getRows()) {
            INode rowNode = this.getRowNode(row);
            if (rowNode == null) continue;
            row.setNode(rowNode);
            rowNodes.add(rowNode);
        }
        INode tableNode = TableBorderConsumer.findCommonParent(rowNodes);
        if (table.getNumberOfRowsWithContent() == 1 && tableNode != null) {
            INode parentTableNode;
            while (!tableNode.isRoot() && tableNode.getInitialSemanticType() != SemanticType.TABLE && TableBorderConsumer.getNumberOfChildrenWithContent(parentTableNode = tableNode.getParent()) == 1) {
                tableNode = parentTableNode;
            }
        }
        if (tableNode != null) {
            while (TableUtils.isInitialTableNode(tableNode) && tableNode.getInitialSemanticType() != SemanticType.TABLE && !tableNode.isRoot() && (tableNode.getParent().getChildren().size() == 1 || tableNode.getParent().getBoundingBox().isSeveralPagesBoundingBox())) {
                tableNode = tableNode.getParent();
            }
        }
        return tableNode;
    }

    private static int getNumberOfChildrenWithContent(INode node) {
        int numberOfChildrenWithContent = 0;
        for (INode child : node.getChildren()) {
            if (child.getSemanticType() == null) continue;
            ++numberOfChildrenWithContent;
        }
        return numberOfChildrenWithContent;
    }

    private INode getRowNode(TableBorderRow row) {
        HashSet<INode> cellNodes = new HashSet<INode>();
        for (int colNumber = 0; colNumber < row.getCells().length; ++colNumber) {
            INode cellNode;
            TableBorderCell cell = row.getCell(colNumber);
            if (cell.getRowNumber() != row.getRowNumber() || cell.getColNumber() != colNumber || (cellNode = this.getCellNode(cell)) == null) continue;
            cell.setNode(cellNode);
            cellNodes.add(cellNode);
        }
        INode rowNode = TableBorderConsumer.findCommonParent(cellNodes);
        if (rowNode != null && row.getNumberOfCellWithContent() == 1) {
            INode parentRowNode;
            while (!rowNode.isRoot() && rowNode.getInitialSemanticType() != SemanticType.TABLE_ROW && TableBorderConsumer.getNumberOfChildrenWithContent(parentRowNode = rowNode.getParent()) == 1 && parentRowNode.getInitialSemanticType() != SemanticType.TABLE && parentRowNode.getInitialSemanticType() != SemanticType.TABLE_BODY && parentRowNode.getInitialSemanticType() != SemanticType.TABLE_FOOTER && parentRowNode.getInitialSemanticType() != SemanticType.TABLE_HEADER) {
                rowNode = parentRowNode;
            }
        }
        return rowNode;
    }

    private static boolean isHeaderCell(INode cellNode, TableBorderCell cell, TableBorder table) {
        if (cellNode.getInitialSemanticType() != SemanticType.TABLE_HEADER) {
            return false;
        }
        if (cell.getColNumber() == 0 || cell.getRowNumber() == 0) {
            return true;
        }
        for (int rowNumber = cell.getRowNumber(); rowNumber < cell.getRowNumber() + cell.getRowSpan(); ++rowNumber) {
            if (table.getRow(rowNumber).getCell(cell.getColNumber() - 1).getSemanticType() != SemanticType.TABLE_HEADER) continue;
            return true;
        }
        for (int colNumber = cell.getColNumber(); colNumber < cell.getColNumber() + cell.getColSpan(); ++colNumber) {
            if (table.getRow(cell.getRowNumber() - 1).getCell(colNumber).getSemanticType() != SemanticType.TABLE_HEADER) continue;
            return true;
        }
        return false;
    }

    private INode getCellNode(TableBorderCell cell) {
        HashSet<INode> tableLeafNodes = new HashSet<INode>();
        for (TableToken token : cell.getContent()) {
            if (token.getNode() == null) continue;
            tableLeafNodes.add(token.getNode());
        }
        return TableBorderConsumer.findCommonParent(tableLeafNodes);
    }

    private static INode findParent(INode node, int depth) {
        if (node != null) {
            while (node.getDepth() > depth) {
                node = node.getParent();
            }
            if (node.getDepth() == depth) {
                return node;
            }
        }
        return null;
    }

    private static SortedSet<INode> findParents(Set<INode> nodes, int depth) {
        TreeSet<INode> parents = new TreeSet<INode>(Comparator.comparing(INode::getIndex));
        for (INode node : nodes) {
            if (node == null) continue;
            parents.add(TableBorderConsumer.findParent(node, depth));
        }
        return parents;
    }

    private static List<INode> findParents(List<INode> nodes, int depth) {
        return nodes.stream().map(node -> TableBorderConsumer.findParent(node, depth)).collect(Collectors.toList());
    }

    public static INode findCommonParent(Set<INode> nodes) {
        if (nodes.size() == 0) {
            return null;
        }
        if (nodes.size() == 1) {
            return nodes.iterator().next();
        }
        int minDepth = nodes.stream().map(INode::getDepth).min(Integer::compareTo).orElse(0);
        HashSet<INode> parents = new HashSet<INode>();
        Iterator<INode> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            INode node;
            INode parent = node = iterator.next();
            while (parent.getDepth() > minDepth) {
                parent = parent.getParent();
            }
            parents.add(parent);
        }
        while (parents.size() > 1) {
            HashSet<INode> parentsSet = new HashSet<INode>();
            for (INode node : parents) {
                parentsSet.add(node.getParent());
            }
            parents = parentsSet;
        }
        return (INode)parents.iterator().next();
    }

    @Override
    public WCAGProgressStatus getWCAGProgressStatus() {
        return WCAGProgressStatus.TABLE_BORDER_DETECTION;
    }
}

