/*
 * This file is part of veraPDF wcag algorithms, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF wcag algorithms is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF wcag algorithms as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF wcag algorithms as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection;

public class RomanNumbersListLabelsDetectionAlgorithm extends LettersListLabelsDetectionAlgorithm {

    protected static final String ROMAN_NUMBER_REGEX = "[MDCLXVImdclxvi]*";
    private static final String UPPER_CASE_ROMAN_NUMBER_REGEX = "[MDCLXVI]+";
    private static final String LOWER_CASE_ROMAN_NUMBER_REGEX = "[mdclxvi]+";

    @Override
    protected String getRegex() {
        return ROMAN_NUMBER_REGEX;
    }

    @Override
    protected String getLowerCaseRegex() {
        return LOWER_CASE_ROMAN_NUMBER_REGEX;
    }

    @Override
    protected String getUpperCaseRegex() {
        return UPPER_CASE_ROMAN_NUMBER_REGEX;
    }

    @Override
    protected String getStringFromNumber(Integer number) {
        return new RomanNumber(number).toString();
    }

    @Override
    protected Integer getNumberFromString(String string) {
        try {
            return new RomanNumber(string.toUpperCase()).getArabicNumber();
        } catch (NumberFormatException ignored) {
        }
        return null;
    }

    @Override
    protected Boolean checkPrefixAndSuffix(String prefix, String suffix) {
        return (prefix.isEmpty() || !Character.isLetter(prefix.charAt(prefix.length() - 1))) &&
               (suffix.isEmpty() || !Character.isLetter(suffix.charAt(0)));
    }
}
