/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.lists;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.lists.ListItem;
import org.verapdf.wcag.algorithms.entities.tables.Table;
import org.verapdf.wcag.algorithms.entities.tables.TableCell;
import org.verapdf.wcag.algorithms.entities.tables.TableRow;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.entities.tables.TableTokenRow;

public class PDFList
extends InfoChunk {
    private static final double LIST_ITEM_EPSILON = 0.2;
    private final List<ListItem> listItems;
    private PDFList previousList = null;
    private PDFList nextList = null;
    private String commonPrefix = null;
    private String numberingStyle = "unknown style";

    public PDFList(Table table) {
        super(table.getBoundingBox());
        this.setRecognizedStructureId(table.getId());
        this.listItems = new ArrayList<ListItem>();
        this.createListItemsFromTableRows(table.getRows());
    }

    public PDFList(Long id) {
        this.setRecognizedStructureId(id);
        this.listItems = new ArrayList<ListItem>();
    }

    public PDFList() {
        this.listItems = new ArrayList<ListItem>();
    }

    public String getNumberingStyle() {
        return this.numberingStyle;
    }

    public void setNumberingStyle(String numberingStyle) {
        this.numberingStyle = numberingStyle;
    }

    public int getNumberOfListItems() {
        return this.listItems.size();
    }

    public List<ListItem> getListItems() {
        return this.listItems;
    }

    public ListItem getLastListItem() {
        return this.listItems.get(this.listItems.size() - 1);
    }

    public ListItem getFirstListItem() {
        return this.listItems.get(0);
    }

    public ListItem getPenultListItem() {
        return this.listItems.get(this.listItems.size() - 2);
    }

    public ListItem getSecondListItem() {
        return this.listItems.get(1);
    }

    public void add(ListItem listItem) {
        this.listItems.add(listItem);
        this.getBoundingBox().union(listItem.getBoundingBox());
    }

    public void add(int index, ListItem listItem) {
        this.listItems.add(index, listItem);
        this.getBoundingBox().union(listItem.getBoundingBox());
    }

    public void add(PDFList list) {
        this.listItems.addAll(list.getListItems());
        this.getBoundingBox().union(list.getBoundingBox());
        if (list.getNextList() != null) {
            PDFList.setListConnected(this, list.getNextList());
        }
    }

    private void createListItemsFromTableRows(List<TableRow> tableRows) {
        ListItem lastListItem = null;
        TableCell previousFirstCell = null;
        for (TableRow row : tableRows) {
            TableCell firstCell = row.getCells().get(0);
            if (firstCell.getString().trim().isEmpty() && (firstCell.getContent().isEmpty() || firstCell.getContent().get(0).getType() == TableToken.TableTokenType.TEXT) && lastListItem != null) {
                if (firstCell.getContent().isEmpty() && lastListItem.getLabel().getRightX() > row.getCells().get(1).getLeftX()) {
                    return;
                }
                this.addContentToPreviousListItem(this.listItems.size() > 1 ? this.listItems.get(this.listItems.size() - 2) : null, row.getCells().get(1), previousFirstCell);
                lastListItem.add(row);
                continue;
            }
            this.addContentToPreviousListItem(lastListItem, row.getCells().get(1), firstCell);
            lastListItem = new ListItem(row);
            this.add(lastListItem);
            previousFirstCell = firstCell;
        }
    }

    private void addContentToPreviousListItem(ListItem previousListItem, TableCell secondCell, TableCell firstCell) {
        if (previousListItem == null || firstCell == null) {
            return;
        }
        if (firstCell.getBoundingBox().getTopY() >= secondCell.getBoundingBox().getTopY()) {
            return;
        }
        for (TableTokenRow tokenRow : secondCell.getContent()) {
            if (!(tokenRow.getBoundingBox().getTopY() > firstCell.getBoundingBox().getTopY() + 0.2 * firstCell.getBoundingBox().getHeight())) continue;
            previousListItem.getBody().add(tokenRow);
        }
        secondCell.getContent().removeAll(previousListItem.getBody().getContent());
    }

    public Long getPreviousListId() {
        return this.previousList != null ? this.previousList.getRecognizedStructureId() : null;
    }

    public Long getNextListId() {
        return this.nextList != null ? this.nextList.getRecognizedStructureId() : null;
    }

    public PDFList getPreviousList() {
        return this.previousList;
    }

    public void setPreviousList(PDFList previousList) {
        this.previousList = previousList;
    }

    public PDFList getNextList() {
        return this.nextList;
    }

    public void setNextList(PDFList nextList) {
        this.nextList = nextList;
    }

    public static void setListConnected(PDFList firstList, PDFList secondList) {
        firstList.setNextList(secondList);
        secondList.setPreviousList(firstList);
    }

    public String getCommonPrefix() {
        return this.commonPrefix;
    }

    public void setCommonPrefix(String commonPrefix) {
        this.commonPrefix = commonPrefix;
    }
}

