/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.sa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.verapdf.gf.model.impl.containers.StaticStorages;
import org.verapdf.gf.model.impl.sa.GFSAContentStream;
import org.verapdf.gf.model.impl.sa.GFSAPage;
import org.verapdf.gf.model.impl.sa.GFSARepeatedCharacters;
import org.verapdf.gf.model.impl.sa.GFSAStructTreeRoot;
import org.verapdf.gf.model.impl.sa.lists.GFSAList;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.salayer.SAList;
import org.verapdf.model.salayer.SAPDFDocument;
import org.verapdf.model.salayer.SARepeatedCharacters;
import org.verapdf.model.salayer.SAStructTreeRoot;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.PDPage;
import org.verapdf.pd.structure.PDStructTreeRoot;
import org.verapdf.tools.PageLabels;
import org.verapdf.wcag.algorithms.entities.IDocument;
import org.verapdf.wcag.algorithms.entities.IPage;
import org.verapdf.wcag.algorithms.entities.ITree;
import org.verapdf.wcag.algorithms.entities.RepeatedCharacters;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.lists.PDFList;
import org.verapdf.wcag.algorithms.semanticalgorithms.AccumulatedNodeSemanticChecker;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;

public class GFSAPDFDocument
extends GenericModelObject
implements SAPDFDocument,
IDocument {
    public static final String DOCUMENT_TYPE = "SAPDFDocument";
    protected PDDocument document;
    public static final int MAX_NUMBER_OF_ELEMENTS = 1;
    public static final String STRUCTURE_TREE_ROOT = "StructTreeRoot";
    public static final String PAGES = "pages";
    private static final String REPEATED_CHARACTERS = "repeatedCharacters";
    private static final String LISTS = "lists";
    private List<SARepeatedCharacters> repeatedCharacters = null;
    private List<SAList> lists = null;
    private List<GFSAPage> pages;
    private GFSAStructTreeRoot treeRoot = null;
    private Boolean hasStructTreeRoot = null;

    public GFSAPDFDocument(PDDocument document) {
        super(DOCUMENT_TYPE);
        this.document = document;
        StaticStorages.clearAllContainers();
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "StructTreeRoot": {
                return this.getStructureTreeRoot();
            }
            case "pages": {
                return this.getpages();
            }
            case "repeatedCharacters": {
                return this.getRepeatedCharacters();
            }
            case "lists": {
                return this.getLists();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<GFSAPage> parsePages() {
        ArrayList<GFSAPage> result = new ArrayList<GFSAPage>();
        List rawPages = this.document.getPages();
        PageLabels pageLabels = this.document.getCatalog() != null ? this.document.getCatalog().getPageLabels() : null;
        for (int pageNumber = 0; pageNumber < rawPages.size(); ++pageNumber) {
            PDPage page = (PDPage)rawPages.get(pageNumber);
            result.add(new GFSAPage(page, pageLabels != null ? pageLabels.getLabel(pageNumber) : null));
        }
        return Collections.unmodifiableList(result);
    }

    private List<GFSAPage> getpages() {
        if (this.pages == null) {
            this.pages = this.parsePages();
        }
        return this.pages;
    }

    public int getNumberOfPages() {
        if (this.pages == null) {
            this.pages = this.parsePages();
        }
        return this.pages.size();
    }

    public List<IPage> getPages() {
        if (this.pages == null) {
            this.pages = this.parsePages();
        }
        return Collections.unmodifiableList(this.pages);
    }

    private void parseStructureTreeRoot() {
        PDStructTreeRoot root = this.document.getStructTreeRoot();
        if (root != null) {
            this.treeRoot = new GFSAStructTreeRoot(root);
            this.hasStructTreeRoot = true;
        } else {
            this.hasStructTreeRoot = false;
        }
    }

    public List<SAStructTreeRoot> getStructureTreeRoot() {
        if (this.hasStructTreeRoot == null) {
            this.checkSemantic();
        }
        if (this.treeRoot != null) {
            ArrayList<GFSAStructTreeRoot> res = new ArrayList<GFSAStructTreeRoot>(1);
            res.add(this.treeRoot);
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<SARepeatedCharacters> getRepeatedCharacters() {
        if (this.repeatedCharacters == null) {
            if (StaticContainers.getRepeatedCharacters() == null) {
                this.repeatedCharacters = new ArrayList<SARepeatedCharacters>();
            } else {
                this.repeatedCharacters = new ArrayList<SARepeatedCharacters>(StaticContainers.getRepeatedCharacters().size());
                for (RepeatedCharacters characters : StaticContainers.getRepeatedCharacters()) {
                    this.repeatedCharacters.add(new GFSARepeatedCharacters(characters));
                }
            }
        }
        return this.repeatedCharacters;
    }

    private List<SAList> getLists() {
        if (this.lists == null) {
            if (StaticContainers.getListsCollection() == null) {
                this.lists = new ArrayList<SAList>();
            } else {
                this.lists = new ArrayList<SAList>(StaticContainers.getListsCollection().size());
                for (PDFList list : StaticContainers.getListsCollection()) {
                    this.lists.add(new GFSAList(list));
                }
            }
        }
        return this.lists;
    }

    private void parseChunks() {
        if (this.pages == null) {
            this.pages = this.parsePages();
        }
        for (GFSAPage page : this.pages) {
            GFSAContentStream contentStream = page.getContentStream();
            if (contentStream == null) continue;
            contentStream.parseChunks();
        }
    }

    public List<IChunk> getArtifacts(Integer pageNumber) {
        if (pageNumber < this.pages.size()) {
            return this.pages.get(pageNumber).getArtifacts();
        }
        return Collections.emptyList();
    }

    public IPage getPage(Integer pageNumber) {
        if (pageNumber < this.pages.size()) {
            return this.pages.get(pageNumber);
        }
        return null;
    }

    public List<IChunk> getArtifacts() {
        LinkedList<IChunk> artifacts = new LinkedList<IChunk>();
        for (GFSAPage page : this.pages) {
            artifacts.addAll(page.getArtifacts());
        }
        return artifacts;
    }

    public ITree getTree() {
        return this.treeRoot;
    }

    private void checkSemantic() {
        this.parseChunks();
        this.parseStructureTreeRoot();
        AccumulatedNodeSemanticChecker accumulatedNodeSemanticChecker = new AccumulatedNodeSemanticChecker();
        accumulatedNodeSemanticChecker.checkSemanticDocument((IDocument)this, this.document.getDocument().getFileName());
    }
}

