/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.chunks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.factory.chunks.CurveChunk;
import org.verapdf.gf.model.factory.chunks.GraphicsState;
import org.verapdf.gf.model.factory.chunks.LineArtContainer;
import org.verapdf.gf.model.factory.chunks.Matrix;
import org.verapdf.gf.model.factory.chunks.Path;
import org.verapdf.gf.model.factory.chunks.Rectangle;
import org.verapdf.gf.model.factory.chunks.TextChunksHelper;
import org.verapdf.gf.model.factory.chunks.TextPieces;
import org.verapdf.gf.model.impl.containers.StaticStorages;
import org.verapdf.gf.model.impl.sa.GFSAXForm;
import org.verapdf.gf.model.impl.sa.util.ResourceHandler;
import org.verapdf.operator.Operator;
import org.verapdf.pd.PDExtGState;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceCMYK;
import org.verapdf.pd.colors.PDDeviceGray;
import org.verapdf.pd.colors.PDDeviceRGB;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.images.PDXForm;
import org.verapdf.pd.images.PDXObject;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.Vertex;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

class ChunkParser {
    private static final Logger LOGGER = Logger.getLogger(ChunkParser.class.getName());
    private final Deque<GraphicsState> graphicsStateStack = new ArrayDeque<GraphicsState>();
    private final Stack<Long> markedContentStack = new Stack();
    private final Set<Long> processedMCIDs = new HashSet<Long>();
    private final Integer pageNumber;
    private final COSKey objectKey;
    private Matrix textMatrix = null;
    private Matrix textLineMatrix = null;
    private final ResourceHandler resourceHandler;
    private final GraphicsState graphicsState;
    private final Path path = new Path();
    private final List<IChunk> artifacts = new LinkedList<IChunk>();
    private List<Object> nonDrawingArtifacts = new ArrayList<Object>();
    private final LineArtContainer lineArtContainer;
    private final COSKey parentObjectKey;
    private final Long parentMarkedContent;

    public ChunkParser(Integer pageNumber, COSKey objectKey, GraphicsState inheritedGraphicState, ResourceHandler resourceHandler, COSKey parentObjectKey, Long markedContent) {
        this.pageNumber = pageNumber;
        this.lineArtContainer = new LineArtContainer(objectKey);
        this.objectKey = objectKey;
        this.graphicsState = inheritedGraphicState.clone();
        this.resourceHandler = resourceHandler;
        this.parentObjectKey = parentObjectKey;
        this.parentMarkedContent = markedContent;
    }

    public List<IChunk> getArtifacts() {
        return this.artifacts;
    }

    public void parseChunk(Operator rawOperator, List<COSBase> arguments) {
        String operatorName;
        switch (operatorName = rawOperator.getOperator()) {
            case "BMC": 
            case "BDC": {
                this.processLineArts();
                Long mcid = ChunkParser.getMCID(arguments, this.resourceHandler);
                if (mcid != null) {
                    if (this.processedMCIDs.contains(mcid)) {
                        mcid = null;
                    } else {
                        this.processedMCIDs.add(mcid);
                    }
                }
                this.markedContentStack.push(mcid);
                break;
            }
            case "EMC": {
                this.processLineArts();
                this.markedContentStack.pop();
                break;
            }
            case "g": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                ChunkParser.processColorSpace(this.graphicsState, this.resourceHandler, (PDColorSpace)PDDeviceGray.INSTANCE, ASAtom.DEVICEGRAY, false);
                if (this.isProcessColorSpace(this.graphicsState.getFillColorSpace())) {
                    Double fillColor = this.getValueOfLastNumber(arguments);
                    if (fillColor == null) break;
                    this.graphicsState.setFillColor(new double[]{fillColor});
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "rg": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                ChunkParser.processColorSpace(this.graphicsState, this.resourceHandler, (PDColorSpace)PDDeviceRGB.INSTANCE, ASAtom.DEVICERGB, false);
                if (this.isProcessColorSpace(this.graphicsState.getFillColorSpace())) {
                    if (arguments.size() != 3 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber()) break;
                    this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal()});
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "k": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                ChunkParser.processColorSpace(this.graphicsState, this.resourceHandler, (PDColorSpace)PDDeviceCMYK.INSTANCE, ASAtom.DEVICECMYK, false);
                if (this.isProcessColorSpace(this.graphicsState.getFillColorSpace())) {
                    if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                    this.graphicsState.setFillColor(new double[]{arguments.get(0).getReal(), arguments.get(1).getReal(), arguments.get(2).getReal(), arguments.get(3).getReal()});
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "scn": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                PDColorSpace colorSpace = this.graphicsState.getFillColorSpace();
                if (this.isProcessColorSpace(colorSpace)) {
                    try {
                        int size = arguments.size();
                        if (!arguments.get(size - 1).getType().isNumber()) {
                            --size;
                        }
                        double[] colorArguments = new double[size];
                        boolean areNumbers = true;
                        for (int i = 0; i < size; ++i) {
                            if (!arguments.get(i).getType().isNumber()) {
                                areNumbers = false;
                                break;
                            }
                            colorArguments[i] = arguments.get(i).getReal();
                        }
                        if (!areNumbers) break;
                        this.graphicsState.setFillColor(colorSpace.toRGB(colorArguments));
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Error setting fill color with scn operator", e);
                    }
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "sc": {
                ASAtom colorSpaceType;
                if (!this.graphicsState.isProcessColorOperators()) break;
                PDColorSpace colorSpace = this.graphicsState.getFillColorSpace();
                ASAtom aSAtom = colorSpaceType = colorSpace != null ? colorSpace.getType() : null;
                if (ASAtom.DEVICERGB.equals((Object)colorSpaceType) || ASAtom.DEVICEGRAY.equals((Object)colorSpaceType) || ASAtom.DEVICECMYK.equals((Object)colorSpaceType) || ASAtom.CALRGB.equals((Object)colorSpaceType) || ASAtom.CALGRAY.equals((Object)colorSpaceType) || ASAtom.INDEXED.equals((Object)colorSpaceType) || ASAtom.LAB.equals((Object)colorSpaceType) || ASAtom.ICCBASED.equals((Object)colorSpaceType)) {
                    try {
                        double[] colorArguments = new double[arguments.size()];
                        boolean areNumbers = true;
                        for (int i = 0; i < arguments.size(); ++i) {
                            if (!arguments.get(i).getType().isNumber()) {
                                areNumbers = false;
                                break;
                            }
                            colorArguments[i] = arguments.get(i).getReal();
                        }
                        if (!areNumbers) break;
                        this.graphicsState.setFillColor(colorSpace.toRGB(colorArguments));
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Error setting fill color with sc operator", e);
                    }
                    break;
                }
                this.graphicsState.setFillColor(new double[0]);
                break;
            }
            case "cs": {
                if (!this.graphicsState.isProcessColorOperators()) break;
                this.graphicsState.setFillColorSpace(this.resourceHandler.getColorSpace(ChunkParser.getLastCOSName(arguments)));
                break;
            }
            case "ET": {
                this.processLineArts();
                this.textMatrix = null;
                this.textLineMatrix = null;
                break;
            }
            case "BT": {
                this.processLineArts();
                this.textMatrix = new Matrix();
                this.textLineMatrix = new Matrix();
                break;
            }
            case "Td": {
                if (arguments.size() <= 1 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber()) break;
                this.processTd(arguments.get(0).getReal(), arguments.get(1).getReal());
                break;
            }
            case "TD": {
                if (arguments.size() <= 1 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber()) break;
                this.processTD(arguments.get(0).getReal(), arguments.get(1).getReal());
                break;
            }
            case "Tm": {
                this.textMatrix = new Matrix(arguments);
                this.textLineMatrix = this.textMatrix.clone();
                break;
            }
            case "Tr": {
                int renderingMode;
                if (arguments.size() != 1 || !arguments.get(0).getType().isNumber() || (renderingMode = arguments.get(0).getInteger().intValue()) < 0 || renderingMode > 7) break;
                this.graphicsState.getTextState().setRenderingMode(renderingMode);
                break;
            }
            case "T*": {
                this.processT_STAR();
                break;
            }
            case "Tj": {
                this.processLineArts();
                TextChunk textChunk = this.createTextChunk(arguments, "Tj");
                if (textChunk == null) break;
                this.putChunk(this.getMarkedContent(), (IChunk)textChunk);
                break;
            }
            case "TJ": {
                this.processLineArts();
                TextChunk textChunk = this.createTextChunk(arguments, "TJ");
                if (textChunk == null) break;
                this.putChunk(this.getMarkedContent(), (IChunk)textChunk);
                break;
            }
            case "'": {
                this.processLineArts();
                this.processT_STAR();
                TextChunk textChunk = this.createTextChunk(arguments, "'");
                if (textChunk == null) break;
                this.putChunk(this.getMarkedContent(), (IChunk)textChunk);
                break;
            }
            case "\"": {
                TextChunk textChunk;
                this.processLineArts();
                if (arguments.size() > 1 && arguments.get(0).getType().isNumber() && arguments.get(1).getType().isNumber()) {
                    this.processDoubleQuote(arguments.get(0).getReal(), arguments.get(1).getReal());
                }
                if ((textChunk = this.createTextChunk(arguments, "\"")) == null) break;
                this.putChunk(this.getMarkedContent(), (IChunk)textChunk);
                break;
            }
            case "Tz": {
                Double horizontalScaling = this.getValueOfLastNumber(arguments);
                if (horizontalScaling == null) break;
                this.graphicsState.getTextState().setHorizontalScaling(horizontalScaling / 100.0);
                break;
            }
            case "Tf": {
                COSBase textFontSize;
                this.graphicsState.getTextState().setTextFont(this.resourceHandler.getFont(ChunkParser.getFirstCOSName(arguments)));
                if (arguments.size() <= 1 || !(textFontSize = arguments.get(1)).getType().isNumber()) break;
                this.graphicsState.getTextState().setTextFontSize(textFontSize.getReal());
                break;
            }
            case "Tc": {
                Double characterSpacing = this.getValueOfLastNumber(arguments);
                if (characterSpacing == null) break;
                this.graphicsState.getTextState().setCharacterSpacing(characterSpacing);
                break;
            }
            case "Tw": {
                Double wordSpacing = this.getValueOfLastNumber(arguments);
                if (wordSpacing == null) break;
                this.graphicsState.getTextState().setWordSpacing(wordSpacing);
                break;
            }
            case "TL": {
                Double textLeading = this.getValueOfLastNumber(arguments);
                if (textLeading == null) break;
                this.graphicsState.getTextState().setTextLeading(textLeading);
                break;
            }
            case "Ts": {
                Double textRise = this.getValueOfLastNumber(arguments);
                if (textRise == null) break;
                this.graphicsState.getTextState().setTextRise(textRise);
                break;
            }
            case "BI": {
                this.processLineArts();
                this.putChunk(this.getMarkedContent(), (IChunk)new ImageChunk(this.parseImageBoundingBox()));
                break;
            }
            case "c": {
                if (arguments.size() != 6 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber() || !arguments.get(4).getType().isNumber() || !arguments.get(5).getType().isNumber()) break;
                CurveChunk curve = new CurveChunk(this.pageNumber, new Vertex(this.path.getCurrentX(), this.path.getCurrentY()), new Vertex(arguments.get(0).getReal().doubleValue(), arguments.get(1).getReal().doubleValue()), new Vertex(arguments.get(2).getReal().doubleValue(), arguments.get(3).getReal().doubleValue()), new Vertex(arguments.get(4).getReal().doubleValue(), arguments.get(5).getReal().doubleValue()), this.graphicsState.getLineWidth());
                this.path.setCurrentPoint(curve.getX3(), curve.getY3());
                this.nonDrawingArtifacts.add((Object)curve);
                break;
            }
            case "h": {
                this.processh();
                break;
            }
            case "f": 
            case "F": 
            case "f*": {
                this.processh();
                this.processf();
                break;
            }
            case "gs": {
                PDExtGState extGState = this.resourceHandler.getExtGState(ChunkParser.getLastCOSName(arguments));
                this.graphicsState.copyPropertiesFromExtGState(extGState);
                break;
            }
            case "l": {
                if (arguments.size() != 2 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber()) break;
                double x = arguments.get(0).getReal();
                double y = arguments.get(1).getReal();
                if (!NodeUtils.areCloseNumbers((double)this.path.getCurrentX(), (double)x) || !NodeUtils.areCloseNumbers((double)this.path.getCurrentY(), (double)y)) {
                    this.nonDrawingArtifacts.add(new LineChunk(this.pageNumber, this.path.getCurrentX(), this.path.getCurrentY(), x, y, this.graphicsState.getLineWidth()));
                }
                this.path.setCurrentPoint(x, y);
                break;
            }
            case "m": {
                if (arguments.size() != 2 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber()) break;
                double x = arguments.get(0).getReal();
                double y = arguments.get(1).getReal();
                this.path.setStartPoint(x, y);
                this.path.setCurrentPoint(x, y);
                break;
            }
            case "w": {
                double width;
                if (arguments.size() != 1 || !arguments.get(0).getType().isNumber() || !((width = arguments.get(0).getReal().doubleValue()) > 0.0)) break;
                this.graphicsState.setLineWidth(width);
                break;
            }
            case "J": {
                if (arguments.size() != 1 || arguments.get(0).getType() != COSObjType.COS_INTEGER) break;
                this.graphicsState.setLineCap(arguments.get(0).getInteger().intValue());
                break;
            }
            case "re": {
                if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                double x = arguments.get(0).getReal();
                double y = arguments.get(1).getReal();
                this.nonDrawingArtifacts.add(new Rectangle(this.pageNumber, x, y, arguments.get(2).getReal(), arguments.get(3).getReal()));
                this.path.setCurrentPoint(x, y);
                this.path.setStartPoint(x, y);
                break;
            }
            case "v": {
                if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                CurveChunk curve = new CurveChunk(this.pageNumber, new Vertex(this.path.getCurrentX(), this.path.getCurrentY()), new Vertex(arguments.get(0).getReal().doubleValue(), arguments.get(1).getReal().doubleValue()), new Vertex(arguments.get(2).getReal().doubleValue(), arguments.get(3).getReal().doubleValue()), this.graphicsState.getLineWidth(), true);
                this.path.setCurrentPoint(curve.getX3(), curve.getY3());
                this.nonDrawingArtifacts.add((Object)curve);
                break;
            }
            case "y": {
                if (arguments.size() != 4 || !arguments.get(0).getType().isNumber() || !arguments.get(1).getType().isNumber() || !arguments.get(2).getType().isNumber() || !arguments.get(3).getType().isNumber()) break;
                CurveChunk curve = new CurveChunk(this.pageNumber, new Vertex(this.path.getCurrentX(), this.path.getCurrentY()), new Vertex(arguments.get(0).getReal().doubleValue(), arguments.get(1).getReal().doubleValue()), new Vertex(arguments.get(2).getReal().doubleValue(), arguments.get(3).getReal().doubleValue()), this.graphicsState.getLineWidth(), false);
                this.path.setCurrentPoint(curve.getX3(), curve.getY3());
                this.nonDrawingArtifacts.add((Object)curve);
                break;
            }
            case "b": 
            case "b*": {
                this.processh();
                this.processB();
                break;
            }
            case "B": 
            case "B*": {
                this.processB();
                break;
            }
            case "n": {
                this.nonDrawingArtifacts = new ArrayList<Object>();
                break;
            }
            case "s": {
                this.processh();
                this.processS();
                break;
            }
            case "S": {
                this.processS();
                break;
            }
            case "cm": {
                this.graphicsState.getCTM().concatenate(new Matrix(arguments));
                break;
            }
            case "Q": {
                if (this.graphicsStateStack.isEmpty()) break;
                this.graphicsState.copyProperties(this.graphicsStateStack.pop());
                break;
            }
            case "q": {
                this.graphicsStateStack.push(this.graphicsState.clone());
                break;
            }
            case "Do": {
                this.processLineArts();
                PDXObject xObject = this.resourceHandler.getXObject(ChunkParser.getLastCOSName(arguments));
                if (xObject == null) break;
                if (ASAtom.IMAGE.equals((Object)xObject.getType())) {
                    this.putChunk(this.getMarkedContent(), (IChunk)new ImageChunk(this.parseImageBoundingBox()));
                    break;
                }
                if (!ASAtom.FORM.equals((Object)xObject.getType())) break;
                Long markedContent = this.getMarkedContent();
                COSKey key = this.objectKey;
                if (markedContent == null) {
                    key = this.parentObjectKey;
                    markedContent = this.parentMarkedContent;
                }
                GraphicsState xFormGraphicsState = this.graphicsState.clone();
                xFormGraphicsState.getCTM().concatenate(new Matrix(((PDXForm)xObject).getMatrix()));
                GFSAXForm xForm = new GFSAXForm((PDXForm)xObject, this.resourceHandler, xFormGraphicsState, this.pageNumber, key, markedContent);
                this.artifacts.addAll(xForm.getArtifacts());
                break;
            }
            case "d1": {
                this.graphicsState.disableColorOperators();
                break;
            }
        }
    }

    private static COSName getFirstCOSName(List<COSBase> arguments) {
        COSBase lastElement;
        COSBase cOSBase = lastElement = arguments.isEmpty() ? null : arguments.get(0);
        if (lastElement instanceof COSName) {
            return (COSName)lastElement;
        }
        return null;
    }

    private static COSName getLastCOSName(List<COSBase> arguments) {
        COSBase lastElement;
        COSBase cOSBase = lastElement = arguments.isEmpty() ? null : arguments.get(arguments.size() - 1);
        if (lastElement instanceof COSName) {
            return (COSName)lastElement;
        }
        return null;
    }

    private void processT_STAR() {
        this.processTD(0.0, -this.graphicsState.getTextState().getTextLeading());
    }

    private void processTD(double op1, double op2) {
        this.graphicsState.getTextState().setTextLeading(-op2);
        this.processTd(op1, op2);
    }

    private void processTd(double op1, double op2) {
        if (this.textLineMatrix != null) {
            this.textLineMatrix.concatenate(Matrix.getTranslateInstance(op1, op2));
            this.textMatrix = this.textLineMatrix.clone();
        } else {
            LOGGER.log(Level.WARNING, "Text operator not inside text content");
        }
    }

    private void processDoubleQuote(double op1, double op2) {
        this.graphicsState.getTextState().setWordSpacing(op1);
        this.graphicsState.getTextState().setCharacterSpacing(op2);
    }

    private void processh() {
        if (!NodeUtils.areCloseNumbers((double)this.path.getStartX(), (double)this.path.getCurrentX()) || !NodeUtils.areCloseNumbers((double)this.path.getStartY(), (double)this.path.getCurrentY())) {
            this.nonDrawingArtifacts.add(new LineChunk(this.pageNumber, this.path.getCurrentX(), this.path.getCurrentY(), this.path.getStartX(), this.path.getStartY(), this.graphicsState.getLineWidth()));
        }
        this.path.setCurrentPoint(this.path.getStartX(), this.path.getStartY());
    }

    private void processB() {
        Long mcid = this.getMarkedContent();
        MultiBoundingBox boundingBox = new MultiBoundingBox();
        for (Object chunk : this.nonDrawingArtifacts) {
            LineChunk line;
            if (chunk instanceof LineChunk) {
                LineChunk lineChunk = this.transformLineChunk((LineChunk)chunk, this.graphicsState.getLineWidth(), this.graphicsState.getLineCap());
                this.processLineChunk((BoundingBox)boundingBox, mcid, lineChunk);
                continue;
            }
            if (chunk instanceof CurveChunk) {
                CurveChunk curveChunk = CurveChunk.transformCurve((CurveChunk)((Object)chunk), this.graphicsState.getCTM(), this.graphicsState.getLineWidth());
                this.processBoundingBox((BoundingBox)boundingBox, mcid, curveChunk.getBoundingBox());
                continue;
            }
            if (!(chunk instanceof Rectangle) || (line = ((Rectangle)chunk).getLine(this.graphicsState.getLineWidth())) == null) continue;
            LineChunk line1 = this.transformLineChunk(line, line.getWidth(), 2);
            this.processLineChunk((BoundingBox)boundingBox, mcid, line1);
        }
        if (StaticStorages.getIsIgnoreMCIDs().booleanValue()) {
            this.lineArtContainer.add(mcid, (BoundingBox)boundingBox);
        }
        this.nonDrawingArtifacts = new ArrayList<Object>();
    }

    private void processS() {
        Long mcid = this.getMarkedContent();
        MultiBoundingBox boundingBox = new MultiBoundingBox();
        for (Object chunk : this.nonDrawingArtifacts) {
            if (chunk instanceof LineChunk) {
                LineChunk lineChunk = this.transformLineChunk((LineChunk)chunk, this.graphicsState.getLineWidth(), this.graphicsState.getLineCap());
                this.processLineChunk((BoundingBox)boundingBox, mcid, lineChunk);
                continue;
            }
            if (chunk instanceof CurveChunk) {
                CurveChunk curveChunk = CurveChunk.transformCurve((CurveChunk)((Object)chunk), this.graphicsState.getCTM(), this.graphicsState.getLineWidth());
                this.processBoundingBox((BoundingBox)boundingBox, mcid, curveChunk.getBoundingBox());
                continue;
            }
            if (!(chunk instanceof Rectangle)) continue;
            Rectangle rectangle = (Rectangle)chunk;
            if (rectangle.getHeight() < this.graphicsState.getLineWidth() || rectangle.getWidth() < this.graphicsState.getLineWidth()) {
                LineChunk line = rectangle.getLine(this.graphicsState.getLineWidth());
                if (line == null) continue;
                LineChunk line1 = this.transformLineChunk(line, line.getWidth(), 2);
                this.processLineChunk((BoundingBox)boundingBox, mcid, line1);
                continue;
            }
            List<LineChunk> lines = rectangle.getLines(this.graphicsState.getLineWidth());
            for (LineChunk line : lines) {
                LineChunk line1 = this.transformLineChunk(line, this.graphicsState.getLineWidth(), 2);
                this.processLineChunk((BoundingBox)boundingBox, mcid, line1);
            }
        }
        if (StaticStorages.getIsIgnoreMCIDs().booleanValue()) {
            this.lineArtContainer.add(mcid, (BoundingBox)boundingBox);
        }
        this.nonDrawingArtifacts = new ArrayList<Object>();
    }

    private void processf() {
        Long mcid = this.getMarkedContent();
        MultiBoundingBox boundingBox = new MultiBoundingBox();
        for (int i = 0; i < this.nonDrawingArtifacts.size(); ++i) {
            LineChunk line1;
            LineChunk line;
            Object chunk = this.nonDrawingArtifacts.get(i);
            if (chunk instanceof Rectangle) {
                line = ((Rectangle)chunk).getLine(0.0);
                if (line == null) continue;
                line1 = this.transformLineChunk(line, line.getWidth(), 2);
                this.processLineChunk((BoundingBox)boundingBox, mcid, line1);
                continue;
            }
            if (chunk instanceof LineChunk) {
                line = this.parsingRectangleFromLines(i);
                if (line != null) {
                    this.processLineChunk((BoundingBox)boundingBox, mcid, line);
                    i += 3;
                    continue;
                }
                line1 = this.transformLineChunk((LineChunk)chunk, this.graphicsState.getLineWidth(), this.graphicsState.getLineCap());
                this.processBoundingBox((BoundingBox)boundingBox, mcid, line1.getBoundingBox());
                continue;
            }
            if (!(chunk instanceof CurveChunk)) continue;
            CurveChunk curveChunk = CurveChunk.transformCurve((CurveChunk)((Object)chunk), this.graphicsState.getCTM(), this.graphicsState.getLineWidth());
            this.processBoundingBox((BoundingBox)boundingBox, mcid, curveChunk.getBoundingBox());
        }
        if (StaticStorages.getIsIgnoreMCIDs().booleanValue()) {
            this.lineArtContainer.add(mcid, (BoundingBox)boundingBox);
        }
        this.nonDrawingArtifacts = new ArrayList<Object>();
    }

    private void processLineChunk(BoundingBox boundingBox, Long mcid, LineChunk lineChunk) {
        this.lineArtContainer.add(mcid, lineChunk);
        if (StaticStorages.getIsIgnoreMCIDs().booleanValue()) {
            boundingBox.union(lineChunk.getBoundingBox());
        }
    }

    private void processBoundingBox(BoundingBox boundingBox, Long mcid, BoundingBox newBoundingBox) {
        if (StaticStorages.getIsIgnoreMCIDs().booleanValue()) {
            boundingBox.union(newBoundingBox);
        } else {
            this.lineArtContainer.add(mcid, newBoundingBox);
        }
    }

    private LineChunk parsingRectangleFromLines(int i) {
        LineChunk line1 = (LineChunk)this.nonDrawingArtifacts.get(i);
        if (i < this.nonDrawingArtifacts.size() - 3 && this.nonDrawingArtifacts.get(i + 1) instanceof LineChunk && this.nonDrawingArtifacts.get(i + 2) instanceof LineChunk && this.nonDrawingArtifacts.get(i + 3) instanceof LineChunk) {
            LineChunk line2 = (LineChunk)this.nonDrawingArtifacts.get(i + 1);
            LineChunk line3 = (LineChunk)this.nonDrawingArtifacts.get(i + 2);
            LineChunk line4 = (LineChunk)this.nonDrawingArtifacts.get(i + 3);
            if (Vertex.areCloseVertexes((Vertex)line1.getEnd(), (Vertex)line2.getStart()) && Vertex.areCloseVertexes((Vertex)line2.getEnd(), (Vertex)line3.getStart()) && Vertex.areCloseVertexes((Vertex)line3.getEnd(), (Vertex)line4.getStart()) && Vertex.areCloseVertexes((Vertex)line4.getEnd(), (Vertex)line1.getStart())) {
                if (line1.isHorizontalLine() && line2.isVerticalLine() && line3.isHorizontalLine() && line4.isVerticalLine()) {
                    LineChunk line = new LineChunk(this.pageNumber, line2.getCenterX(), line2.getCenterY(), line4.getCenterX(), line4.getCenterY(), Math.abs(line1.getCenterY() - line3.getCenterY()));
                    return this.transformLineChunk(line, line.getWidth(), 0);
                }
                if (line1.isVerticalLine() && line2.isHorizontalLine() && line3.isVerticalLine() && line4.isHorizontalLine()) {
                    LineChunk line = new LineChunk(this.pageNumber, line1.getCenterX(), line1.getCenterY(), line3.getCenterX(), line3.getCenterY(), Math.abs(line2.getCenterY() - line4.getCenterY()));
                    return this.transformLineChunk(line, line.getWidth(), 0);
                }
            }
        }
        return null;
    }

    private Double getValueOfLastNumber(List<COSBase> arguments) {
        COSBase base;
        if (!arguments.isEmpty() && (base = arguments.get(arguments.size() - 1)).getType().isNumber()) {
            return base.getReal();
        }
        return null;
    }

    private BoundingBox parseImageBoundingBox() {
        double y1;
        double x1;
        double x2 = x1 = this.graphicsState.getCTM().getTranslateX();
        if (this.graphicsState.getCTM().getScaleX() >= 0.0 && this.graphicsState.getCTM().getShearX() >= 0.0) {
            x2 += this.graphicsState.getCTM().getScaleX() + this.graphicsState.getCTM().getShearX();
        } else if (this.graphicsState.getCTM().getScaleX() < 0.0 && this.graphicsState.getCTM().getShearX() < 0.0) {
            x1 += this.graphicsState.getCTM().getScaleX() + this.graphicsState.getCTM().getShearX();
        } else if (this.graphicsState.getCTM().getScaleX() >= 0.0) {
            x1 += this.graphicsState.getCTM().getShearX();
            x2 += this.graphicsState.getCTM().getScaleX();
        } else {
            x1 += this.graphicsState.getCTM().getScaleX();
            x2 += this.graphicsState.getCTM().getShearX();
        }
        double y2 = y1 = this.graphicsState.getCTM().getTranslateY();
        if (this.graphicsState.getCTM().getScaleY() >= 0.0 && this.graphicsState.getCTM().getShearY() >= 0.0) {
            y2 += this.graphicsState.getCTM().getScaleY() + this.graphicsState.getCTM().getShearY();
        } else if (this.graphicsState.getCTM().getScaleY() < 0.0 && this.graphicsState.getCTM().getShearY() < 0.0) {
            y1 += this.graphicsState.getCTM().getScaleY() + this.graphicsState.getCTM().getShearY();
        } else if (this.graphicsState.getCTM().getScaleY() >= 0.0) {
            y1 += this.graphicsState.getCTM().getShearY();
            y2 += this.graphicsState.getCTM().getScaleY();
        } else {
            y1 += this.graphicsState.getCTM().getScaleY();
            y2 += this.graphicsState.getCTM().getShearY();
        }
        return new BoundingBox(this.pageNumber, x1, y1, x2, y2);
    }

    private void putChunk(Long mcid, IChunk chunk) {
        if (chunk == null) {
            return;
        }
        if (mcid != null) {
            StaticStorages.getChunks().add(this.objectKey, mcid, chunk);
        } else if (this.parentMarkedContent != null) {
            StaticStorages.getChunks().add(this.parentObjectKey, this.parentMarkedContent, chunk);
        } else {
            this.artifacts.add(chunk);
        }
    }

    private List<Double> parseTextShowArgument(COSBase argument, StringBuilder unicodeValue, Matrix textRenderingMatrix) {
        if (argument.getType() == COSObjType.COS_STRING) {
            ArrayList<Double> symbolEnds = new ArrayList<Double>();
            symbolEnds.add(0.0);
            textRenderingMatrix.concatenate(this.calculateTextRenderingMatrix());
            this.parseString((COSString)argument.getDirectBase(), unicodeValue, null, symbolEnds);
            if (!symbolEnds.isEmpty()) {
                this.textMatrix.concatenate(Matrix.getTranslateInstance((Double)symbolEnds.get(symbolEnds.size() - 1), 0.0));
            }
            return symbolEnds;
        }
        if (argument.getType() == COSObjType.COS_ARRAY) {
            COSArray array = (COSArray)argument;
            TextPieces textPieces = new TextPieces();
            for (COSObject obj : array) {
                if (obj == null) continue;
                if (obj.getType() == COSObjType.COS_STRING) {
                    this.parseString((COSString)obj.getDirectBase(), unicodeValue, textPieces, null);
                    continue;
                }
                if (!obj.getType().isNumber()) continue;
                double shift = -obj.getReal().doubleValue() / 1000.0 * this.graphicsState.getTextState().getTextFontSize() * this.graphicsState.getTextState().getHorizontalScaling();
                if (-obj.getReal().doubleValue() >= 170.0 && StaticStorages.getIsAddSpacesBetweenTextPieces().booleanValue()) {
                    textPieces.add(new TextPieces.TextPiece(" ", textPieces.getCurrentX(), textPieces.getCurrentX() + shift));
                    continue;
                }
                textPieces.shiftCurrentX(shift);
            }
            unicodeValue.append(textPieces.getValue());
            if (!textPieces.isEmpty()) {
                this.textMatrix.concatenate(Matrix.getTranslateInstance(textPieces.getStartX(), 0.0));
            }
            textRenderingMatrix.concatenate(this.calculateTextRenderingMatrix());
            if (!textPieces.isEmpty()) {
                this.textMatrix.concatenate(Matrix.getTranslateInstance(textPieces.getEndX() - textPieces.getStartX(), 0.0));
            } else {
                this.textMatrix.concatenate(Matrix.getTranslateInstance(textPieces.getCurrentX(), 0.0));
            }
            return textPieces.getSymbolEnds();
        }
        return Collections.emptyList();
    }

    private void parseString(COSString string, StringBuilder unicodeValue, TextPieces textPieces, List<Double> symbolEnds) {
        byte[] bytes = string.get();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            while (((InputStream)inputStream).available() > 0) {
                String result;
                int code = this.graphicsState.getTextState().getTextFont().readCode((InputStream)inputStream);
                Double width = this.graphicsState.getTextState().getTextFont().getWidth(code);
                if (width == null) {
                    LOGGER.log(Level.SEVERE, "Missing width of glyph with code " + code + " in font" + this.graphicsState.getTextState().getTextFont().getName());
                    width = 0.0;
                }
                double shift = (width * this.graphicsState.getTextState().getTextFontSize() / 1000.0 + this.graphicsState.getTextState().getCharacterSpacing() + (code == 32 ? this.graphicsState.getTextState().getWordSpacing() : 0.0)) * this.graphicsState.getTextState().getHorizontalScaling();
                String value = this.graphicsState.getTextState().getTextFont().toUnicode(code);
                if (symbolEnds != null) {
                    if (symbolEnds.isEmpty()) {
                        TextChunksHelper.updateSymbolEnds(symbolEnds, shift, 0.0, value != null ? value.length() : 0);
                    } else {
                        TextChunksHelper.updateSymbolEnds(symbolEnds, shift, symbolEnds.get(symbolEnds.size() - 1), value != null ? value.length() : 0);
                    }
                }
                String string2 = value != null ? value : (result = StaticContainers.getIsIgnoreCharactersWithoutUnicode() != false ? "" : "\u0000");
                if (textPieces == null) {
                    unicodeValue.append(result);
                    continue;
                }
                textPieces.add(new TextPieces.TextPiece(result, textPieces.getCurrentX(), textPieces.getCurrentX() + shift));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error processing text show operator's string argument : " + new String(bytes), e);
        }
    }

    private TextChunk createTextChunk(List<COSBase> arguments, String operatorType) {
        PDFont font = this.graphicsState.getTextState().getTextFont();
        COSBase argument = TextChunksHelper.getArgument(arguments, operatorType);
        if (font != null && argument != null && (argument.getType() == COSObjType.COS_STRING || argument.getType() == COSObjType.COS_ARRAY) && this.textMatrix != null) {
            StringBuilder unicodeValue = new StringBuilder();
            Matrix textRenderingMatrixBefore = new Matrix();
            List<Double> symbolEnds = this.parseTextShowArgument(argument, unicodeValue, textRenderingMatrixBefore);
            Matrix textRenderingMatrixAfter = this.calculateTextRenderingMatrix();
            TextChunk textChunk = new TextChunk(TextChunksHelper.calculateTextBoundingBox(textRenderingMatrixBefore, textRenderingMatrixAfter, font, this.pageNumber), unicodeValue.toString(), font.getNameWithoutSubset(), TextChunksHelper.calculateTextSize(textRenderingMatrixAfter), TextChunksHelper.calculateFontWeight(this.graphicsState.getTextState().getRenderingMode(), font), font.getFontDescriptor().getItalicAngle().doubleValue(), TextChunksHelper.calculateTextBaseLine(textRenderingMatrixAfter), this.graphicsState.getFillColor(), textRenderingMatrixAfter.getRotationDegree());
            textChunk.adjustSymbolEndsToBoundingBox(symbolEnds);
            return textChunk;
        }
        return null;
    }

    private Matrix calculateTextRenderingMatrix() {
        Matrix parameters = new Matrix(this.graphicsState.getTextState().getTextFontSize() * this.graphicsState.getTextState().getHorizontalScaling(), 0.0, 0.0, this.graphicsState.getTextState().getTextFontSize(), 0.0, this.graphicsState.getTextState().getTextRise());
        return parameters.multiply(this.textMatrix).multiply(this.graphicsState.getCTM());
    }

    private Long getMarkedContent() {
        if (!this.markedContentStack.empty()) {
            for (Long mcid : this.markedContentStack) {
                if (mcid == null) continue;
                return mcid;
            }
        }
        return null;
    }

    private static Long getMCID(List<COSBase> arguments, ResourceHandler resources) {
        if (StaticStorages.getIsIgnoreMCIDs().booleanValue()) {
            return null;
        }
        if (!arguments.isEmpty()) {
            COSBase cosProperties;
            PDResource properties;
            COSBase lastArg = arguments.get(arguments.size() - 1);
            if (lastArg.getType() == COSObjType.COS_DICT) {
                return lastArg.getIntegerKey(ASAtom.MCID);
            }
            if (lastArg.getType() == COSObjType.COS_NAME && resources != null && (properties = resources.getProperties(lastArg.getName())) != null && (cosProperties = properties.getObject().getDirectBase()) != null && cosProperties.getType() == COSObjType.COS_DICT) {
                return cosProperties.getIntegerKey(ASAtom.MCID);
            }
        }
        return null;
    }

    private LineChunk transformLineChunk(LineChunk lineChunk, double lineWidth, int lineCap) {
        return LineChunk.createLineChunk((Integer)this.pageNumber, (double)this.graphicsState.getCTM().transformX(lineChunk.getStartX(), lineChunk.getStartY()), (double)this.graphicsState.getCTM().transformY(lineChunk.getStartX(), lineChunk.getStartY()), (double)this.graphicsState.getCTM().transformX(lineChunk.getEndX(), lineChunk.getEndY()), (double)this.graphicsState.getCTM().transformY(lineChunk.getEndX(), lineChunk.getEndY()), (double)(lineWidth * this.graphicsState.getCTM().getScaleValue()), (int)lineCap);
    }

    private static void processColorSpace(GraphicsState graphicState, ResourceHandler resourcesHandler, PDColorSpace defaultCS, ASAtom name, boolean stroke) {
        PDColorSpace colorSpace = resourcesHandler.getColorSpace(name);
        if (colorSpace == null) {
            colorSpace = defaultCS;
        }
        if (!stroke) {
            graphicState.setFillColorSpace(colorSpace);
        }
    }

    private boolean isProcessColorSpace(PDColorSpace colorSpace) {
        if (colorSpace == null) {
            return false;
        }
        ASAtom colorSpaceType = colorSpace.getType();
        return ASAtom.DEVICERGB.equals((Object)colorSpaceType) || ASAtom.DEVICEGRAY.equals((Object)colorSpaceType) || ASAtom.DEVICECMYK.equals((Object)colorSpaceType) || ASAtom.ICCBASED.equals((Object)colorSpaceType) || ASAtom.CALRGB.equals((Object)colorSpaceType) || ASAtom.CALGRAY.equals((Object)colorSpaceType) || ASAtom.DEVICEN.equals((Object)colorSpaceType) || ASAtom.SEPARATION.equals((Object)colorSpaceType) || ASAtom.INDEXED.equals((Object)colorSpaceType) || ASAtom.LAB.equals((Object)colorSpaceType);
    }

    public void parseLineArts() {
        this.lineArtContainer.unionBoundingBoxes();
        for (Map.Entry<Long, List<BoundingBox>> boundingBoxes : this.lineArtContainer.entrySet()) {
            Long mcid = boundingBoxes.getKey();
            List<LineChunk> lineChunks = this.lineArtContainer.getLineChunks(mcid);
            if (lineChunks == null) {
                lineChunks = new LinkedList<LineChunk>();
            }
            if (mcid == null && this.parentMarkedContent == null) {
                for (BoundingBox box : boundingBoxes.getValue()) {
                    this.artifacts.add((IChunk)new LineArtChunk(box));
                }
                this.artifacts.addAll(lineChunks);
            }
            MultiBoundingBox boundingBox = new MultiBoundingBox();
            for (BoundingBox box : boundingBoxes.getValue()) {
                boundingBox.union(box);
            }
            if (mcid != null) {
                this.lineArtContainer.getLineArt(mcid).setBoundingBox((BoundingBox)boundingBox);
                this.lineArtContainer.getLineArt(mcid).setLineChunks(lineChunks);
                continue;
            }
            StaticStorages.getChunks().add(this.parentObjectKey, this.parentMarkedContent, (IChunk)new LineArtChunk((BoundingBox)boundingBox, lineChunks));
        }
    }

    public void processLineArts() {
        List<BoundingBox> boundingBoxes;
        if (!StaticStorages.getIsIgnoreMCIDs().booleanValue()) {
            return;
        }
        List<LineChunk> lineChunks = this.lineArtContainer.getLineChunks(null);
        if (lineChunks != null && !lineChunks.isEmpty()) {
            this.artifacts.addAll(lineChunks);
            lineChunks.clear();
        }
        if ((boundingBoxes = this.lineArtContainer.getBoundingBoxes(null)) != null && !boundingBoxes.isEmpty()) {
            for (BoundingBox box : boundingBoxes) {
                this.artifacts.add((IChunk)new LineArtChunk(box));
            }
            boundingBoxes.clear();
        }
    }
}

