/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.sa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.containers.StaticStorages;
import org.verapdf.gf.model.impl.sa.GFSAImageChunk;
import org.verapdf.gf.model.impl.sa.GFSANode;
import org.verapdf.gf.model.impl.sa.GFSATextChunk;
import org.verapdf.gf.model.impl.sa.structelems.GFSAGeneral;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.salayer.SAStructElem;
import org.verapdf.pd.structure.PDMCRDictionary;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pd.structure.StructureType;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticImageNode;
import org.verapdf.wcag.algorithms.entities.SemanticSpan;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.maps.SemanticTypeMapper;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;

public class GFSAStructElem
extends GenericModelObject
implements SAStructElem {
    public static final String CHILDREN = "children";
    public static final String START = "START";
    public static final String MIDDLE = "MIDDLE";
    public static final String END = "END";
    private final PDStructElem structElemDictionary;
    protected List<org.verapdf.model.baselayer.Object> children = null;
    private INode node;
    private final String id;
    private final String standardType;
    private final StringBuilder textValue = new StringBuilder();
    private final boolean isTableChild;
    private final boolean isListChild;
    private boolean isLeafNode = true;
    private final String parentsStandardTypes;
    private int maxSpaceStartIndex;
    private int maxSpaceEndIndex;

    public GFSAStructElem(PDStructElem structElemDictionary, String standardType, String type, String parentsStandardTypes) {
        super(type);
        this.structElemDictionary = structElemDictionary;
        this.standardType = standardType;
        COSKey key = structElemDictionary.getObject().getObjectKey();
        this.id = (key != null ? key.getNumber() + " " + key.getGeneration() : "0 0") + " obj" + (standardType != null ? " " + standardType : "") + (this.getStructureType() != null ? " " + ((COSName)COSName.fromValue((String)this.getStructureType())).getUnicodeValue() : "");
        this.isTableChild = Arrays.asList(parentsStandardTypes.split("&")).contains("Table");
        this.isListChild = Arrays.asList(parentsStandardTypes.split("&")).contains("L");
        this.parentsStandardTypes = parentsStandardTypes;
    }

    public void setNode(INode node) {
        this.node = node;
    }

    public INode getNode() {
        return this.node;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "children": {
                return this.getChildren();
            }
        }
        return super.getLinkedObjects(link);
    }

    public String getType() {
        ASAtom type = this.structElemDictionary.getType();
        return type == null ? null : type.getValue();
    }

    public String getStructureType() {
        ASAtom subtype = this.structElemDictionary.getNameKey(ASAtom.S);
        return subtype == null ? null : subtype.getValue();
    }

    public String getstandardType() {
        return this.standardType;
    }

    public Boolean getisTableElem() {
        return "TBody".equals(this.standardType) || "THead".equals(this.standardType) || "TFoot".equals(this.standardType) || "TH".equals(this.standardType) || "TD".equals(this.standardType) || "TR".equals(this.standardType);
    }

    public Boolean getisListElem() {
        return "L".equals(this.standardType) || "LI".equals(this.standardType) || "LBody".equals(this.standardType) || "Lbl".equals(this.standardType);
    }

    public Boolean getisTableChild() {
        return this.isTableChild;
    }

    public Boolean getisListChild() {
        return this.isListChild;
    }

    public Boolean getisLeafElem() {
        if (this.children == null) {
            this.parseChildren();
        }
        return this.isLeafNode;
    }

    public Long getstructureID() {
        return this.node.getRecognizedStructureId();
    }

    public static String getStructureElementStandardType(PDStructElem pdStructElem) {
        StructureType type = pdStructElem.getStructureType();
        if (type != null) {
            return StaticStorages.getRoleMapHelper().getStandardType(type.getType(), false, true);
        }
        return null;
    }

    private List<org.verapdf.model.baselayer.Object> getChildren() {
        if (this.children == null) {
            this.parseChildren();
        }
        return Collections.unmodifiableList(this.children);
    }

    protected void parseChildren() {
        List elements = this.structElemDictionary.getChildren();
        this.children = new ArrayList<org.verapdf.model.baselayer.Object>(elements.size());
        if (!elements.isEmpty()) {
            for (Object element : elements) {
                if (element instanceof PDStructElem) {
                    GFSAGeneral structElem = GFSAGeneral.createTypedStructElem((PDStructElem)element, (this.parentsStandardTypes.isEmpty() ? "" : this.parentsStandardTypes + "&") + this.standardType);
                    GFSANode childNode = new GFSANode(structElem);
                    structElem.setNode((INode)childNode);
                    this.node.addChild((INode)childNode);
                    this.children.add((org.verapdf.model.baselayer.Object)structElem);
                    this.isLeafNode = false;
                    continue;
                }
                if (element instanceof PDMCRDictionary) {
                    PDMCRDictionary mcr = (PDMCRDictionary)element;
                    COSKey streamKey = mcr.getStreamObjectKey();
                    if (streamKey != null) {
                        this.addChunksToChildren(streamKey, mcr.getMCID());
                        continue;
                    }
                    this.addChunksToChildren(mcr.getPageObjectKey(), mcr.getMCID());
                    continue;
                }
                if (!(element instanceof COSObject) || ((COSObject)element).getType() != COSObjType.COS_INTEGER) continue;
                this.addChunksToChildren(this.getPageObjectNumber(), ((COSObject)element).getDirectBase().getInteger());
            }
        }
    }

    private void addChunksToChildren(COSKey pageObjectNumber, Long mcid) {
        List<IChunk> chunks = StaticStorages.getChunks().get(pageObjectNumber, mcid);
        if (chunks != null) {
            for (IChunk chunk : chunks) {
                if (chunk instanceof TextChunk) {
                    TextChunk textChunk = (TextChunk)chunk;
                    this.node.addChild((INode)new SemanticSpan(textChunk));
                    this.children.add((org.verapdf.model.baselayer.Object)new GFSATextChunk(textChunk, (this.parentsStandardTypes.isEmpty() ? "" : this.parentsStandardTypes + "&") + this.standardType));
                    this.textValue.append(textChunk.getValue());
                    continue;
                }
                if (!(chunk instanceof ImageChunk)) continue;
                this.node.addChild((INode)new SemanticImageNode((ImageChunk)chunk));
                this.children.add((org.verapdf.model.baselayer.Object)new GFSAImageChunk((ImageChunk)chunk));
            }
        }
    }

    public String getContext() {
        return this.node.getBoundingBox().getLocation();
    }

    public Double getcorrectSemanticScore() {
        return this.node.getCorrectSemanticScore();
    }

    public Boolean gethasCorrectType() {
        if (this.standardType == null) {
            return false;
        }
        SemanticType semanticType = this.node.getSemanticType();
        if (!SemanticTypeMapper.containsType((String)this.standardType) || semanticType == null) {
            return null;
        }
        return this.standardType.equals(semanticType.getValue());
    }

    public String getcorrectType() {
        SemanticType semanticType = this.node.getSemanticType();
        if (semanticType == null) {
            return null;
        }
        return semanticType.getValue();
    }

    public String getID() {
        return this.id;
    }

    public COSKey getPageObjectNumber() {
        return this.structElemDictionary.getPageObjectNumber();
    }

    public Long getnumberOfSameCharacters() {
        return GFSAStructElem.getNumberOfSameCharacters(this.getTextValue());
    }

    public String getparentsStandardTypes() {
        return this.parentsStandardTypes;
    }

    public String getTextValue() {
        if (this.children == null) {
            this.parseChildren();
        }
        return this.textValue.toString();
    }

    private static long getNumberOfSameCharacters(String value) {
        if (value == null || value.isEmpty()) {
            return 0L;
        }
        char[] characters = value.toCharArray();
        char lastCharacter = characters[0];
        int maxLength = 0;
        int length = 0;
        for (char character : characters) {
            if (lastCharacter == character) {
                ++length;
                continue;
            }
            if (length > maxLength && !TextChunkUtils.isWhiteSpaceChar((char)lastCharacter)) {
                maxLength = length;
            }
            length = 1;
            lastCharacter = character;
        }
        if (length > maxLength && !TextChunkUtils.isWhiteSpaceChar((char)lastCharacter)) {
            maxLength = length;
        }
        return maxLength;
    }

    public Long getnumberOfRepeatedSpaces() {
        return this.getNumberOfRepeatedSpaces(this.getTextValue());
    }

    private long getNumberOfRepeatedSpaces(String value) {
        int[] indexes = GFSAStructElem.getIndexesOfLongestSequenceOfSpaces(value);
        this.maxSpaceStartIndex = indexes[0];
        this.maxSpaceEndIndex = indexes[1];
        if (this.maxSpaceStartIndex == -1) {
            return 0L;
        }
        return (long)this.maxSpaceEndIndex - (long)this.maxSpaceStartIndex;
    }

    public String getpositionOfRepeatedSpaces() {
        return this.getPositionOfRepeatedSpaces(this.getTextValue());
    }

    private String getPositionOfRepeatedSpaces(String value) {
        if (this.maxSpaceStartIndex == 0) {
            return START;
        }
        if (this.maxSpaceEndIndex == value.length()) {
            return END;
        }
        return MIDDLE;
    }

    private static int[] getIndexesOfLongestSequenceOfSpaces(String value) {
        if (value == null || value.isEmpty() || value.indexOf(32) == -1) {
            return new int[]{-1, -1};
        }
        int firstMaxIndex = -1;
        int secondMaxIndex = -1;
        Pattern pattern = Pattern.compile("[\\s+\\u00A0\\u2007\\u202F\\u001C\\u001D\\u001E\\u001F]+");
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            if (matcher.end() - matcher.start() <= secondMaxIndex - firstMaxIndex) continue;
            firstMaxIndex = matcher.start();
            secondMaxIndex = matcher.end();
        }
        return new int[]{firstMaxIndex, secondMaxIndex};
    }
}

