/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.chunks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.cos.COSKey;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

public class ChunkContainer {
    private final Map<COSKey, Map<Long, List<IChunk>>> chunks = new HashMap<COSKey, Map<Long, List<IChunk>>>();

    public boolean containsKey(Long mcid) {
        for (Map<Long, List<IChunk>> map : this.chunks.values()) {
            if (!map.containsKey(mcid)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(COSKey pageObjectNumber, Long mcid) {
        Map<Long, List<IChunk>> map = this.chunks.get(pageObjectNumber);
        return map != null && map.containsKey(mcid);
    }

    public List<IChunk> get(Long mcid) {
        for (Map<Long, List<IChunk>> map : this.chunks.values()) {
            if (!map.containsKey(mcid)) continue;
            return map.get(mcid);
        }
        return null;
    }

    public List<IChunk> get(COSKey pageObjectNumber, Long mcid) {
        if (pageObjectNumber == null) {
            return this.get(mcid);
        }
        Map<Long, List<IChunk>> map = this.chunks.get(pageObjectNumber);
        return map != null ? map.get(mcid) : null;
    }

    public List<IChunk> get(COSKey pageObjectNumber, BoundingBox boundingBox) {
        if (pageObjectNumber == null) {
            return this.get(boundingBox);
        }
        Map<Long, List<IChunk>> map = this.chunks.get(pageObjectNumber);
        if (map != null) {
            return this.processAllChunks(map, boundingBox);
        }
        return Collections.emptyList();
    }

    public List<IChunk> get(BoundingBox boundingBox) {
        ArrayList<IChunk> chunksList = new ArrayList<IChunk>();
        for (Map<Long, List<IChunk>> map : this.chunks.values()) {
            chunksList.addAll(this.processAllChunks(map, boundingBox));
        }
        return chunksList;
    }

    private List<IChunk> processAllChunks(Map<Long, List<IChunk>> map, BoundingBox boundingBox) {
        ArrayList<IChunk> chunksList = new ArrayList<IChunk>();
        for (List<IChunk> list : map.values()) {
            for (IChunk chunk : list) {
                if (chunk instanceof TextChunk) {
                    if (!this.checkTextChunk((TextChunk)chunk, boundingBox)) continue;
                    chunksList.add(chunk);
                    continue;
                }
                if (!boundingBox.contains(chunk.getBoundingBox())) continue;
                chunksList.add(chunk);
            }
        }
        return chunksList;
    }

    private boolean checkTextChunk(TextChunk textChunk, BoundingBox boundingBox) {
        BoundingBox textChunkBoundingBox = textChunk.getBoundingBox();
        int numOfSymbols = textChunk.getValue().length();
        double fontSymbolWidth = textChunkBoundingBox.getWidth() / (double)numOfSymbols;
        double fontSymbolHeight = textChunkBoundingBox.getHeight();
        return boundingBox.contains(textChunk.getBoundingBox(), fontSymbolWidth / 2.0, fontSymbolHeight / 2.0);
    }

    public void add(Long mcid, IChunk chunk) {
        List<IChunk> list = this.get(mcid);
        if (list != null) {
            list.add(chunk);
        } else {
            list = new ArrayList<IChunk>();
            list.add(chunk);
            if (!this.chunks.containsKey(null)) {
                this.chunks.put(null, new HashMap());
            }
            this.chunks.get(null).put(mcid, list);
        }
    }

    public void add(COSKey pageObjectNumber, Long mcid, IChunk chunk) {
        List<IChunk> list = this.get(pageObjectNumber, mcid);
        if (list != null) {
            list.add(chunk);
        } else {
            list = new ArrayList<IChunk>();
            list.add(chunk);
            if (!this.chunks.containsKey(pageObjectNumber)) {
                this.chunks.put(pageObjectNumber, new HashMap());
            }
            this.chunks.get(pageObjectNumber).put(mcid, list);
        }
    }
}

