/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.chunks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.cos.COSKey;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

public class ChunkContainer {
    private final Map<COSKey, Map<Long, List<IChunk>>> chunks = new HashMap<COSKey, Map<Long, List<IChunk>>>();

    public boolean containsKey(Long mcid) {
        for (Map<Long, List<IChunk>> map : this.chunks.values()) {
            if (!map.containsKey(mcid)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(COSKey objectNumber, Long mcid) {
        Map<Long, List<IChunk>> map = this.chunks.get(objectNumber);
        return map != null && map.containsKey(mcid);
    }

    public List<IChunk> get(Long mcid) {
        for (Map<Long, List<IChunk>> map : this.chunks.values()) {
            if (!map.containsKey(mcid)) continue;
            return map.get(mcid);
        }
        return null;
    }

    public List<IChunk> get(COSKey objectNumber, Long mcid) {
        if (objectNumber == null) {
            return this.get(mcid);
        }
        Map<Long, List<IChunk>> map = this.chunks.get(objectNumber);
        return map != null ? map.get(mcid) : null;
    }

    public List<IChunk> get(COSKey objectNumber, BoundingBox boundingBox) {
        if (objectNumber == null) {
            return this.get(boundingBox);
        }
        Map<Long, List<IChunk>> map = this.chunks.get(objectNumber);
        if (map != null) {
            return this.processAllChunks(map, boundingBox);
        }
        return Collections.emptyList();
    }

    public List<IChunk> get(BoundingBox boundingBox) {
        ArrayList<IChunk> chunksList = new ArrayList<IChunk>();
        for (Map<Long, List<IChunk>> map : this.chunks.values()) {
            chunksList.addAll(this.processAllChunks(map, boundingBox));
        }
        return chunksList;
    }

    public List<String> getValues(COSKey objectNumber, BoundingBox boundingBox) {
        if (objectNumber == null) {
            return this.getValues(boundingBox);
        }
        Map<Long, List<IChunk>> map = this.chunks.get(objectNumber);
        if (map != null) {
            return this.processAllChunkValues(map, boundingBox);
        }
        return Collections.emptyList();
    }

    public List<String> getValues(BoundingBox boundingBox) {
        ArrayList<String> valueList = new ArrayList<String>();
        for (Map<Long, List<IChunk>> map : this.chunks.values()) {
            valueList.addAll(this.processAllChunkValues(map, boundingBox));
        }
        return valueList;
    }

    private List<IChunk> processAllChunks(Map<Long, List<IChunk>> map, BoundingBox boundingBox) {
        ArrayList<IChunk> chunksList = new ArrayList<IChunk>();
        for (List<IChunk> list : map.values()) {
            for (IChunk chunk : list) {
                if (chunk instanceof TextChunk) {
                    if (!this.checkTextChunk((TextChunk)chunk, boundingBox)) continue;
                    chunksList.add(chunk);
                    continue;
                }
                if (!boundingBox.contains(chunk.getBoundingBox())) continue;
                chunksList.add(chunk);
            }
        }
        return chunksList;
    }

    private boolean checkTextChunk(TextChunk textChunk, BoundingBox boundingBox) {
        BoundingBox textChunkBoundingBox = textChunk.getBoundingBox();
        int numOfSymbols = textChunk.getValue().length();
        double fontSymbolWidth = textChunkBoundingBox.getWidth() / (double)numOfSymbols;
        double fontSymbolHeight = textChunkBoundingBox.getHeight();
        return boundingBox.contains(textChunk.getBoundingBox(), fontSymbolWidth / 2.0, fontSymbolHeight / 2.0);
    }

    private List<String> processAllChunkValues(Map<Long, List<IChunk>> map, BoundingBox boundingBox) {
        ArrayList<String> valuesList = new ArrayList<String>();
        for (List<IChunk> list : map.values()) {
            for (IChunk chunk : list) {
                String resultValue;
                if (!(chunk instanceof TextChunk) || (resultValue = this.checkTextChunkValue((TextChunk)chunk, boundingBox)) == null) continue;
                valuesList.add(resultValue);
            }
        }
        return valuesList;
    }

    private String checkTextChunkValue(TextChunk textChunk, BoundingBox boundingBox) {
        double heightEps;
        double widthEps;
        BoundingBox textChunkBoundingBox = textChunk.getBoundingBox();
        if (boundingBox.contains(textChunkBoundingBox, widthEps = textChunkBoundingBox.getWidth() / (double)(4 * textChunk.getValue().length()), heightEps = textChunkBoundingBox.getHeight() / 4.0)) {
            return textChunk.getValue();
        }
        BoundingBox crossBox = BoundingBox.cross((BoundingBox)textChunkBoundingBox, (BoundingBox)boundingBox, (double)widthEps, (double)heightEps);
        if (crossBox == null || crossBox.getHeight() < textChunkBoundingBox.getHeight() - heightEps) {
            return null;
        }
        Integer start = this.getResultValueStartIndex(textChunk, crossBox.getLeftX());
        Integer end = this.getResultValueEndIndex(textChunk, crossBox.getRightX());
        if (start == null || end == null) {
            return "";
        }
        return textChunk.getValue().substring(start, end + 1);
    }

    public void add(Long mcid, IChunk chunk) {
        List<IChunk> list = this.get(mcid);
        if (list != null) {
            list.add(chunk);
        } else {
            list = new ArrayList<IChunk>();
            list.add(chunk);
            if (!this.chunks.containsKey(null)) {
                this.chunks.put(null, new HashMap());
            }
            this.chunks.get(null).put(mcid, list);
        }
    }

    public void add(COSKey objectNumber, Long mcid, IChunk chunk) {
        List<IChunk> list = this.get(objectNumber, mcid);
        if (list != null) {
            list.add(chunk);
        } else {
            list = new ArrayList<IChunk>();
            list.add(chunk);
            if (!this.chunks.containsKey(objectNumber)) {
                this.chunks.put(objectNumber, new HashMap());
            }
            this.chunks.get(objectNumber).put(mcid, list);
        }
    }

    private Integer getResultValueStartIndex(TextChunk textChunk, double leftX) {
        for (int i = 0; i < textChunk.getValue().length(); ++i) {
            if (!(textChunk.getSymbolStartCoordinate(i) >= leftX)) continue;
            return i;
        }
        return null;
    }

    private Integer getResultValueEndIndex(TextChunk textChunk, double rightX) {
        for (int i = textChunk.getValue().length() - 1; i >= 0; --i) {
            if (!(textChunk.getSymbolEndCoordinate(i) <= rightX)) continue;
            return i;
        }
        return null;
    }
}

