/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Objects;
import org.verapdf.gf.model.impl.sa.GFSAAnnotationNode;
import org.verapdf.gf.model.impl.sa.GFSAImageChunk;
import org.verapdf.gf.model.impl.sa.GFSALineArtChunk;
import org.verapdf.gf.model.impl.sa.GFSAStructElem;
import org.verapdf.gf.model.impl.sa.GFSATextChunk;
import org.verapdf.model.baselayer.Object;
import org.verapdf.wcag.algorithms.entities.IAttributesDictionary;

public class NodeSerializer
extends StdSerializer<GFSAStructElem> {
    protected NodeSerializer(Class<GFSAStructElem> t) {
        super(t);
    }

    public void serialize(GFSAStructElem elem, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        String type = elem.getstandardType();
        if (type == null) {
            type = "NonStandard";
        }
        jsonGenerator.writeStringField("type", type);
        jsonGenerator.writeNumberField("objectKeyNumber", elem.getStructElemDictionary().getObject().getKey().getNumber());
        if (Objects.equals(elem.getstandardType(), "TD") || Objects.equals(elem.getstandardType(), "TH")) {
            IAttributesDictionary AttributesDictionary = elem.getNode().getAttributesDictionary();
            jsonGenerator.writeFieldName("attributes");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("colSpan", AttributesDictionary.getColSpan());
            jsonGenerator.writeNumberField("rowSpan", AttributesDictionary.getRowSpan());
            jsonGenerator.writeEndObject();
        }
        if (!elem.getChildren().isEmpty()) {
            jsonGenerator.writeFieldName("children");
            jsonGenerator.writeStartArray();
            for (Object child : elem.getChildren()) {
                if (child instanceof GFSATextChunk) {
                    jsonGenerator.writeObject((java.lang.Object)((GFSATextChunk)child).getTextChunk());
                    continue;
                }
                if (child instanceof GFSAImageChunk) {
                    jsonGenerator.writeObject((java.lang.Object)((GFSAImageChunk)child).imageChunk);
                    continue;
                }
                if (child instanceof GFSALineArtChunk) {
                    jsonGenerator.writeObject((java.lang.Object)((GFSALineArtChunk)child).lineArtChunk);
                    continue;
                }
                jsonGenerator.writeObject((java.lang.Object)child);
            }
            for (Object child : elem.getNode().getChildren()) {
                if (!(child instanceof GFSAAnnotationNode)) continue;
                jsonGenerator.writeObject((java.lang.Object)child);
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
    }
}

