/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.sa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.gf.model.factory.chunks.GraphicsState;
import org.verapdf.gf.model.factory.chunks.Matrix;
import org.verapdf.gf.model.impl.sa.GFSAAnnotation;
import org.verapdf.gf.model.impl.sa.GFSAContentStream;
import org.verapdf.gf.model.impl.sa.GFSAImageChunk;
import org.verapdf.gf.model.impl.sa.GFSALineArtChunk;
import org.verapdf.gf.model.impl.sa.GFSATextChunk;
import org.verapdf.gf.model.impl.sa.tables.GFSATableBorder;
import org.verapdf.gf.model.impl.sa.util.ResourceHandler;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.salayer.SAAnnotation;
import org.verapdf.model.salayer.SAChunk;
import org.verapdf.model.salayer.SAPage;
import org.verapdf.model.salayer.SATableBorder;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDPage;
import org.verapdf.wcag.algorithms.entities.IPage;
import org.verapdf.wcag.algorithms.entities.content.IChunk;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;

public class GFSAPage
extends GenericModelObject
implements SAPage,
IPage {
    public static final String PAGE_TYPE = "SAPage";
    private static final String ARTIFACTS = "artifacts";
    private static final String TABLE_BORDERS = "tableBorders";
    private static final String ANNOTS = "annots";
    private GFSAContentStream contentStream = null;
    private List<SAChunk> artifacts = null;
    private final PDPage pdPage;
    private final String pageLabel;
    private List<SAAnnotation> annotations = null;

    public GFSAPage(PDPage pdPage, String pageLabel) {
        super(PAGE_TYPE);
        this.pdPage = pdPage;
        this.pageLabel = pageLabel;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "artifacts": {
                return this.getartifacts();
            }
            case "annots": {
                return this.getAnnotations();
            }
            case "tableBorders": {
                return this.getTableBorders();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<SAAnnotation> parseAnnotations() {
        List annots = this.pdPage.getAnnotations();
        if (annots.size() > 0) {
            ArrayList<GFSAAnnotation> res = new ArrayList<GFSAAnnotation>(annots.size());
            for (PDAnnotation annot : annots) {
                res.add(GFSAAnnotation.createAnnot(annot, this.pdPage));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<SAAnnotation> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.parseAnnotations();
        }
        return Collections.unmodifiableList(this.annotations);
    }

    private List<SATableBorder> getTableBorders() {
        if (StaticContainers.getTableBordersCollection() == null) {
            return Collections.emptyList();
        }
        ArrayList<SATableBorder> tableBorders = new ArrayList<SATableBorder>();
        for (TableBorder tableBorder : StaticContainers.getTableBordersCollection().getTableBorders(Integer.valueOf(this.pdPage.getPageNumber()))) {
            tableBorders.add(new GFSATableBorder(tableBorder));
        }
        return tableBorders;
    }

    private List<SAChunk> getartifacts() {
        if (this.artifacts == null) {
            List<IChunk> artifacts = this.getArtifacts();
            this.artifacts = new ArrayList<SAChunk>(artifacts.size());
            for (IChunk chunk : artifacts) {
                if (chunk instanceof TextChunk) {
                    this.artifacts.add(new GFSATextChunk((TextChunk)chunk, ""));
                    continue;
                }
                if (chunk instanceof ImageChunk) {
                    this.artifacts.add(new GFSAImageChunk((ImageChunk)chunk));
                    continue;
                }
                if (!(chunk instanceof LineArtChunk)) continue;
                this.artifacts.add(new GFSALineArtChunk((LineArtChunk)chunk));
            }
        }
        return this.artifacts;
    }

    public List<IChunk> getArtifacts() {
        if (this.contentStream == null) {
            this.parseContentStream();
        }
        if (this.contentStream != null) {
            return this.contentStream.getArtifacts();
        }
        return Collections.emptyList();
    }

    public GFSAContentStream getContentStream() {
        if (this.contentStream == null) {
            this.parseContentStream();
        }
        return this.contentStream;
    }

    private void parseContentStream() {
        GFSAContentStream pdContentStream = null;
        if (this.pdPage.getContent() != null) {
            ResourceHandler resourceHandler = ResourceHandler.getInstance(this.pdPage.getResources());
            GraphicsState graphicsState = new GraphicsState(resourceHandler);
            graphicsState.setCTM(GFSAPage.createCurrentTransformationMatrix(this.pdPage));
            pdContentStream = new GFSAContentStream(this.pdPage.getContent(), graphicsState, resourceHandler, this.pdPage.getPageNumber(), this.pdPage.getObject().getKey(), null, null);
        }
        this.contentStream = pdContentStream;
    }

    public static Matrix createCurrentTransformationMatrix(PDPage pdPage) {
        double[] cropBox = pdPage.getCropBox();
        if (cropBox == null) {
            cropBox = new double[]{0.0, 0.0, 0.0, 0.0};
        }
        Matrix currentTransformationMatrix = new Matrix();
        long rotation = pdPage.getRotation() % 360L;
        if (rotation == 90L) {
            currentTransformationMatrix.translate(0.0, cropBox[2] - cropBox[0]);
            currentTransformationMatrix.rotate(4.71238898038469);
        }
        if (rotation == 180L) {
            currentTransformationMatrix.translate(cropBox[2] - cropBox[0], cropBox[3] - cropBox[1]);
            currentTransformationMatrix.rotate(Math.PI);
        }
        if (rotation == 270L) {
            currentTransformationMatrix.translate(cropBox[3], -cropBox[0]);
            currentTransformationMatrix.rotate(1.5707963267948966);
        } else {
            currentTransformationMatrix.translate(-cropBox[0], -cropBox[1]);
        }
        return currentTransformationMatrix;
    }

    public int getPageNumber() {
        return this.pdPage.getPageNumber();
    }

    public String getPageLabel() {
        return this.pageLabel;
    }
}

