/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class Checksummer
implements Checksum {
    protected long _nByte;
    private CRC32 _crc32;
    private MessageDigest _md5;
    private MessageDigest _sha1;
    private MessageDigest _sha256;

    public Checksummer() {
        this.reset();
    }

    @Override
    public void reset() {
        this._nByte = 0L;
        this._crc32 = new CRC32();
        try {
            this._md5 = MessageDigest.getInstance("MD5");
            this._sha1 = MessageDigest.getInstance("SHA-1");
            this._sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Missing checksum algorithm.", e);
        }
    }

    @Override
    public long getValue() {
        return this._crc32.getValue();
    }

    public void update(byte b) {
        this._crc32.update(b);
        if (this._md5 != null) {
            this._md5.update(b);
        }
        if (this._sha1 != null) {
            this._sha1.update(b);
        }
        if (this._sha256 != null) {
            this._sha256.update(b);
        }
    }

    @Override
    public void update(int b) {
        byte sb = b > 127 ? (byte)(b - 256) : (byte)b;
        this.update(sb);
    }

    @Override
    public void update(byte[] b) {
        this._crc32.update(b);
        if (this._md5 != null) {
            this._md5.update(b);
        }
        if (this._sha1 != null) {
            this._sha1.update(b);
        }
        if (this._sha256 != null) {
            this._sha256.update(b);
        }
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this._crc32.update(b, off, len);
        if (this._md5 != null) {
            this._md5.update(b, off, len);
        }
        if (this._sha1 != null) {
            this._sha1.update(b, off, len);
        }
        if (this._sha256 != null) {
            this._sha256.update(b, off, len);
        }
    }

    public String getCRC32() {
        return Checksummer.padLeadingZeroes(Long.toHexString(this._crc32.getValue()), 8);
    }

    public String getMD5() {
        if (this._md5 == null) {
            return null;
        }
        return this.convertToHex(this._md5.digest());
    }

    public String getSHA1() {
        if (this._sha1 == null) {
            return null;
        }
        return this.convertToHex(this._sha1.digest());
    }

    public String getSHA256() {
        if (this._sha256 == null) {
            return null;
        }
        return this.convertToHex(this._sha256.digest());
    }

    private String convertToHex(byte[] digest) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            int un = digest[i] >= 0 ? digest[i] : 256 + digest[i];
            buffer.append(Checksummer.padLeadingZeroes(Integer.toHexString(un), 2));
        }
        return buffer.toString();
    }

    private static String padLeadingZeroes(String str, int len) {
        StringBuffer buff = new StringBuffer();
        for (int padLen = len - str.length(); padLen > 0; --padLen) {
            buff.append("0");
        }
        buff.append(str);
        return buff.toString();
    }
}

