/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

public final class BytestreamModule
extends ModuleBase {
    private static final String NAME = "BYTESTREAM";
    private static final String RELEASE = "1.4";
    private static final int[] DATE = new int[]{2018, 10, 1};
    private static final String[] FORMAT = new String[]{"bytestream"};
    private static final String COVERAGE = null;
    private static final String[] MIMETYPE = new String[]{"application/octet-stream"};
    private static final String WELLFORMED = "All bytestreams are well-formed";
    private static final String VALIDITY = null;
    private static final String REPINFO = null;
    private static final String NOTE = "This is the default format";
    private static final String RIGHTS = "Copyright 2003-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";

    public BytestreamModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        this._vendor = Agent.harvardInstance();
    }

    @Override
    public final int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        this.initParse();
        this.initInfo(info);
        this.setupDataStream(stream, info);
        boolean eof = false;
        this._nByte = 0L;
        byte[] byteBuf = new byte[4096];
        while (!eof) {
            try {
                int n = BytestreamModule.readByteBuf(this._dstream, byteBuf, this);
                if (n > 0) continue;
                break;
            }
            catch (EOFException e) {
                this._logger.log(Level.FINEST, "End of file exception when parsing.", e);
                eof = true;
            }
        }
        info.setSize(this._nByte);
        if (this._nByte == 0L) {
            info.setMessage(new InfoMessage("Zero-length file"));
        }
        BytestreamModule.setChecksums(this._ckSummer, info);
        return 0;
    }

    @Override
    public void checkSignatures(File file, InputStream stream, RepInfo info) {
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule(this);
        info.setSigMatch(this._name);
    }
}

