/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.viewer.MainScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProgressWindow
extends JFrame {
    private long _contentLength;
    private long _byteCount;
    private String _docName;
    private JLabel _progressLabel;
    private JLabel _docNameLabel;
    private int _progressState;
    public static final int UNKNOWN = 0;
    public static final int DOWNLOADING = 1;
    public static final int PROCESSING = 2;

    public ProgressWindow(ActionListener canceler) {
        Font fileFont = new Font("Dialog", 0, 14);
        Font progFont = new Font("Dialog", 0, 12);
        Dimension labelDim = new Dimension(460, 24);
        this._docNameLabel = new JLabel();
        this._docNameLabel.setHorizontalAlignment(0);
        this._docNameLabel.setFont(fileFont);
        this._docNameLabel.setMinimumSize(labelDim);
        this._docNameLabel.setPreferredSize(labelDim);
        this.getContentPane().add((Component)this._docNameLabel, "North");
        this._progressLabel = new JLabel();
        this._progressLabel.setHorizontalAlignment(0);
        this._progressLabel.setFont(progFont);
        this._progressLabel.setMinimumSize(labelDim);
        this._progressLabel.setPreferredSize(labelDim);
        this.getContentPane().add((Component)this._progressLabel, "Center");
        JPanel botPanel = new JPanel();
        this.getContentPane().add((Component)botPanel, "South");
        JButton cancelButton = new JButton("Cancel");
        botPanel.add(cancelButton);
        cancelButton.addActionListener(canceler);
        this.setTitle("Progress");
        this.setDefaultCloseOperation(0);
        this.pack();
        MainScreen.centerTopWindow(this);
        this._contentLength = -1L;
        this._byteCount = -1L;
        this._progressState = 0;
    }

    public void setContentLength(long length, boolean update) {
        this._contentLength = length;
        if (update) {
            this.updateDisplay();
        }
    }

    public void setProgressState(int state, boolean update) {
        this._progressState = state;
        if (update) {
            this.updateDisplay();
        }
    }

    public void setDocName(String name, boolean update) {
        this._docName = name;
        if (update) {
            this.updateDisplay();
        }
    }

    public void setByteCount(long count, boolean update) {
        this._byteCount = count;
        if (update) {
            this.updateDisplay();
        }
    }

    private void updateDisplay() {
        String txt;
        String progString = "";
        switch (this._progressState) {
            case 1: {
                txt = "Downloading " + this._docName;
                break;
            }
            case 2: {
                txt = "Processing " + this._docName;
                break;
            }
            default: {
                txt = this._docName;
            }
        }
        this._docNameLabel.setText(txt);
        if (this._byteCount >= 0L) {
            progString = Long.toString(this._byteCount) + " bytes";
            if (this._contentLength > 0L) {
                progString = progString + " out of " + Long.toString(this._contentLength);
            }
        }
        this._progressLabel.setText(progString);
        Container content = this.getContentPane();
        content.update(content.getGraphics());
    }
}

