/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Checksummer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChecksumInputStream
extends FilterInputStream {
    private InputStream subsumedStream;
    private Checksummer _cksummer;
    private long _nBytes;

    public ChecksumInputStream(InputStream stream, Checksummer cksummer) {
        super(stream);
        this.subsumedStream = stream;
        this._cksummer = cksummer;
        this._nBytes = 0L;
    }

    @Override
    public int read() throws IOException {
        int ch = this.subsumedStream.read();
        if (ch >= 0) {
            ++this._nBytes;
            if (this._cksummer != null) {
                this._cksummer.update(ch);
            }
        }
        return ch;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int len = this.subsumedStream.read(b);
        if (len > 0) {
            if (this._cksummer != null) {
                this._cksummer.update(b);
            }
            this._nBytes += (long)len;
        }
        return len;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if ((len = this.subsumedStream.read(b, off, len)) > 0) {
            if (this._cksummer != null) {
                this._cksummer.update(b, off, len);
            }
            this._nBytes += (long)len;
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        int bufsize;
        byte[] buf;
        int nread;
        long nret = 0L;
        while (n > 0L && (nread = this.read(buf = new byte[bufsize = (int)(n > 8192L ? 8192L : n)])) > 0) {
            nret += (long)nread;
            n -= (long)nread;
        }
        return nret;
    }

    @Override
    public void close() throws IOException {
        this.subsumedStream.close();
    }

    public long getNBytes() {
        return this._nBytes;
    }

    public Checksummer getChecksummer() {
        return this._cksummer;
    }
}

