/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.handler;

import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.handler.XmlHandler;
import edu.harvard.hul.ois.jhove.handler.audit.AuditCount;
import edu.harvard.hul.ois.jhove.handler.audit.AuditState;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

public class AuditHandler
extends XmlHandler {
    private static final String NAME = "Audit";
    private static final String RELEASE = "1.1";
    private static final int[] DATE = new int[]{2005, 4, 22};
    private static final String NOTE = "This output handler is derived from the standard JHOVE XML output handler. It is intended to be used as the parent class for other, more interesting handlers.";
    private static final String RIGHTS = "Copyright 2004-2005 by the President and Fellows of Harvard College. Released under the GNU LGPL license.";
    protected String _home;
    protected Map<String, AuditCount> _mimeType;
    protected Map<String, AuditState> _stateMap;
    protected Stack<AuditState> _stateStack;
    protected long _t0;
    protected int _nAudit;

    public AuditHandler() {
        super(NAME, RELEASE, DATE, NOTE, RIGHTS);
        this._name = NAME;
        this._release = RELEASE;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(DATE[0], DATE[1] - 1, DATE[2]);
        this._date = calendar.getTime();
        this._note = NOTE;
        this._rights = RIGHTS;
        this._mimeType = new TreeMap(Comparator.nullsFirst(Comparator.naturalOrder()));
        this._stateMap = new TreeMap<String, AuditState>();
        this._stateStack = new Stack();
        this._nAudit = 0;
    }

    @Override
    public final void endDirectory() {
        AuditState state = this._stateStack.pop();
        this._stateMap.put(state.getDirectory(), state);
        this.endDirectoryImpl();
    }

    public void endDirectoryImpl() {
    }

    @Override
    public void show(RepInfo info) {
        AuditState state = this._stateStack.peek();
        String mime = info.getMimeType();
        AuditCount count = this._mimeType.get(mime);
        if (count == null) {
            count = new AuditCount();
        }
        if (info.getWellFormed() == 1) {
            if (info.getValid() == 1) {
                state.setValid(state.getValid() + 1);
                count.setValid(count.getValid() + 1);
            } else {
                state.setWellFormed(state.getWellFormed() + 1);
                count.setWellFormed(count.getWellFormed() + 1);
            }
        } else if (info.getWellFormed() == 0) {
            state.setNotWellFormed(state.getNotWellFormed() + 1);
            count.setNotWellFormed(count.getNotWellFormed() + 1);
        } else {
            state.setUndetermined(state.getUndetermined() + 1);
            count.setUndetermined(count.getUndetermined() + 1);
        }
        this._mimeType.put(mime, count);
        this.showImpl(info);
    }

    public void showImpl(RepInfo info) {
        String status;
        switch (info.getWellFormed()) {
            case 1: {
                if (info.getValid() == 1) {
                    status = "valid";
                    break;
                }
                status = "well-formed";
                break;
            }
            case 0: {
                status = "not well-formed";
                break;
            }
            default: {
                status = "unknown";
            }
        }
        String md5 = null;
        for (Checksum checksum : info.getChecksum()) {
            if (!checksum.getType().equals((Object)ChecksumType.MD5)) continue;
            md5 = checksum.getValue();
            break;
        }
        if (this._nAudit == 0) {
            String margin = AuditHandler.getIndent(++this._level);
            String[][] attrs = new String[][]{{"home", this._home}};
            this._writer.println(margin + AuditHandler.elementStart("audit", attrs));
        }
        String margn2 = AuditHandler.getIndent(this._level) + " ";
        String uri = info.getUri();
        int n = uri.indexOf(this._home);
        if (n == 0) {
            uri = uri.substring(this._home.length() + 1);
        }
        String mime = info.getMimeType();
        String[][] attrs = new String[][]{{"mime", mime}, {"status", status}, {"md5", md5}};
        this._writer.println(margn2 + AuditHandler.element("file", attrs, uri));
        ++this._nAudit;
    }

    @Override
    public void showFooter() {
        AuditState state = this._stateStack.pop();
        if (state.getTotal() > 0) {
            this._stateMap.put(state.getDirectory(), state);
        }
        this.showFooterImpl();
        this._writer.println("<!-- Summary by MIME type:");
        this._writer.println("<!-- [mime type]: [file count] ([valid],[well-formed],[not well-formed],[unknown])");
        int nTotal = 0;
        int nValid = 0;
        int nWellFormed = 0;
        int nNotWellFormed = 0;
        int nUndetermined = 0;
        for (Map.Entry<String, AuditCount> entry : this._mimeType.entrySet()) {
            String mime = entry.getKey();
            AuditCount count = entry.getValue();
            int total = count.getTotal();
            int valid = count.getValid();
            int wellFormed = count.getWellFormed();
            int notWellFormed = count.getNotWellFormed();
            int undetermined = count.getUndetermined();
            if (mime == null) {
                mime = "None";
            }
            this._writer.println(mime + ": " + total + " (" + valid + "," + wellFormed + "," + notWellFormed + "," + undetermined + ")");
            nTotal += total;
            nValid += valid;
            nWellFormed += wellFormed;
            nNotWellFormed += notWellFormed;
            nUndetermined += undetermined;
        }
        this._writer.println("Total: " + nTotal + " (" + nValid + "," + nWellFormed + "," + nNotWellFormed + "," + nUndetermined + ")");
        this._writer.println("-->");
        this._writer.println("<!-- Summary by directory:");
        this._writer.println("<!-- [directory]: [file count] ([valid],[well-formed],[not well-formed],[unknown])");
        nTotal = 0;
        nValid = 0;
        nWellFormed = 0;
        nNotWellFormed = 0;
        nUndetermined = 0;
        for (Map.Entry<String, AuditCount> entry : this._stateMap.entrySet()) {
            String directory = entry.getKey();
            state = (AuditState)entry.getValue();
            int total = state.getTotal();
            int valid = state.getValid();
            int wellFormed = state.getWellFormed();
            int notWellFormed = state.getNotWellFormed();
            int undetermined = state.getUndetermined();
            this._writer.println(directory + ": " + total + " (" + valid + "," + wellFormed + "," + notWellFormed + "," + undetermined + ")");
            nTotal += total;
            nValid += valid;
            nWellFormed += wellFormed;
            nNotWellFormed += notWellFormed;
            nUndetermined += undetermined;
        }
        this._writer.println("Total: " + nTotal + " (" + nValid + "," + nWellFormed + "," + nNotWellFormed + "," + nUndetermined + ")");
        this._writer.println("-->");
        long dt = (System.currentTimeMillis() - this._t0 + 999L) / 1000L;
        long ss = dt % 60L;
        long dm = dt / 60L;
        long mm = dm % 60L;
        long hh = dm / 60L;
        this._writer.println("<!-- Elapsed time: " + hh + ":" + (mm > 9L ? "" : "0") + mm + ":" + (ss > 9L ? "" : "0") + ss + " -->");
        this._writer.flush();
    }

    public void showFooterImpl() {
        if (this._nAudit > 0) {
            String margin = AuditHandler.getIndent(this._level--);
            this._writer.println(margin + AuditHandler.elementEnd("audit"));
        }
        super.showFooter();
    }

    @Override
    public void showHeader() {
        this._mimeType = new TreeMap(Comparator.nullsFirst(Comparator.naturalOrder()));
        this._stateMap = new TreeMap<String, AuditState>();
        this._stateStack = new Stack();
        this._nAudit = 0;
        this._t0 = System.currentTimeMillis();
        AuditState state = this.showHeaderImpl(".");
        this._stateStack.push(state);
        this._home = state.getDirectory();
    }

    public AuditState showHeaderImpl(String directory) {
        super.showHeader();
        return new AuditState(directory);
    }

    @Override
    public void startDirectory(String directory) {
        try {
            AuditState state = (AuditState)this._stateStack.peek().clone(directory);
            this.startDirectoryImpl(state);
            this._stateStack.push(state);
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public void startDirectoryImpl(AuditState state) {
    }
}

