/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.ConfigHandler;
import edu.harvard.hul.ois.jhove.ConfigWriter;
import edu.harvard.hul.ois.jhove.ModuleInfo;
import edu.harvard.hul.ois.jhove.viewer.MainScreen;
import edu.harvard.hul.ois.jhove.viewer.NumericField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class ConfigWindow
extends JDialog {
    private static final String tempDirDefault = "<Default>";
    private File _configFile;
    private List<ModuleInfo> _modules;
    private List<String[]> _handlers;
    private int _bufferSize;
    private File _homeDir;
    private File _tempDir;
    private String _encoding;
    private Box _mainBox;
    private JTable _modTable;
    private JTable _hanTable;
    private AbstractTableModel _modTableModel;
    private AbstractTableModel _hanTableModel;
    private JLabel _homeLabel;
    private JLabel _tempDirLabel;
    private NumericField _bufSizeBox;
    private JTextField _encodingBox;
    static final Color _tableColor = new Color(235, 230, 210);
    static final Font _pathFont = new Font("SansSerif", 0, 10);
    static final Font _infoFont = new Font("SansSerif", 0, 12);

    public ConfigWindow(JFrame parent, File configFile, ConfigHandler handler) {
        super(parent, "Jhove Configuration", true);
        this.setDefaultCloseOperation(2);
        this._configFile = configFile;
        if (handler != null) {
            this._modules = handler.getModule();
            this._handlers = handler.getHandler();
            this._bufferSize = handler.getBufferSize();
            String dir = handler.getJhoveHome();
            if (dir != null) {
                this._homeDir = new File(dir);
            }
            if ((dir = handler.getTempDir()) != null) {
                this._tempDir = new File(dir);
            }
            this._encoding = handler.getEncoding();
        } else {
            this._modules = new ArrayList<ModuleInfo>(10);
            this._handlers = new ArrayList<String[]>(5);
            this._bufferSize = -1;
            this._homeDir = null;
            this._tempDir = null;
            this._encoding = null;
        }
        this._mainBox = Box.createVerticalBox();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._mainBox, "Center");
        this._mainBox.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        Rectangle screenRect = MainScreen.mainBounds();
        int maxHeight = screenRect.height - 200;
        if (maxHeight > 640) {
            maxHeight = 640;
        }
        this._mainBox.setMaximumSize(new Dimension(500, maxHeight));
        this._mainBox.setPreferredSize(new Dimension(400, maxHeight));
        this.addModuleTable();
        this._mainBox.add(Box.createRigidArea(new Dimension(0, 6)));
        this.addHandlerTable();
        this.addHomeDir();
        this.addTempDir();
        this.addEncoding();
        this.addBufferSize();
        this.addSaveCancel();
        this.pack();
    }

    private void addModuleTable() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this._mainBox.add(panel);
        this._modTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return ConfigWindow.this._modules.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }

            @Override
            public Object getValueAt(int row, int column) {
                ModuleInfo modInfo = (ModuleInfo)ConfigWindow.this._modules.get(row);
                String[] tuple = new String[]{modInfo.clas, modInfo.init};
                return tuple[column];
            }

            @Override
            public void setValueAt(Object obj, int row, int column) {
                ModuleInfo modInfo = (ModuleInfo)ConfigWindow.this._modules.get(row);
                if (column == 0 && obj instanceof String) {
                    modInfo.clas = (String)obj;
                }
                if (column == 1 && obj instanceof String) {
                    modInfo.init = (String)obj;
                }
            }
        };
        this._modTable = new JTable(this._modTableModel);
        this._modTable.setSelectionMode(0);
        this._modTable.setCellSelectionEnabled(true);
        this._modTable.setBackground(_tableColor);
        JScrollPane modScrollPane = new JScrollPane(this._modTable);
        TableColumnModel colMod = this._modTable.getColumnModel();
        colMod.getColumn(0).setHeaderValue("Class");
        colMod.getColumn(1).setHeaderValue("Init");
        this._modTable.doLayout();
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)new JLabel("Modules:"), "West");
        JPanel rightPanel = new JPanel();
        topPanel.add((Component)rightPanel, "East");
        JButton addButton = new JButton("Add");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigWindow.this.addModule();
            }
        });
        rightPanel.add(addButton);
        JButton delButton = new JButton("Delete");
        delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigWindow.this.deleteModule();
            }
        });
        addButton.setMinimumSize(delButton.getMinimumSize());
        addButton.setPreferredSize(delButton.getPreferredSize());
        rightPanel.add(delButton);
        panel.add((Component)topPanel, "North");
        panel.add((Component)modScrollPane, "Center");
    }

    private void addHandlerTable() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this._mainBox.add(panel);
        this._hanTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return ConfigWindow.this._handlers.size();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }

            @Override
            public Object getValueAt(int row, int column) {
                String[] tuple = (String[])ConfigWindow.this._handlers.get(row);
                if (tuple != null) {
                    return tuple[0];
                }
                return "";
            }

            @Override
            public void setValueAt(Object obj, int row, int column) {
                if (obj instanceof String) {
                    String[] stuff = new String[]{(String)obj};
                    ConfigWindow.this._handlers.set(row, stuff);
                }
            }
        };
        this._hanTable = new JTable(this._hanTableModel);
        this._hanTable.setSelectionMode(0);
        this._hanTable.setCellSelectionEnabled(true);
        this._hanTable.setBackground(_tableColor);
        JScrollPane hanScrollPane = new JScrollPane(this._hanTable);
        TableColumnModel colMod = this._hanTable.getColumnModel();
        colMod.getColumn(0).setHeaderValue("Class");
        this._hanTable.doLayout();
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)new JLabel("Handlers:"), "West");
        JPanel rightPanel = new JPanel();
        topPanel.add((Component)rightPanel, "East");
        JButton addButton = new JButton("Add");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigWindow.this.addHandler();
            }
        });
        rightPanel.add(addButton);
        JButton delButton = new JButton("Delete");
        delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigWindow.this.deleteHandler();
            }
        });
        addButton.setMinimumSize(delButton.getMinimumSize());
        addButton.setPreferredSize(delButton.getPreferredSize());
        rightPanel.add(delButton);
        panel.add((Component)topPanel, "North");
        panel.add((Component)hanScrollPane, "Center");
    }

    private void addEncoding() {
        JPanel panel = new JPanel();
        this._mainBox.add(panel);
        panel.add(new JLabel("Default encoding: "));
        this._encodingBox = new JTextField(this._encoding == null ? "" : this._encoding, 14);
        panel.add(this._encodingBox);
    }

    private void addBufferSize() {
        JPanel panel = new JPanel();
        this._mainBox.add(panel);
        panel.add(new JLabel("Buffer size (-1 for default): "));
        this._bufSizeBox = new NumericField(this._bufferSize);
        panel.add(this._bufSizeBox);
    }

    private void addHomeDir() {
        JPanel panel = new JPanel();
        this._mainBox.add(panel);
        panel.setLayout(new GridLayout(1, 2));
        JButton homeButton = new JButton("Home directory...");
        String homeText = "<none specified>";
        if (this._homeDir != null) {
            homeText = this._homeDir.getPath();
        }
        this._homeLabel = new JLabel(homeText);
        this._homeLabel.setFont(_pathFont);
        JPanel bpan = new JPanel();
        panel.add(bpan);
        bpan.add(homeButton);
        homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigWindow.this.chooseHomeDir();
            }
        });
        panel.add(this._homeLabel);
    }

    private void addTempDir() {
        JPanel panel = new JPanel();
        this._mainBox.add(panel);
        panel.setLayout(new GridLayout(1, 2));
        JButton tempDirButton = new JButton("Temp directory...");
        String tempDirText = tempDirDefault;
        if (this._tempDir != null) {
            tempDirText = this._tempDir.getPath();
        }
        this._tempDirLabel = new JLabel(tempDirText);
        this._tempDirLabel.setFont(_pathFont);
        JPanel bpan = new JPanel();
        panel.add(bpan);
        bpan.add(tempDirButton);
        tempDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigWindow.this.chooseTempDir();
            }
        });
        panel.add(this._tempDirLabel);
    }

    private void addSaveCancel() {
        final ConfigWindow thiscw = this;
        JPanel buttonPanel = new JPanel();
        this.getContentPane().add((Component)buttonPanel, "South");
        buttonPanel.setLayout(new BorderLayout());
        JLabel changesLabel = new JLabel("Changes take effect on relaunch");
        changesLabel.setFont(_infoFont);
        buttonPanel.add((Component)changesLabel, "North");
        JPanel panel = new JPanel();
        buttonPanel.add((Component)panel, "Center");
        panel.setLayout(new GridLayout(1, 3));
        JPanel bpan = new JPanel();
        panel.add(bpan);
        bpan = new JPanel();
        JButton saveButton = new JButton("OK");
        this.getRootPane().setDefaultButton(saveButton);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigWindow.this.doSave();
            }
        });
        bpan.add(saveButton);
        panel.add(bpan);
        bpan = new JPanel();
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                thiscw.dispose();
            }
        });
        saveButton.setMinimumSize(cancelButton.getMinimumSize());
        saveButton.setPreferredSize(cancelButton.getPreferredSize());
        bpan.add(cancelButton);
        panel.add(bpan);
    }

    private void doSave() {
        try {
            try {
                this._bufSizeBox.commitEdit();
            }
            catch (ParseException e) {
                return;
            }
            this._bufferSize = ((Long)this._bufSizeBox.getValue()).intValue();
            this._encoding = this._encodingBox.getText();
            ConfigWriter cw = new ConfigWriter(this._configFile, this);
            cw.writeFile(this._modules, this._handlers, this._homeDir, this._tempDir, this._encoding, this._bufferSize);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Can't create config", 0);
        }
        this.dispose();
    }

    private void chooseHomeDir() {
        JFileChooser chooser = new JFileChooser();
        if (this._homeDir != null) {
            chooser.setCurrentDirectory(this._homeDir);
        }
        chooser.setDialogTitle("Select Home Directory");
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            this._homeDir = chooser.getSelectedFile();
            this._homeLabel.setText(this._homeDir.getPath());
        }
    }

    private void chooseTempDir() {
        final JFileChooser chooser = new JFileChooser();
        if (this._homeDir != null) {
            chooser.setCurrentDirectory(this._tempDir);
        }
        chooser.setDialogTitle("Select Temporary Directory");
        JPanel accessory = new JPanel();
        accessory.setPreferredSize(new Dimension(160, 40));
        JButton defaultButton = new JButton("System Default");
        defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigWindow.this._tempDir = null;
                ConfigWindow.this._tempDirLabel.setText(ConfigWindow.tempDirDefault);
                chooser.cancelSelection();
            }
        });
        accessory.add(defaultButton);
        chooser.setAccessory(accessory);
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            this._tempDir = chooser.getSelectedFile();
            this._tempDirLabel.setText(this._tempDir.getPath());
        }
    }

    private void addModule() {
        ListSelectionModel ls = this._modTable.getSelectionModel();
        int selRow = ls.getMinSelectionIndex();
        if (selRow < 0) {
            selRow = this._modules.size();
        }
        ModuleInfo modInfo = new ModuleInfo("", null);
        this._modules.add(selRow, modInfo);
        this._modTableModel.fireTableRowsInserted(selRow, selRow);
    }

    private void deleteModule() {
        ListSelectionModel ls = this._modTable.getSelectionModel();
        int selRow = ls.getMinSelectionIndex();
        if (selRow < 0) {
            return;
        }
        this._modules.remove(selRow);
        this._modTableModel.fireTableRowsDeleted(selRow, selRow);
    }

    private void addHandler() {
        ListSelectionModel ls = this._hanTable.getSelectionModel();
        int selRow = ls.getMinSelectionIndex();
        if (selRow < 0) {
            selRow = this._handlers.size();
        }
        String[] tuple = new String[]{""};
        this._handlers.add(selRow, tuple);
        this._hanTableModel.fireTableRowsInserted(selRow, selRow);
    }

    private void deleteHandler() {
        ListSelectionModel ls = this._hanTable.getSelectionModel();
        int selRow = ls.getMinSelectionIndex();
        if (selRow < 0) {
            return;
        }
        this._handlers.remove(selRow);
        this._hanTableModel.fireTableRowsDeleted(selRow, selRow);
    }
}

