/*
 * Decompiled with CFR 0.152.
 */
import edu.harvard.hul.ois.jhove.Dump;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.aiff.ExtDouble;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;

public class ADump
extends Dump {
    private static final int[] sigByte = new int[]{70, 79, 82, 77};
    private static final boolean ENDIAN = true;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: java ADump file");
            System.exit(-1);
        }
        try {
            FileInputStream file = new FileInputStream(args[0]);
            BufferedInputStream buffer = new BufferedInputStream(file);
            DataInputStream stream = new DataInputStream(buffer);
            long os = 0L;
            for (int i = 0; i < 4; ++i) {
                int ch = stream.readUnsignedByte();
                if (ch == sigByte[i]) continue;
                System.out.println("No AIFF FORM header");
                System.exit(-2);
            }
            os += 4L;
            long ckSize = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)true);
            StringBuffer formType = new StringBuffer(4);
            for (int i = 0; i < 4; ++i) {
                int ch = ModuleBase.readUnsignedByte((DataInputStream)stream);
                formType.append((char)ch);
            }
            System.out.println("00000000: FORM " + ckSize + ": " + formType);
            boolean aiff_c = false;
            if ("AIFC".equals(formType.toString())) {
                aiff_c = true;
            }
            StringBuffer sbuf = new StringBuffer();
            boolean endOfFile = false;
            while (!endOfFile) {
                try {
                    sbuf.setLength(0);
                    for (int i = 0; i < 4; ++i) {
                        int ch = ModuleBase.readUnsignedByte((DataInputStream)stream);
                        sbuf.append((char)ch);
                    }
                    String ckID = sbuf.toString();
                    ckSize = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)true);
                    System.out.print(ADump.leading((long)os, (int)8) + os + ": " + ckID + " " + ckSize);
                    long alreadyRead = 0L;
                    if ("AESD".equals(ckID)) {
                        int i;
                        int[] aes = new int[24];
                        for (i = 0; i < 24; ++i) {
                            aes[i] = ModuleBase.readUnsignedByte((DataInputStream)stream);
                        }
                        System.out.print(": " + aes[0]);
                        for (i = 1; i < 24; ++i) {
                            System.out.print("," + aes[i]);
                        }
                        alreadyRead = 24L;
                    } else if ("ANNO".equals(ckID) || "AUTH".equals(ckID) || "(c) ".equals(ckID) || "NAME".equals(ckID)) {
                        sbuf.setLength(0);
                        int i = 0;
                        while ((long)i < ckSize) {
                            int ch = ModuleBase.readUnsignedByte((DataInputStream)stream);
                            sbuf.append((char)ch);
                            ++i;
                        }
                        System.out.print(": \"" + sbuf.toString() + "\"");
                        alreadyRead = ckSize;
                    } else if ("APPL".equals(ckID)) {
                        sbuf.setLength(0);
                        for (int i = 0; i < 4; ++i) {
                            int ch = ModuleBase.readUnsignedByte((DataInputStream)stream);
                            sbuf.append((char)ch);
                        }
                        System.out.print(": " + sbuf.toString());
                        alreadyRead = 4L;
                    } else if ("COMM".equals(ckID)) {
                        int numChannels = ModuleBase.readSignedShort((DataInputStream)stream, (boolean)true);
                        long numSampleFrames = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)true);
                        int sampleSize = ModuleBase.readSignedShort((DataInputStream)stream, (boolean)true);
                        byte[] buf = new byte[10];
                        for (int i = 0; i < 10; ++i) {
                            buf[i] = (byte)ModuleBase.readSignedByte((DataInputStream)stream);
                        }
                        ExtDouble xd = new ExtDouble(buf);
                        double sampleRate = xd.toDouble();
                        System.out.print(": " + numChannels + " " + numSampleFrames + " " + sampleSize + " " + sampleRate);
                        alreadyRead = 18L;
                        if (aiff_c) {
                            sbuf.setLength(0);
                            for (int i = 0; i < 4; ++i) {
                                int ch = ModuleBase.readUnsignedByte((DataInputStream)stream, null);
                                sbuf.append((char)ch);
                            }
                            System.out.print(" " + sbuf.toString());
                            int count = ModuleBase.readUnsignedByte((DataInputStream)stream, null);
                            alreadyRead = 23L;
                            sbuf.setLength(0);
                            for (int i = 0; i < count; ++i) {
                                int ch = ModuleBase.readUnsignedByte((DataInputStream)stream, null);
                                sbuf.append((char)ch);
                                ++alreadyRead;
                            }
                            System.out.print(" \"" + sbuf.toString() + "\"");
                        }
                    } else if ("COMT".equals(ckID)) {
                        int numComments = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)true, null);
                        System.out.print(": " + numComments);
                        alreadyRead = 2L;
                    } else if ("FVER".equals(ckID)) {
                        long timestamp = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)true, null);
                        System.out.print(": " + timestamp);
                        alreadyRead = 4L;
                    } else if ("INST".equals(ckID)) {
                        int baseNote = ModuleBase.readSignedByte((DataInputStream)stream);
                        int detune = ModuleBase.readSignedByte((DataInputStream)stream);
                        int lowNote = ModuleBase.readSignedByte((DataInputStream)stream);
                        int highNote = ModuleBase.readSignedByte((DataInputStream)stream);
                        int lowVelocity = ModuleBase.readSignedByte((DataInputStream)stream);
                        int highVelocity = ModuleBase.readSignedByte((DataInputStream)stream);
                        int gain = ModuleBase.readSignedShort((DataInputStream)stream, (boolean)true);
                        System.out.print(": " + baseNote + " " + detune + " " + lowNote + "," + highNote + " " + lowVelocity + "," + highVelocity + " " + gain);
                        alreadyRead = 8L;
                    } else if ("MARK".equals(ckID)) {
                        int numMarkers = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)true);
                        System.out.print(": " + numMarkers);
                        alreadyRead = 2L;
                    } else if ("SSND".equals(ckID)) {
                        long offset = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)true);
                        long blockSize = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)true);
                        System.out.print(": " + offset + " " + blockSize);
                        alreadyRead = 8L;
                    }
                    System.out.println();
                    long actSize = ckSize;
                    if ((actSize & 1L) != 0L) {
                        ++actSize;
                    }
                    stream.skipBytes((int)(actSize -= alreadyRead));
                    os += ckSize + 8L;
                }
                catch (EOFException e) {
                    endOfFile = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

