/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import edu.harvard.hul.ois.jhove.module.aiff.AnnotationChunk;
import edu.harvard.hul.ois.jhove.module.aiff.ApplicationChunk;
import edu.harvard.hul.ois.jhove.module.aiff.AudioRecChunk;
import edu.harvard.hul.ois.jhove.module.aiff.AuthorChunk;
import edu.harvard.hul.ois.jhove.module.aiff.CommentsChunk;
import edu.harvard.hul.ois.jhove.module.aiff.CommonChunk;
import edu.harvard.hul.ois.jhove.module.aiff.CopyrightChunk;
import edu.harvard.hul.ois.jhove.module.aiff.ExtDouble;
import edu.harvard.hul.ois.jhove.module.aiff.FormatVersionChunk;
import edu.harvard.hul.ois.jhove.module.aiff.InstrumentChunk;
import edu.harvard.hul.ois.jhove.module.aiff.MarkerChunk;
import edu.harvard.hul.ois.jhove.module.aiff.MessageConstants;
import edu.harvard.hul.ois.jhove.module.aiff.MidiChunk;
import edu.harvard.hul.ois.jhove.module.aiff.NameChunk;
import edu.harvard.hul.ois.jhove.module.aiff.SaxelChunk;
import edu.harvard.hul.ois.jhove.module.aiff.SoundDataChunk;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class AiffModule
extends ModuleBase {
    protected Property _metadata;
    protected List _propList;
    protected AESAudioMetadata _aesMetadata;
    protected List _annotationList;
    protected List _midiList;
    protected List _saxelList;
    protected long bytesRemaining;
    protected boolean soundChunkSeen;
    protected boolean formatVersionChunkSeen;
    protected boolean instrumentChunkSeen;
    protected boolean commonChunkSeen;
    protected boolean commentsChunkSeen;
    protected boolean nameChunkSeen;
    protected boolean authorChunkSeen;
    protected boolean copyrightChunkSeen;
    protected boolean markerChunkSeen;
    protected boolean audioRecChunkSeen;
    protected boolean firstSampleOffsetMarked;
    protected int fileType;
    protected boolean thisFileBigEndian;
    private static final boolean BIGENDIAN = true;
    public static final int AIFFTYPE = 1;
    public static final int AIFCTYPE = 2;
    private static final int[] sigByte = new int[]{70, 79, 82, 77};
    private static final String NAME = "AIFF-hul";
    private static final String RELEASE = "1.6.1";
    private static final int[] DATE = new int[]{2019, 12, 10};
    private static final String[] FORMAT = new String[]{"AIFF", "Audio Interchange File Format"};
    private static final String COVERAGE = "AIFF 1.3, AIFF-C";
    private static final String[] MIMETYPE = new String[]{"audio/x-aiff", "application/aiff"};
    private static final String WELLFORMED = "Magic number: \"FORM\" at byte offset 0; \"AIFF\"(for AIFF) or \"AIFC\" (for AIFF-C) at offset 8; one Form chunk containing one Common chunk and at most one Sound Data chunk (if numSampleFrames > 0); at most one instance of each of the following optional chunks: Marker, Instrument, Audio Recording, Comments, Name, Author, Copyright; all chunks required by a given profile exist in the file; all chunk structures are well-formed: a four ASCII character ID, followed by a 32 signed integer size, followed by a size byte data block (if size is odd, then the data block includes a final padding byte of value 0x00); and no data exist before the first byte of the chunk or after the last byte of the last chunk";
    private static final String VALIDITY = "The file is well-formed";
    private static final String REPINFO = "Properties capturing the technical attributes of the audio from all chunks";
    private static final String NOTE = null;
    private static final String RIGHTS = "Copyright 2004-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";

    public AiffModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        this._vendor = Agent.harvardInstance();
        Document doc = new Document("Audio Interchange File Format: \"AIFF\", A Standard for Sampled Sound Files, Version 1.3", DocumentType.REPORT);
        Agent.Builder builder = new Agent.Builder("Apple Computer, Inc.", AgentType.COMMERCIAL).address("1 Infinite Loop, Cupertino, CA 95014").telephone("(408) 996-1010").web("http://www.apple.com/");
        Agent appleAgent = builder.build();
        doc.setAuthor(appleAgent);
        doc.setDate("1989-01-04");
        doc.setIdentifier(new Identifier("http://developer.apple.com/documentation/QuickTime/INMAC/SOUND/imsoundmgr.30.htm#pgfId=3190", IdentifierType.URL));
        this._specification.add(doc);
        doc = new Document("Audio Interchange File Format AIFF-C: A revision to include compressed audio data", DocumentType.REPORT);
        doc.setAuthor(appleAgent);
        doc.setDate("1991-08-26");
        doc.setNote("*** DRAFT ***");
        this._specification.add(doc);
        ExternalSignature sig = new ExternalSignature("AIFF", SignatureType.FILETYPE, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new ExternalSignature("AIFC", SignatureType.FILETYPE, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new ExternalSignature(".aif", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new ExternalSignature(".aifc", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "For AIFF-C profile");
        this._signature.add(sig);
        sig = new InternalSignature("FORM", SignatureType.MAGIC, SignatureUseType.MANDATORY, 0);
        this._signature.add(sig);
        sig = new InternalSignature("AIFF", SignatureType.MAGIC, SignatureUseType.OPTIONAL, 8, "For AIFF profile");
        this._signature.add(sig);
        sig = new InternalSignature("AIFC", SignatureType.MAGIC, SignatureUseType.OPTIONAL, 0, "For AIFF-C profile");
        this._signature.add(sig);
        this._bigEndian = true;
    }

    public int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        this.initParse();
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule((Module)this);
        this._aesMetadata.setPrimaryIdentifier(info.getUri());
        if (info.getURLFlag()) {
            this._aesMetadata.setOtherPrimaryIdentifierType("URI");
        } else {
            this._aesMetadata.setPrimaryIdentifierType("FILE_NAME");
        }
        this.setupDataStream(stream, info);
        try {
            for (int i = 0; i < 4; ++i) {
                int ch = AiffModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                if (ch == sigByte[i]) continue;
                info.setMessage((Message)new ErrorMessage(MessageConstants.AIFF_HUL_1, 0L));
                info.setWellFormed(0);
                return 0;
            }
            info.setSigMatch(this._name);
            this.bytesRemaining = AiffModule.readUnsignedInt((DataInputStream)this._dstream, (boolean)true, (ModuleBase)this);
            if (!this.readFileType(info)) {
                return 0;
            }
            while (this.bytesRemaining > 0L && this.readChunk(info)) {
            }
        }
        catch (EOFException e) {
            info.setWellFormed(0);
            info.setMessage((Message)new ErrorMessage(MessageConstants.AIFF_HUL_8, this._nByte));
            return 0;
        }
        if (!this.commonChunkSeen) {
            info.setWellFormed(0);
            info.setMessage((Message)new ErrorMessage(MessageConstants.AIFF_HUL_2));
        }
        if (this.fileType == 2 && !this.formatVersionChunkSeen) {
            info.setWellFormed(0);
            info.setMessage((Message)new ErrorMessage(MessageConstants.AIFF_HUL_3));
        }
        if (info.getWellFormed() != 1) {
            return 0;
        }
        if (this._ckSummer != null) {
            this.skipDstreamToEnd(info);
            AiffModule.setChecksums((Checksummer)this._ckSummer, (RepInfo)info);
        }
        if (this.fileType == 1) {
            info.setProfile("AIFF");
        } else if (this.fileType == 2) {
            info.setProfile("AIFF-C");
        }
        this._aesMetadata.setByteOrder(this.thisFileBigEndian ? 0 : 1);
        if (!this._annotationList.isEmpty()) {
            this._propList.add(new Property("Annotations", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._annotationList));
        }
        if (!this._midiList.isEmpty()) {
            this._propList.add(new Property("MIDIData", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._midiList));
        }
        if (!this._saxelList.isEmpty()) {
            this._propList.add(new Property("Saxels", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._saxelList));
        }
        info.setProperty(this._metadata);
        return 0;
    }

    public void setEndian(boolean bigEndian) {
        this.thisFileBigEndian = bigEndian;
    }

    public void addAiffProperty(Property prop) {
        this._propList.add(prop);
    }

    public void addAnnotation(Property prop) {
        this._annotationList.add(prop);
    }

    public void addSaxel(Property prop) {
        this._saxelList.add(prop);
    }

    public void addMidi(Property prop) {
        this._midiList.add(prop);
    }

    protected void initParse() {
        super.initParse();
        this.thisFileBigEndian = this._bigEndian;
        this._propList = new LinkedList();
        this._metadata = new Property("AIFFMetadata", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._propList);
        this.firstSampleOffsetMarked = false;
        this._aesMetadata = new AESAudioMetadata();
        this._aesMetadata.setAnalogDigitalFlag("FILE_DIGITAL");
        this._aesMetadata.setFormat("AIFF");
        this._aesMetadata.setSpecificationVersion("1.3 (1989-01-04)");
        this._aesMetadata.setAudioDataEncoding("PCM");
        this._aesMetadata.clearBitrateReduction();
        this._aesMetadata.setUse("OTHER", "JHOVE_validation");
        this._aesMetadata.setDirection("NONE");
        this._propList.add(new Property("AESAudioMetadata", PropertyType.AESAUDIOMETADATA, (Object)this._aesMetadata));
        this._annotationList = new LinkedList();
        this._midiList = new LinkedList();
        this._saxelList = new LinkedList();
        this.soundChunkSeen = false;
        this.commonChunkSeen = false;
        this.markerChunkSeen = false;
        this.formatVersionChunkSeen = false;
        this.instrumentChunkSeen = false;
        this.commentsChunkSeen = false;
        this.nameChunkSeen = false;
        this.authorChunkSeen = false;
        this.audioRecChunkSeen = false;
        this.copyrightChunkSeen = false;
    }

    public long readUnsignedInt(DataInputStream stream) throws IOException {
        return AiffModule.readUnsignedInt((DataInputStream)stream, (boolean)true, (ModuleBase)this);
    }

    public int readUnsignedShort(DataInputStream stream) throws IOException {
        return AiffModule.readUnsignedShort((DataInputStream)stream, (boolean)true, (ModuleBase)this);
    }

    public int readSignedShort(DataInputStream stream) throws IOException {
        return AiffModule.readSignedShort((DataInputStream)stream, (boolean)true, (ModuleBase)this);
    }

    public double read80BitDouble(DataInputStream stream) throws IOException {
        byte[] buf = new byte[10];
        AiffModule.readByteBuf((DataInputStream)this._dstream, (byte[])buf, (ModuleBase)this);
        ExtDouble xd = new ExtDouble(buf);
        return xd.toDouble();
    }

    public String read4Chars(DataInputStream stream) throws IOException {
        StringBuffer sbuf = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            int ch = AiffModule.readUnsignedByte((DataInputStream)stream, (ModuleBase)this);
            sbuf.append((char)ch);
        }
        return sbuf.toString();
    }

    public String readPascalString(DataInputStream stream) throws IOException {
        int byteCnt = AiffModule.readUnsignedByte((DataInputStream)stream, (ModuleBase)this);
        byte[] byteBuf = new byte[byteCnt];
        AiffModule.readByteBuf((DataInputStream)this._dstream, (byte[])byteBuf, (ModuleBase)this);
        if ((byteCnt & 1) == 0) {
            this.skipBytes(this._dstream, 1L, this);
        }
        return new String(byteBuf, "MacRoman");
    }

    public Date timestampToDate(long timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.set(1904, 0, 1, 0, 0, 0);
        int hours = (int)(timestamp / 3600L);
        int seconds = (int)(timestamp - (long)hours * 3600L);
        cal.add(11, hours);
        cal.add(13, seconds);
        return cal.getTime();
    }

    public int getFileType() {
        return this.fileType;
    }

    public void markFirstSampleOffset(long offset) {
        if (!this.firstSampleOffsetMarked) {
            this.firstSampleOffsetMarked = true;
            this._aesMetadata.setFirstSampleOffset(this._nByte + offset);
        }
    }

    protected boolean readFileType(RepInfo info) throws IOException {
        String typ = this.read4Chars(this._dstream);
        this.bytesRemaining -= 4L;
        if ("AIFF".equals(typ)) {
            this.fileType = 1;
            return true;
        }
        if ("AIFC".equals(typ)) {
            this.fileType = 2;
            this._aesMetadata.setFormat("AIFF-C");
            this._aesMetadata.setSpecificationVersion("Draft 1991-08-26");
            return true;
        }
        info.setMessage((Message)new ErrorMessage(MessageConstants.AIFF_HUL_4, this._nByte));
        info.setWellFormed(0);
        return false;
    }

    protected boolean readChunk(RepInfo info) throws IOException {
        Chunk chunk = null;
        ChunkHeader chunkh = new ChunkHeader(this, info);
        if (!chunkh.readHeader(this._dstream)) {
            return false;
        }
        int chunkSize = (int)chunkh.getSize();
        this.bytesRemaining -= (long)(chunkSize + 8);
        String id = chunkh.getID();
        if ("FVER".equals(id)) {
            if (this.formatVersionChunkSeen) {
                this.dupChunkError(info, "Format Version");
            }
            chunk = new FormatVersionChunk(this, chunkh, this._dstream);
            this.formatVersionChunkSeen = true;
        } else if ("APPL".equals(id)) {
            chunk = new ApplicationChunk(this, chunkh, this._dstream);
        } else if ("COMM".equals(id)) {
            if (this.commonChunkSeen) {
                this.dupChunkError(info, "Common");
            }
            chunk = new CommonChunk(this, chunkh, this._dstream);
            this.commonChunkSeen = true;
        } else if ("SSND".equals(id)) {
            if (this.soundChunkSeen) {
                this.dupChunkError(info, "Sound");
            } else {
                chunk = new SoundDataChunk(this, chunkh, this._dstream);
                this.soundChunkSeen = true;
            }
        } else if ("COMT".equals(id)) {
            if (this.commentsChunkSeen) {
                this.dupChunkError(info, "Comments");
            }
            chunk = new CommentsChunk(this, chunkh, this._dstream);
            this.commentsChunkSeen = true;
        } else if ("INST".equals(id)) {
            if (this.instrumentChunkSeen) {
                this.dupChunkError(info, "Instrument");
            }
            chunk = new InstrumentChunk(this, chunkh, this._dstream);
            this.instrumentChunkSeen = true;
        } else if ("MARK".equals(id)) {
            if (this.markerChunkSeen) {
                this.dupChunkError(info, "Marker");
            } else {
                chunk = new MarkerChunk(this, chunkh, this._dstream);
                this.markerChunkSeen = true;
            }
        } else if ("MIDI".equals(id)) {
            chunk = new MidiChunk(this, chunkh, this._dstream);
        } else if ("NAME".equals(id)) {
            if (this.nameChunkSeen) {
                this.dupChunkError(info, "Name");
            } else {
                chunk = new NameChunk(this, chunkh, this._dstream);
                this.nameChunkSeen = true;
            }
        } else if ("AUTH".equals(id)) {
            if (this.authorChunkSeen) {
                this.dupChunkError(info, "Author");
            } else {
                chunk = new AuthorChunk(this, chunkh, this._dstream);
                this.authorChunkSeen = true;
            }
        } else if ("(c) ".equals(id)) {
            if (this.copyrightChunkSeen) {
                this.dupChunkError(info, "Copyright");
            } else {
                chunk = new CopyrightChunk(this, chunkh, this._dstream);
                this.copyrightChunkSeen = true;
            }
        } else if ("AESD".equals(id)) {
            if (this.audioRecChunkSeen) {
                this.dupChunkError(info, "Audio Recording");
            } else {
                chunk = new AudioRecChunk(this, chunkh, this._dstream);
                this.audioRecChunkSeen = true;
            }
        } else if ("SAXL".equals(id)) {
            chunk = new SaxelChunk(this, chunkh, this._dstream);
        } else if ("ANNO".equals(id)) {
            chunk = new AnnotationChunk(this, chunkh, this._dstream);
        } else {
            info.setMessage((Message)new InfoMessage(MessageConstants.AIFF_HUL_9, id, this._nByte));
        }
        if (chunk != null) {
            if (!chunk.readChunk(info)) {
                return false;
            }
        } else {
            this.skipBytes(this._dstream, chunkSize, this);
        }
        if ((chunkSize & 1) != 0) {
            this.skipBytes(this._dstream, 1L, this);
            --this.bytesRemaining;
        }
        return true;
    }

    public AESAudioMetadata getAESMetadata() {
        return this._aesMetadata;
    }

    protected void dupChunkError(RepInfo info, String chunkName) {
        JhoveMessage mess = MessageConstants.AIFF_HUL_5;
        String message = String.format(mess.getMessage(), chunkName);
        info.setMessage((Message)new ErrorMessage(JhoveMessages.getMessageInstance((String)mess.getId(), (String)message), this._nByte));
        info.setValid(false);
    }
}

