/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.aiff.MessageConstants;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class CommonChunk
extends Chunk {
    public CommonChunk(AiffModule module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        AiffModule module = (AiffModule)this._module;
        int numChannels = module.readUnsignedShort(this._dstream);
        long numSampleFrames = module.readUnsignedInt(this._dstream);
        int sampleSize = module.readUnsignedShort(this._dstream);
        this.bytesLeft -= 8L;
        String compressionType = null;
        String compressionName = null;
        double sampleRate = module.read80BitDouble(this._dstream);
        this.bytesLeft -= 10L;
        if (module.getFileType() == 2) {
            if (this.bytesLeft == 0L) {
                info.setMessage((Message)new ErrorMessage(MessageConstants.AIFF_HUL_7, module.getNByte()));
                info.setWellFormed(false);
                return false;
            }
            compressionType = module.read4Chars(this._dstream);
            this.bytesLeft -= 4L;
            compressionName = module.readPascalString(this._dstream);
            this.bytesLeft -= (long)(compressionName.length() + 1);
        }
        AESAudioMetadata aes = module.getAESMetadata();
        aes.setBitDepth(sampleSize);
        aes.setSampleRate(sampleRate);
        aes.setNumChannels(numChannels);
        CommonChunk.setChannelLocations(aes, numChannels);
        aes.setDuration(numSampleFrames);
        module.addAiffProperty(new Property("SampleFrames", PropertyType.LONG, (Object)new Long(numSampleFrames)));
        if (compressionType != null) {
            module.addAiffProperty(new Property("CompressionType", PropertyType.STRING, (Object)compressionType));
            switch (compressionType) {
                case "NONE": {
                    break;
                }
                case "raw ": {
                    aes.setAudioDataEncoding("PCM 8-bit offset-binary");
                    break;
                }
                case "twos": {
                    aes.setAudioDataEncoding("PCM 16-bit twos-complement big-endian");
                    break;
                }
                case "sowt": {
                    aes.setAudioDataEncoding("PCM 16-bit twos-complement little-endian");
                    module.setEndian(false);
                    break;
                }
                case "fl32": {
                    aes.setAudioDataEncoding("PCM 32-bit integer");
                    break;
                }
                case "fl64": {
                    aes.setAudioDataEncoding("PCM 64-bit floating point");
                    break;
                }
                case "in24": {
                    aes.setAudioDataEncoding("PCM 24-bit integer");
                    break;
                }
                case "in32": {
                    aes.setAudioDataEncoding("PCM 32-bit integer");
                    break;
                }
                default: {
                    aes.setAudioDataEncoding(compressionName);
                    String name = compressionName;
                    if (name == null || name.length() == 0) {
                        name = compressionType;
                    }
                    aes.setBitrateReduction(compressionName, "", "", "", "LOSSY", "UNKNOWN", "FIXED");
                }
            }
        }
        if (compressionName != null && compressionName.length() > 0) {
            module.addAiffProperty(new Property("CompressionName", PropertyType.STRING, (Object)compressionName));
        }
        return true;
    }

    private static void setChannelLocations(AESAudioMetadata aes, int numChannels) {
        String[] mapLoc = new String[numChannels];
        switch (numChannels) {
            case 1: {
                mapLoc[0] = "UNKNOWN";
                break;
            }
            case 4: {
                mapLoc[3] = "SURROUND";
            }
            case 3: {
                mapLoc[2] = "CENTER";
            }
            case 2: {
                mapLoc[0] = "LEFT";
                mapLoc[1] = "RIGHT";
                break;
            }
            case 6: {
                mapLoc[0] = "LEFT";
                mapLoc[1] = "LEFT_CENTER";
                mapLoc[2] = "CENTER";
                mapLoc[3] = "RIGHT";
                mapLoc[4] = "RIGHT_CENTER";
                mapLoc[5] = "SURROUND";
                break;
            }
            default: {
                for (int i = 0; i < numChannels; ++i) {
                    mapLoc[i] = "UNKNOWN";
                }
            }
        }
        aes.setMapLocations(mapLoc);
    }
}

