/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class SaxelChunk
extends Chunk {
    public SaxelChunk(AiffModule module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        AiffModule module = (AiffModule)this._module;
        int numSaxels = module.readUnsignedShort(this._dstream);
        this.bytesLeft -= 2L;
        if (numSaxels == 0) {
            return true;
        }
        for (int i = 0; i < numSaxels; ++i) {
            Property[] propArr = new Property[2];
            int id = module.readUnsignedShort(this._dstream);
            int size = module.readUnsignedShort(this._dstream);
            module.skipBytes(this._dstream, size, module);
            propArr[0] = new Property("ID", PropertyType.INTEGER, (Object)new Integer(id));
            propArr[1] = new Property("Size", PropertyType.INTEGER, (Object)new Integer(size));
            module.addSaxel(new Property("Saxel", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propArr));
        }
        return true;
    }
}

