/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.iff;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import edu.harvard.hul.ois.jhove.module.iff.MessageConstants;
import java.io.DataInputStream;
import java.io.IOException;

public class ChunkHeader {
    private ModuleBase _module;
    private RepInfo _repInfo;
    private String _chunkId;
    private long _offset;
    private long _size;

    public ChunkHeader(ModuleBase module, RepInfo info) {
        this._module = module;
        this._repInfo = info;
    }

    public boolean readHeader(DataInputStream dstrm) throws IOException {
        int LOWEST_PRINTABLE_ASCII = 32;
        int HIGHEST_PRINTABLE_ASCII = 126;
        this._offset = this._module.getNByte();
        boolean idBeginsWithSpace = false;
        boolean spacePrecedesPrintableCharacters = false;
        StringBuilder id = new StringBuilder(4);
        for (int i = 0; i < 4; ++i) {
            boolean printableCharacter = false;
            int ch = ModuleBase.readUnsignedByte((DataInputStream)dstrm, (ModuleBase)this._module);
            if (ch < 32 || ch > 126) {
                this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.IFF_HUL_1, String.format(MessageConstants.IFF_HUL_1_SUB.getMessage(), ch), this._module.getNByte() - 1L));
                this._repInfo.setWellFormed(false);
                return false;
            }
            if (ch == 32) {
                if (i == 0) {
                    idBeginsWithSpace = true;
                }
            } else {
                printableCharacter = true;
            }
            if (idBeginsWithSpace && printableCharacter) {
                spacePrecedesPrintableCharacters = true;
            }
            id.append((char)ch);
        }
        this._chunkId = id.toString();
        if (spacePrecedesPrintableCharacters) {
            JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.IFF_HUL_2.getId(), (String)String.format(MessageConstants.IFF_HUL_2.getMessage(), this._chunkId));
            this._repInfo.setMessage((Message)new ErrorMessage(message, this._module.getNByte() - 4L));
            this._repInfo.setValid(false);
        }
        this._size = ModuleBase.readUnsignedInt((DataInputStream)dstrm, (boolean)this._module.isBigEndian(), (ModuleBase)this._module);
        return true;
    }

    public void setID(String id) {
        this._chunkId = id;
    }

    public String getID() {
        return this._chunkId;
    }

    public void setSize(long size) {
        this._size = size;
    }

    public long getSize() {
        return this._size;
    }

    public long getOffset() {
        return this._offset;
    }
}

