/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import edu.harvard.hul.ois.jhove.module.ascii.ControlChar;
import edu.harvard.hul.ois.jhove.module.ascii.LineEnding;
import edu.harvard.hul.ois.jhove.module.ascii.MessageConstants;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AsciiModule
extends ModuleBase {
    public static final int MAX_CHAR = 127;
    public static final int MIN_PRINTABLE = 32;
    public static final int MAX_PRINTABLE = 126;
    private static final String NAME = "ASCII-hul";
    private static final String RELEASE = "1.4.1";
    private static final int[] DATE = new int[]{2019, 4, 17};
    private static final String[] FORMAT = new String[]{"ASCII", "US-ASCII", "ANSI X3.4", "ISO 646"};
    private static final String COVERAGE = null;
    private static final String[] MIMETYPE = new String[]{"text/plain; charset=US-ASCII"};
    private static final String WELLFORMED = "An ASCII object is well-formed if each byte is between 0x00 and 0x7F";
    private static final String VALIDITY = null;
    private static final String REPINFO = "Additional representation information includes: line ending and control characters";
    private static final String NOTE = null;
    private static final String RIGHTS = "Copyright 2003-2015 by JSTOR and the President and Fellows of Harvard College. Copyright 2015-2019 by the Open Preservation Foundation. Version 1.4 onwards developed by Open Preservation Foundation. Released under the GNU Lesser General Public License.";
    protected Set<ControlChar> usedCtrlChars;
    protected Set<LineEnding> usedLineEndings;
    protected boolean _withTextMD = false;
    protected TextMDMetadata _textMD;

    public AsciiModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        this._vendor = Agent.harvardInstance();
        Document doc = new Document("Information technology -- ISO 7-bit coded character set for information interchange", DocumentType.STANDARD);
        doc.setPublisher(Agent.newIsoInstance());
        doc.setDate("1991");
        doc.setIdentifier(new Identifier("ISO/IEC 646:1991", IdentifierType.ISO));
        this._specification.add(doc);
        doc = new Document("Information Systems -- Coded Character Sets 7-Bit American National Standard Code for Information Interchange (7-Bit ASCII)", DocumentType.STANDARD);
        Agent.Builder builder = new Agent.Builder("ANSI", AgentType.STANDARD).address("1819 L Street, NW, Washington, DC 20036").telephone("+1 (202) 293-8020").fax("+1 (202) 293-9287").email("info@ansi.org").web("http://www.ansi.org/");
        doc.setPublisher(builder.build());
        doc.setDate("1986-12-30");
        doc.setIdentifier(new Identifier("ANSI X3.4-1986", IdentifierType.ANSI));
        this._specification.add(doc);
        doc = new Document("7-Bit coded Character Set", DocumentType.STANDARD);
        doc.setEdition("6th");
        doc.setDate("1991-12");
        builder = new Agent.Builder("ECMA", AgentType.STANDARD).address("114 Rue du Rhone, CH-1204 Geneva, Switzerland").telephone("+41 22 849.60.00").fax("+41 22 849.60.01").email("helpdesk@ecma.ch").web("http://www.ecma-international.org/");
        doc.setPublisher(builder.build());
        doc.setIdentifier(new Identifier("ECMA-6", IdentifierType.ECMA));
        doc.setIdentifier(new Identifier("http://www.ecma-international.org/publications/files/ecma-st/Ecma-006.pdf", IdentifierType.URL));
        this._specification.add(doc);
    }

    public final int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        Property property;
        this._withTextMD = this.isParamInDefaults("withtextmd=true");
        this.initParse();
        this.initInfo(info);
        ControlChar prevChar = null;
        this.usedCtrlChars = new HashSet<ControlChar>();
        this.usedLineEndings = new HashSet<LineEnding>();
        this._textMD = new TextMDMetadata();
        boolean printableChars = false;
        this.setupDataStream(stream, info);
        boolean eof = false;
        this._nByte = 0L;
        while (!eof) {
            try {
                LineEnding le;
                int ch = AsciiModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                if (ch > 127) {
                    ErrorMessage error = new ErrorMessage(MessageConstants.ASCII_HUL_1, String.format(MessageConstants.ASCII_HUL_1_SUB.getMessage(), Character.valueOf((char)ch), ch), this._nByte - 1L);
                    info.setMessage((Message)error);
                    info.setWellFormed(0);
                    return 0;
                }
                ControlChar ctrlChar = ControlChar.asciiFromInt(ch);
                if (ControlChar.isLineEndChar(ctrlChar)) {
                    le = LineEnding.fromControlChars(ctrlChar, prevChar);
                    if (le != null) {
                        this.usedLineEndings.add(le);
                    }
                } else if (ctrlChar != null) {
                    this.usedCtrlChars.add(ctrlChar);
                } else if (!printableChars) {
                    boolean bl = printableChars = 32 <= ch && ch <= 126;
                }
                if (prevChar == ControlChar.CR && ctrlChar != ControlChar.LF && (le = LineEnding.fromControlChars(ctrlChar, prevChar)) != null) {
                    this.usedLineEndings.add(le);
                }
                prevChar = ctrlChar;
            }
            catch (EOFException e) {
                eof = true;
                LineEnding le = LineEnding.fromControlChars(ControlChar.NUL, prevChar);
                if (le == null) continue;
                this.usedLineEndings.add(le);
            }
        }
        AsciiModule.setChecksums((Checksummer)this._ckSummer, (RepInfo)info);
        if (this._nByte == 0L) {
            info.setMessage((Message)new ErrorMessage(MessageConstants.ASCII_HUL_2));
            info.setWellFormed(0);
            return 0;
        }
        this._textMD.setCharset("US-ASCII");
        this._textMD.setByte_order(this._bigEndian ? 0 : 1);
        this._textMD.setByte_size("8");
        this._textMD.setCharacter_size("1");
        ArrayList<Property> metadataList = new ArrayList<Property>(2);
        List<String> propArray = this.reportLineEndings();
        if (!propArray.isEmpty()) {
            property = new Property("LineEndings", PropertyType.STRING, PropertyArity.LIST, propArray);
            metadataList.add(property);
        }
        if (!this.usedCtrlChars.isEmpty()) {
            LinkedList<String> propList = new LinkedList<String>();
            for (ControlChar ctrlChar : EnumSet.copyOf(this.usedCtrlChars)) {
                propList.add(ctrlChar.mnemonic);
            }
            Property property2 = new Property("ControlCharacters", PropertyType.STRING, PropertyArity.LIST, propList);
            metadataList.add(property2);
        }
        if (this._withTextMD) {
            property = new Property("TextMDMetadata", PropertyType.TEXTMDMETADATA, PropertyArity.SCALAR, (Object)this._textMD);
            metadataList.add(property);
        }
        if (!metadataList.isEmpty()) {
            info.setProperty(new Property("ASCIIMetadata", PropertyType.PROPERTY, PropertyArity.LIST, metadataList));
        }
        if (!printableChars) {
            info.setMessage((Message)new InfoMessage(MessageConstants.ASCII_HUL_3));
        }
        return 0;
    }

    public void checkSignatures(File file, InputStream stream, RepInfo info) throws IOException {
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule((Module)this);
        int sigBytes = this.getBase().getSigBytes();
        int bytesRead = 0;
        boolean eof = false;
        DataInputStream dstream = new DataInputStream(stream);
        while (!eof && bytesRead < sigBytes) {
            try {
                int ch = AsciiModule.readUnsignedByte((DataInputStream)dstream, (ModuleBase)this);
                ++bytesRead;
                if (ch <= 127) continue;
                info.setWellFormed(false);
                return;
            }
            catch (EOFException e) {
                eof = true;
            }
        }
        if (bytesRead == 0) {
            info.setWellFormed(false);
            return;
        }
        info.setSigMatch(this._name);
    }

    private List<String> reportLineEndings() {
        ArrayList<String> retVal = new ArrayList<String>();
        if (!this.usedLineEndings.isEmpty()) {
            for (LineEnding le : EnumSet.copyOf(this.usedLineEndings)) {
                retVal.add(le.toString());
                this._textMD.setLinebreak(le.textMdVal);
            }
        }
        return retVal;
    }
}

