/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.ascii;

import java.util.EnumSet;

public enum ControlChar {
    NUL("NUL", 0, "NULL"),
    SOH("SOH", 1, "START OF HEADING"),
    STX("STX", 2, "START OF TEXT"),
    ETX("ETX", 3, "END OF TEXT"),
    EOT("EOT", 4, "END OF TRANSMISSION"),
    ENQ("ENQ", 5, "ENQUIRY"),
    ACK("ACK", 6, "ACKNOWLEDGE"),
    BEL("BEL", 7, "BELL"),
    BS("BS", 8, "BACKSPACE"),
    HT("HT", 9, "HORIZONTAL TABULATION"),
    LF("LF", 10, "LINE FEED"),
    VT("VT", 11, "VERTICAL TABULATION"),
    FF("FF", 12, "FORM FEED"),
    CR("CR", 13, "CARRIAGE RETURN"),
    SO("SO", 14, "SHIFT-OUT"),
    SI("SI", 15, "SHIFT-IN"),
    DLE("DLE", 16, "DATA LINK ESCAPE"),
    DC1("DC1", 17, "DEVICE CONTROL ONE"),
    DC2("DC2", 18, "DEVICE CONTROL TWO"),
    DC3("DC3", 19, "DEVICE CONTROL THREE"),
    DC4("DC4", 20, "DEVICE CONTROL FOUR"),
    NAK("NAK", 21, "NEGATIVE ACKNOWLEDGE"),
    SYN("SYN", 22, "SYNCHRONOUS IDLE"),
    ETB("ETB", 23, "END OF TRANSMISSION BLOCK"),
    CAN("CAN", 24, "CANCEL"),
    EM("EM", 25, "END OF MEDIUM"),
    SUB("SUB", 26, "SUBSTITUTE CHARACTER"),
    ESC("ESC", 27, "ESCAPE"),
    FS("FS", 28, "FILE SEPARATOR (INFORMATION SEPARATOR FOUR"),
    GS("GS", 29, "GROUP SEPARATOR (INFORMATION SEPARATOR THREE"),
    RS("RS", 30, "RECORD SEPARATOR (INFORMATION SEPARATOR TWO"),
    US("US", 31, "UNIT SEPARATOR (INFORMATION SEPARATOR ONE"),
    DEL("DEL", 127, "DELETE"),
    PAD("PAD", 128, "PADDING CHARACTER"),
    HOP("HOP", 129, "HIGH OCTET PRESET"),
    BPH("BPH", 130, "BREAK PERMITTED HERE"),
    NBH("NBH", 131, "NO BREAK HERE"),
    IND("IND", 132, "INDEX"),
    NEL("NEL", 133, "NEXT LINE"),
    SSA("SSA", 134, "START OF SELECTED AREA"),
    ESA("ESA", 135, "END OF SELECTED AREA"),
    HTS("HTS", 136, "HORIZONTAL TAB SET"),
    HTJ("HTJ", 137, "HORIZONTAL TAB JUSTIFIED"),
    VTS("VTS", 138, "VERTICAL TAB SET"),
    PLD("PLD", 139, "PARTIAL LINE FORWARD"),
    PLU("PLU", 140, "PARTIAL LINE BACKWARD"),
    RI("RI", 141, "REVERSE LINE FEED"),
    SS2("SS2", 142, "SINGLE-SHIFT 2"),
    SS3("SS3", 143, "SINGLE-SHIFT 2"),
    DCS("DCS", 144, "DEVICE CONTROL STRING"),
    PU1("PU1", 145, "PRIVATE USE 1"),
    PU2("PU2", 146, "PRIVATE USE 2"),
    STS("STS", 147, "SET TRANSMIT STATE"),
    CCH("CCH", 148, "CANCEL CHARACTER"),
    MW("MW", 149, "MESSAGE WAITING"),
    SPA("SPA", 150, "START OF PROTECTED AREA"),
    EPA("EPA", 151, "ENDO OF PROTECTED AREA"),
    SOS("SOS", 152, "START OF STRING"),
    SGCI("SCGI", 153, "SINGLE GRAPHIC CHAR INTRO"),
    SCI("SCI", 154, "SINGLE CHAR INTRO"),
    CSI("CSI", 155, "CONTROL SEQUENCE INTRO"),
    ST("ST", 156, "STRING TERMINATOR"),
    OSC("OSC", 157, "OS COMMAND"),
    PM("PM", 158, "PRIVATE MESSAGE"),
    APC("APC", 159, "APP PROGRAM COMMAND");

    public static final String PROP_NAME = "ControlCharacters";
    public static final EnumSet<ControlChar> ASCII;
    public static final EnumSet<ControlChar> UNICODE_EXTENSIONS;
    public static final EnumSet<ControlChar> UNICODE;
    public final String code;
    public final int value;
    public final String ansiName;
    public final String mnemonic;

    private ControlChar(String code, int value, String ansiName) {
        this.code = code;
        this.value = value;
        this.ansiName = ansiName;
        this.mnemonic = String.format("%s (0x%02X)", code, value);
    }

    public static final boolean isLineEndChar(ControlChar toTest) {
        return toTest == CR || toTest == LF;
    }

    public static final ControlChar asciiFromInt(int charVal) {
        if (charVal > ControlChar.US.value) {
            return charVal == ControlChar.DEL.value ? DEL : null;
        }
        for (ControlChar ctrlChar : ControlChar.values()) {
            if (ctrlChar.value != charVal) continue;
            return ctrlChar;
        }
        return null;
    }

    public static final ControlChar fromMnemonic(String mnemonic) {
        for (ControlChar ctrlChar : ControlChar.values()) {
            if (!ctrlChar.mnemonic.equalsIgnoreCase(mnemonic)) continue;
            return ctrlChar;
        }
        return null;
    }

    static {
        ASCII = EnumSet.range(NUL, DEL);
        UNICODE_EXTENSIONS = EnumSet.complementOf(ASCII);
        UNICODE = EnumSet.allOf(ControlChar.class);
    }
}

