/*
 * Decompiled with CFR 0.152.
 */
import edu.harvard.hul.ois.jhove.Dump;
import edu.harvard.hul.ois.jhove.ModuleBase;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class GDump
extends Dump {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: java GDump file");
            System.exit(-1);
        }
        try (FileInputStream file = new FileInputStream(args[0]);
             BufferedInputStream buffer = new BufferedInputStream(file);
             DataInputStream stream = new DataInputStream(buffer);){
            boolean bigEndian = false;
            String signature = GDump.readChars((DataInputStream)stream, (int)3);
            String version = GDump.readChars((DataInputStream)stream, (int)3);
            System.out.println("00000000: \"" + signature + version + "\"");
            int width = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
            int height = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
            int packedFields = stream.readUnsignedByte();
            int backgroundColor = stream.readUnsignedByte();
            int aspectRatio = stream.readUnsignedByte();
            System.out.println("00000006: LogicalScreenDescriptor: " + width + "x" + height + " 0x" + GDump.leading((int)packedFields, (int)2) + Integer.toHexString(packedFields) + " " + backgroundColor + " " + aspectRatio);
            long os = 13L;
            boolean globalColorTable = (packedFields & 0x80) != 0;
            int globalColorTableSize = packedFields & 7;
            if (globalColorTable) {
                System.out.println(GDump.leading((long)os, (int)8) + os + ": GlobalColorTable:");
                os = GDump.colorTable(stream, os, globalColorTableSize);
            }
            int op = 0;
            while ((op = stream.readUnsignedByte()) != -1) {
                if (op == 0) {
                    System.out.println(GDump.leading((long)os, (int)8) + os + ": BlockTerminator");
                    ++os;
                    continue;
                }
                if (op == 44) {
                    int imageLeft = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                    int imageTop = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                    int imageWidth = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                    int imageHeight = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                    packedFields = stream.readUnsignedByte();
                    System.out.println(GDump.leading((long)os, (int)8) + os + ": ImageDescriptor: " + imageLeft + "," + imageTop + " " + imageWidth + "x" + imageHeight + " 0x" + GDump.leading((int)packedFields, (int)2) + Integer.toHexString(packedFields));
                    os += 10L;
                    boolean localColorTable = (packedFields & 0x80) != 0;
                    int localColorTableSize = packedFields & 7;
                    if (localColorTable) {
                        System.out.println(GDump.leading((long)os, (int)8) + os + ": LocalColorTable:");
                        os = GDump.colorTable(stream, os, localColorTableSize);
                    }
                    int size = stream.readUnsignedByte();
                    System.out.println(GDump.leading((long)os, (int)8) + os + ": ImageData: " + size);
                    ++os;
                    os = GDump.subBlocks(stream, os);
                    continue;
                }
                if (op == 33) {
                    int blockSize;
                    int label = stream.readUnsignedByte();
                    if (label == 1) {
                        blockSize = stream.readUnsignedByte();
                        int gridLeft = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                        int gridTop = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                        int gridWidth = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                        int gridHeight = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                        int cellWidth = stream.readUnsignedByte();
                        int cellHeight = stream.readUnsignedByte();
                        int foreground = stream.readUnsignedByte();
                        int background = stream.readUnsignedByte();
                        System.out.println(GDump.leading((long)os, (int)8) + os + ": PlainTextExtension: " + blockSize + " " + gridLeft + "," + gridTop + " " + gridWidth + "x" + gridHeight + " " + cellWidth + "x" + cellHeight + " " + foreground + "," + background);
                        os += 15L;
                        os = GDump.subBlocks(stream, os);
                        continue;
                    }
                    if (label == 249) {
                        blockSize = stream.readUnsignedByte();
                        packedFields = stream.readUnsignedByte();
                        int delayTime = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)bigEndian, null);
                        int colorIndex = stream.readUnsignedByte();
                        System.out.println(GDump.leading((long)os, (int)8) + os + ": GraphicControlExtension: " + blockSize + " 0x" + GDump.leading((int)packedFields, (int)2) + packedFields + " " + delayTime + " " + colorIndex);
                        os += 7L;
                        continue;
                    }
                    if (label == 254) {
                        System.out.println(GDump.leading((long)os, (int)8) + os + ": CommentExtension: \"\"");
                        os += 2L;
                        os = GDump.subBlocks(stream, os);
                        continue;
                    }
                    if (label == 255) {
                        blockSize = stream.readUnsignedByte();
                        String appId = GDump.readChars((DataInputStream)stream, (int)8);
                        int[] authCode = new int[]{stream.readUnsignedByte(), stream.readUnsignedByte(), stream.readUnsignedByte()};
                        System.out.println(GDump.leading((long)os, (int)8) + os + ": ApplicationExtension: " + blockSize + " \"" + appId + "\" " + authCode[0] + "," + authCode[1] + "," + authCode[2]);
                        os += 14L;
                        os = GDump.subBlocks(stream, os);
                        continue;
                    }
                    String hex = Integer.toHexString(label);
                    System.out.println(GDump.leading((long)(os - 1L), (int)8) + (os - 1L) + ": Unknown extension block: 0x" + GDump.leading((String)hex, (int)2) + hex);
                    os += 2L;
                    continue;
                }
                if (op == 59) {
                    System.out.println(GDump.leading((long)os, (int)8) + os + ": Trailer: 0x3b");
                    ++os;
                    break;
                }
                String hex = Integer.toHexString(op);
                System.out.println(GDump.leading((long)os, (int)8) + os + ": Unknown block: 0x" + GDump.leading((String)hex, (int)2) + hex);
                ++os;
            }
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(-2);
        }
    }

    private static long colorTable(DataInputStream stream, long os, int size) throws IOException {
        int n = 2 << size;
        for (int i = 0; i < n; ++i) {
            long r = stream.readUnsignedByte();
            long g = stream.readUnsignedByte();
            long b = stream.readUnsignedByte();
            System.out.println(GDump.leading((long)os, (int)8) + os + ": " + GDump.leading((int)i, (int)3, (char)' ') + i + ": " + GDump.leading((long)r, (int)3, (char)' ') + r + "," + GDump.leading((long)g, (int)3, (char)' ') + g + "," + GDump.leading((long)b, (int)3, (char)' ') + b);
            os += 3L;
        }
        return os;
    }

    private static long subBlocks(DataInputStream stream, long os) throws IOException {
        int size;
        while ((size = stream.readUnsignedByte()) != 0) {
            System.out.println(GDump.leading((long)os, (int)8) + os + ": SubBlock: " + size);
            ++os;
            for (int i = 0; i < size; ++i) {
                stream.readUnsignedByte();
                ++os;
            }
        }
        System.out.println(GDump.leading((long)os, (int)8) + os + ": BlockTerminator");
        return os + 1L;
    }
}

