package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessageFactory;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;

/**
 * Enum used to externalise the XML module message Strings. Using an enum
 * INSTANCE as a "trick" to ensure a single instance of the class. String
 * constants should be prefixed according to their use in the module:
 * <ul>
 * <li>WRN_ for warning strings, often logger messages.</li>
 * <li>INF_ for informational messages.</li>
 * <li>ERR_ for error messages that indicate a file is invalid or not well
 * formed.</li>
 * </ul>
 * When adding new messages try to adopt the following order for the naming
 * elements:
 * <ol>
 * <li>PREFIX: one of the three prefixes from the list above.</li>
 * <li>ENTITY_NAME: the name of the entity causing the problem.</li>
 * <li>Problem: a short indicator of the problem type, e.g. MISSING, ILLEGAL,
 * etc.</li>
 * </ol>
 * The elements should be separated by underscores. The messages currently don't
 * follow a consistent vocabulary, that is terms such as invalid, illegal, or
 * malformed are used without definition.
 *
 * @author Thomas Ledoux
 * 
 */

public enum MessageConstants {
	INSTANCE;
	public static final JhoveMessageFactory messageFactory = JhoveMessages
			.getInstance("edu.harvard.hul.ois.jhove.module.html.ErrorMessages");

	// From ParseHtml (beware file ParseHtml.java is derived from
	// ParseHtml.jj...)

	// The "Missing return statement in function" message is generated by jacacc
	// !!!
	// should never occur once the parser is correct...
	// public static final String WRN_INCORRECT_AUTO_CLOSED_TAG = "Construction
	// with \"/>\" is incorrect except in XHTML";
	public static final String INF_HTML_VER_UNSPPRTD = "This HTML version is currently not supported, falling back to HTML 3.2";
	public static final String INF_EOL_TYPE_UNDET = "Not able to determine type of end of line";

	public static final JhoveMessage HTML_HUL_1 = messageFactory.getMessage("HTML-HUL-1");
	public static final JhoveMessage HTML_HUL_2 = messageFactory.getMessage("HTML-HUL-2");
	public static final JhoveMessage HTML_HUL_3 = messageFactory.getMessage("HTML-HUL-3");
	public static final JhoveMessage HTML_HUL_4 = messageFactory.getMessage("HTML-HUL-4");
	public static final JhoveMessage HTML_HUL_5 = messageFactory.getMessage("HTML-HUL-5");
	public static final JhoveMessage HTML_HUL_6 = messageFactory.getMessage("HTML-HUL-6");
	public static final JhoveMessage HTML_HUL_7 = messageFactory.getMessage("HTML-HUL-7");
	public static final JhoveMessage HTML_HUL_8 = messageFactory.getMessage("HTML-HUL-8");
	public static final JhoveMessage HTML_HUL_9 = messageFactory.getMessage("HTML-HUL-9");
	public static final JhoveMessage HTML_HUL_10 = messageFactory.getMessage("HTML-HUL-10");
	public static final JhoveMessage HTML_HUL_11 = messageFactory.getMessage("HTML-HUL-11");
	public static final JhoveMessage HTML_HUL_12 = messageFactory.getMessage("HTML-HUL-12");
	public static final JhoveMessage HTML_HUL_13 = messageFactory.getMessage("HTML-HUL-13");
	public static final JhoveMessage HTML_HUL_14 = messageFactory.getMessage("HTML-HUL-14");
	public static final JhoveMessage HTML_HUL_15 = messageFactory.getMessage("HTML-HUL-15");
	public static final JhoveMessage HTML_HUL_16 = messageFactory.getMessage("HTML-HUL-16");
	public static final JhoveMessage HTML_HUL_17 = messageFactory.getMessage("HTML-HUL-17");
	public static final JhoveMessage HTML_HUL_18 = messageFactory.getMessage("HTML-HUL-18");
	// From TokenMgrError
	public static final JhoveMessage HTML_HUL_19 = messageFactory.getMessage("HTML-HUL-19");
	public static final JhoveMessage HTML_HUL_20 = messageFactory.getMessage("HTML-HUL-20");
	public static final JhoveMessage HTML_HUL_21 = messageFactory.getMessage("HTML-HUL-21");

	public static final JhoveMessage JHOVE_1 = messageFactory.getMessage("JHOVE-1");
	public static final JhoveMessage JHOVE_2 = messageFactory.getMessage("JHOVE-2");
	public static final JhoveMessage JHOVE_3 = messageFactory.getMessage("JHOVE-3");
}
