/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.module.html.Html4DocDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlAttributeDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlSpecialToken;
import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Html4TFDocDesc
extends Html4DocDesc {
    protected Html4TFDocDesc() {
    }

    protected static void classInit4(Map stSupportedElements) {
        Html4DocDesc.classInit4(stSupportedElements);
        fontMarkup = new String[]{"tt", "i", "b", "u", "s", "strike", "big", "small"};
        listMarkup = new String[]{"ul", "ol", "dir", "menu"};
        specialMarkup = new String[]{"a", "img", "applet", "object", "font", "basefont", "br", "script", "map", "q", "sub", "sup", "span", "bdo", "iframe"};
        inlineContent = new ArrayList(35);
        Html4TFDocDesc.addStringsToList(fontMarkup, inlineContent);
        Html4TFDocDesc.addStringsToList(phraseMarkup, inlineContent);
        Html4TFDocDesc.addStringsToList(specialMarkup, inlineContent);
        Html4TFDocDesc.addStringsToList(formMarkup, inlineContent);
        inlineContent.add(HtmlSpecialToken.PCDATA);
        blockContent = new ArrayList(20);
        Html4TFDocDesc.addStringsToList(headings, blockContent);
        Html4TFDocDesc.addStringsToList(listMarkup, blockContent);
        String[] blockMisc = new String[]{"p", "pre", "dl", "div", "center", "noscript", "blockquote", "form", "hr", "table", "fieldset", "address"};
        Html4TFDocDesc.addStringsToList(blockMisc, blockContent);
        flowContent = new ArrayList(30);
        flowContent.addAll(blockContent);
        flowContent.addAll(inlineContent);
        bodyContent = new ArrayList(flowContent.size() + 3);
        bodyContent.addAll(flowContent);
        bodyContent.add("ins");
        bodyContent.add("del");
        listContent = new ArrayList(1);
        listContent.add("li");
        thtdAtts = new ArrayList(bigAttrs.size() + 7);
        thtdAtts.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "abbr");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "axis");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "headers");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "scope");
        thtdAtts.add(halignAtt);
        thtdAtts.add(valignAtt);
        Html4TFDocDesc.addSelfAttribute(thtdAtts, "nowrap");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "rowspan");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "colspan");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "bgcolor");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "width");
        Html4TFDocDesc.addSimpleAttribute(thtdAtts, "height");
    }

    protected static void addAElement(Map stSupportedElements) {
        String name = "a";
        ArrayList atts = new ArrayList(bigAttrs.size() + 14);
        atts.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(atts, "type");
        Html4TFDocDesc.addSimpleAttribute(atts, "name");
        Html4TFDocDesc.addSimpleAttribute(atts, "href");
        Html4TFDocDesc.addSimpleAttribute(atts, "hreflang");
        Html4TFDocDesc.addSimpleAttribute(atts, "target");
        Html4TFDocDesc.addSimpleAttribute(atts, "rel");
        Html4TFDocDesc.addSimpleAttribute(atts, "rev");
        Html4TFDocDesc.addSimpleAttribute(atts, "accesskey");
        Html4TFDocDesc.addSimpleAttribute(atts, "shape");
        Html4TFDocDesc.addSimpleAttribute(atts, "rect");
        Html4TFDocDesc.addSimpleAttribute(atts, "coords");
        Html4TFDocDesc.addSimpleAttribute(atts, "tabindex");
        Html4TFDocDesc.addSimpleAttribute(atts, "onfocus");
        Html4TFDocDesc.addSimpleAttribute(atts, "onblur");
        ArrayList content = new ArrayList(inlineContent.size());
        content.addAll(inlineContent);
        content.remove("a");
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, content, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addAppletElement(Map stSupportedElements, HtmlAttributeDesc ialignAtt) {
        String name = "applet";
        ArrayList<String> content = new ArrayList<String>(flowContent.size());
        content.addAll(flowContent);
        content.add("param");
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(9);
        Html4TFDocDesc.addSimpleAttribute(atts, "codebase");
        Html4TFDocDesc.addSimpleAttribute(atts, "archive");
        Html4TFDocDesc.addSimpleAttribute(atts, "code");
        Html4TFDocDesc.addSimpleAttribute(atts, "object");
        Html4TFDocDesc.addSimpleAttribute(atts, "alt");
        Html4TFDocDesc.addSimpleAttribute(atts, "alt");
        Html4TFDocDesc.addSimpleAttribute(atts, "name");
        Html4TFDocDesc.addRequiredAttribute(atts, "width");
        Html4TFDocDesc.addRequiredAttribute(atts, "height");
        atts.add(ialignAtt);
        Html4TFDocDesc.addSimpleAttribute(atts, "hspace");
        Html4TFDocDesc.addSimpleAttribute(atts, "vspace");
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, content, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addAreaElement(Map stSupportedElements, HtmlAttributeDesc shapeAtt) {
        String name = "area";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(10);
        atts.add(shapeAtt);
        Html4TFDocDesc.addSimpleAttribute(atts, "coords");
        Html4TFDocDesc.addSimpleAttribute(atts, "href");
        Html4TFDocDesc.addSimpleAttribute(atts, "target");
        atts.add(new HtmlAttributeDesc("nohref", new String[]{"nohref"}, 4));
        atts.add(new HtmlAttributeDesc("alt", null, 1));
        Html4TFDocDesc.addSimpleAttribute(atts, "tabindex");
        Html4TFDocDesc.addSimpleAttribute(atts, "accesskey");
        Html4TFDocDesc.addSimpleAttribute(atts, "onfocus");
        Html4TFDocDesc.addSimpleAttribute(atts, "onblur");
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addBaseElement(Map stSupportedElements) {
        String name = "base";
        ArrayList atts = new ArrayList(2);
        Html4TFDocDesc.addSimpleAttribute(atts, "href");
        Html4TFDocDesc.addSimpleAttribute(atts, "target");
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addBasefontElement(Map stSupportedElements) {
        String name = "basefont";
        ArrayList atts = new ArrayList(4);
        Html4TFDocDesc.addSimpleAttribute(atts, "id");
        Html4TFDocDesc.addSimpleAttribute(atts, "size");
        Html4TFDocDesc.addSimpleAttribute(atts, "color");
        Html4TFDocDesc.addSimpleAttribute(atts, "face");
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addBlockquoteElement(Map stSupportedElements) {
        String name = "blockquote";
        ArrayList<String> content = new ArrayList<String>(blockContent.size() + 1);
        content.addAll(blockContent);
        content.add("script");
        ArrayList atts = new ArrayList(bigAttrs.size() + 1);
        atts.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(atts, "cite");
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, flowContent, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addBrElement(Map stSupportedElements, List coreAttrs) {
        String name = "br";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(coreAttrs.size() + 1);
        atts.addAll(coreAttrs);
        atts.add(new HtmlAttributeDesc("clear", new String[]{"left", "all", "right", "none"}, 5));
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addButtonElement(Map stSupportedElements) {
        String name = "button";
        ArrayList<String> content = new ArrayList<String>(formMarkup.length + 3);
        Html4TFDocDesc.addStringsToList(formMarkup, content);
        content.add("form");
        content.add("isindex");
        content.add("fieldset");
        content.add("iframe");
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(biggerAttrs.size() + 8);
        atts.addAll(biggerAttrs);
        Html4TFDocDesc.addSimpleAttribute(atts, "name");
        Html4TFDocDesc.addSimpleAttribute(atts, "value");
        atts.add(new HtmlAttributeDesc("type", new String[]{"button", "submit", "reset"}, 5));
        Html4TFDocDesc.addSelfAttribute(atts, "disabled");
        Html4TFDocDesc.addSimpleAttribute(atts, "tabindex");
        Html4TFDocDesc.addSimpleAttribute(atts, "accesskey");
        Html4TFDocDesc.addSimpleAttribute(atts, "onfocus");
        Html4TFDocDesc.addSimpleAttribute(atts, "onblur");
    }

    protected static void addCaptionElement(Map stSupportedElements, List inlineContent, HtmlAttributeDesc valignAtt) {
        String name = "caption";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 1);
        atts.add(new HtmlAttributeDesc("align", new String[]{"top", "bottom", "left", "right"}, 4));
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, inlineContent, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addCenterElement(Map stSupportedElements) {
        String name = "center";
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, flowContent, bigAttrs);
        stSupportedElements.put(name, td);
    }

    protected static void addDirElement(Map stSupportedElements) {
        String name = "dir";
        ArrayList atts = new ArrayList(1);
        Html4TFDocDesc.addSelfAttribute(atts, "compact");
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, listContent, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addDivElement(Map stSupportedElements) {
        String name = "div";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 1);
        atts.addAll(bigAttrs);
        atts.add(new HtmlAttributeDesc("align", new String[]{"left", "center", "right", "justify"}, 4));
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, flowContent, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addDlElement(Map stSupportedElements) {
        String name = "dl";
        ArrayList dlContent = new ArrayList(2);
        Html4TFDocDesc.addStringsToList(new String[]{"dt", "dd"}, dlContent);
        ArrayList atts = new ArrayList(bigAttrs.size() + 1);
        Html4TFDocDesc.addSelfAttribute(atts, "compact");
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, dlContent, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addFontElement(Map stSupportedElements) {
        String name = "font";
        ArrayList atts = new ArrayList(bigAttrs.size() + 10);
        atts.addAll(bigAttrs);
        atts.addAll(i18nAttrs);
        Html4TFDocDesc.addSimpleAttribute(atts, "size");
        Html4TFDocDesc.addSimpleAttribute(atts, "color");
        Html4TFDocDesc.addSimpleAttribute(atts, "face");
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, inlineContent, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addFrameElement(Map stSupportedElements) {
        String name = "frame";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 8);
        atts.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(atts, "longdesc");
        Html4TFDocDesc.addSimpleAttribute(atts, "name");
        Html4TFDocDesc.addSimpleAttribute(atts, "src");
        Html4TFDocDesc.addSimpleAttribute(atts, "marginwidth");
        Html4TFDocDesc.addSimpleAttribute(atts, "marginheight");
        Html4TFDocDesc.addSelfAttribute(atts, "noresize");
        atts.add(new HtmlAttributeDesc("scrolling", new String[]{"yes", "no", "auto"}, 5));
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addFramesetElement(Map stSupportedElements) {
        String name = "frameset";
        ArrayList content = new ArrayList(3);
        Html4TFDocDesc.addStringsToList(new String[]{"frameset", "frame", "noframes"}, content);
        ArrayList atts = new ArrayList(coreAttrs.size() + 4);
        atts.addAll(coreAttrs);
        Html4TFDocDesc.addSimpleAttribute(atts, "rows");
        Html4TFDocDesc.addSimpleAttribute(atts, "cols");
        Html4TFDocDesc.addSimpleAttribute(atts, "onload");
        Html4TFDocDesc.addSimpleAttribute(atts, "onunload");
        HtmlTagDesc td = new HtmlTagDesc(name, false, false, content, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addHeadElement(Map stSupportedElements) {
        String name = "head";
        String[] headMisc = new String[]{"script", "style", "meta", "link"};
        ArrayList<String> headContent = new ArrayList<String>(7);
        headContent.add("title");
        headContent.add("isindex");
        headContent.add("base");
        headContent.add("script");
        headContent.add("style");
        headContent.add("meta");
        headContent.add("link");
        headContent.add("object");
        HtmlTagDesc td = new HtmlTagDesc(name, false, false, headContent, null);
        stSupportedElements.put(name, td);
        Html4TFDocDesc.addStringsToList(headMisc, headContent);
    }

    protected static void addHrElement(Map stSupportedElements) {
        String name = "hr";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 4);
        atts.add(new HtmlAttributeDesc("align", new String[]{"left", "center", "right"}, 4));
        Html4TFDocDesc.addSelfAttribute(atts, "noshade");
        Html4TFDocDesc.addSimpleAttribute(atts, "size");
        Html4TFDocDesc.addSimpleAttribute(atts, "width");
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addInputElement(Map stSupportedElements) {
        String name = "input";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(biggerAttrs.size() + 20);
        atts.addAll(biggerAttrs);
        atts.add(new HtmlAttributeDesc("type", new String[]{"text", "password", "checkbox", "radio", "submit", "reset", "file", "hidden", "image", "button"}, 5));
        Html4TFDocDesc.addSimpleAttribute(atts, "name");
        Html4TFDocDesc.addSimpleAttribute(atts, "value");
        Html4TFDocDesc.addSelfAttribute(atts, "checked");
        Html4TFDocDesc.addSelfAttribute(atts, "disabled");
        Html4TFDocDesc.addSelfAttribute(atts, "readonly");
        Html4TFDocDesc.addSimpleAttribute(atts, "size");
        Html4TFDocDesc.addSimpleAttribute(atts, "maxlength");
        Html4TFDocDesc.addSimpleAttribute(atts, "src");
        Html4TFDocDesc.addSimpleAttribute(atts, "alt");
        Html4TFDocDesc.addSimpleAttribute(atts, "usemap");
        Html4TFDocDesc.addSimpleAttribute(atts, "tabindex");
        Html4TFDocDesc.addSimpleAttribute(atts, "accesskey");
        Html4TFDocDesc.addSimpleAttribute(atts, "onfocus");
        Html4TFDocDesc.addSimpleAttribute(atts, "onblur");
        Html4TFDocDesc.addSimpleAttribute(atts, "onselect");
        Html4TFDocDesc.addSimpleAttribute(atts, "onchange");
        Html4TFDocDesc.addSimpleAttribute(atts, "accept");
        atts.add(new HtmlAttributeDesc("align", new String[]{"top", "middle", "bottom", "left", "right"}, 4));
        HtmlTagDesc td = new HtmlTagDesc("input", true, true, null, atts);
        stSupportedElements.put("input", td);
    }

    protected static void addLegendElement(Map stSupportedElements) {
        String name = "label";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 2);
        atts.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(atts, "accesskey");
        atts.add(new HtmlAttributeDesc("align", new String[]{"top", "left", "bottom", "right"}, 4));
        HtmlTagDesc td = new HtmlTagDesc("label", true, true, inlineContent, atts);
        stSupportedElements.put("label", td);
    }

    protected static void addLiElement(Map stSupportedElements) {
        String name = "li";
        ArrayList atts = new ArrayList(bigAttrs.size() + 2);
        atts.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(atts, "type");
        Html4TFDocDesc.addSimpleAttribute(atts, "value");
        HtmlTagDesc td = new HtmlTagDesc("li", true, false, flowContent, atts);
        stSupportedElements.put("li", td);
    }

    protected static void addLinkElement(Map stSupportedElements) {
        String name = "link";
        ArrayList atts = new ArrayList(bigAttrs.size() + 8);
        atts.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(atts, "charset");
        Html4TFDocDesc.addSimpleAttribute(atts, "href");
        Html4TFDocDesc.addSimpleAttribute(atts, "hreflang");
        Html4TFDocDesc.addSimpleAttribute(atts, "type");
        Html4TFDocDesc.addSimpleAttribute(atts, "rel");
        Html4TFDocDesc.addSimpleAttribute(atts, "rev");
        Html4TFDocDesc.addSimpleAttribute(atts, "media");
        Html4TFDocDesc.addSimpleAttribute(atts, "target");
        HtmlTagDesc td = new HtmlTagDesc("link", true, false, null, atts);
        stSupportedElements.put("link", td);
    }

    protected static void addMenuElement(Map stSupportedElements) {
        String name = "menu";
        ArrayList atts = new ArrayList(1);
        Html4TFDocDesc.addSelfAttribute(atts, "compact");
        HtmlTagDesc td = new HtmlTagDesc("menu", true, true, listContent, atts);
        stSupportedElements.put("menu", td);
    }

    protected static void addNoframesElement(Map stSupportedElements, int version) {
        ArrayList<String> content;
        String name = "noframes";
        if (version == 6 || version == 3) {
            content = new ArrayList<String>(1);
            content.add("body");
        } else {
            content = flowContent;
        }
        HtmlTagDesc td = new HtmlTagDesc("noframes", true, true, content, bigAttrs);
        stSupportedElements.put("noframes", td);
    }

    protected static void addNoscriptElement(Map stSupportedElements) {
        String name = "noscript";
        HtmlTagDesc td = new HtmlTagDesc("noscript", true, false, flowContent, bigAttrs);
        stSupportedElements.put("noscript", td);
    }

    protected static void addObjectElement(Map stSupportedElements) {
        String name = "object";
        ArrayList atts = new ArrayList(biggerAttrs.size() + 13);
        atts.addAll(biggerAttrs);
        Html4TFDocDesc.addSelfAttribute(atts, "declare");
        Html4TFDocDesc.addSimpleAttribute(atts, "classid");
        Html4TFDocDesc.addSimpleAttribute(atts, "codebase");
        Html4TFDocDesc.addSimpleAttribute(atts, "data");
        Html4TFDocDesc.addSimpleAttribute(atts, "type");
        Html4TFDocDesc.addSimpleAttribute(atts, "codetype");
        Html4TFDocDesc.addSimpleAttribute(atts, "archive");
        Html4TFDocDesc.addSimpleAttribute(atts, "standby");
        Html4TFDocDesc.addSimpleAttribute(atts, "height");
        Html4TFDocDesc.addSimpleAttribute(atts, "width");
        Html4TFDocDesc.addSimpleAttribute(atts, "usemap");
        Html4TFDocDesc.addSimpleAttribute(atts, "name");
        Html4TFDocDesc.addSimpleAttribute(atts, "tabindex");
        Html4TFDocDesc.addSimpleAttribute(atts, "align");
        Html4TFDocDesc.addSimpleAttribute(atts, "border");
        Html4TFDocDesc.addSimpleAttribute(atts, "hspace");
        Html4TFDocDesc.addSimpleAttribute(atts, "vspace");
    }

    protected static void addOlElement(Map stSupportedElements) {
        String name = "ol";
        ArrayList atts = new ArrayList(bigAttrs.size() + 3);
        atts.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(atts, "type");
        Html4TFDocDesc.addSelfAttribute(atts, "compact");
        Html4TFDocDesc.addSimpleAttribute(atts, "start");
        HtmlTagDesc td = new HtmlTagDesc("ol", true, true, listContent, atts);
        stSupportedElements.put("ol", td);
    }

    protected static void addPElement(Map stSupportedElements) {
        String name = "p";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 1);
        atts.addAll(bigAttrs);
        atts.add(new HtmlAttributeDesc("align", new String[]{"left", "center", "right", "justify"}, 4));
        HtmlTagDesc td = new HtmlTagDesc("p", true, false, inlineContent, atts);
        stSupportedElements.put("p", td);
    }

    protected static void addPreElement(Map stSupportedElements) {
        String name = "pre";
        ArrayList preContent = new ArrayList(inlineContent.size());
        preContent.addAll(inlineContent);
        Html4TFDocDesc.removeStringsFromList(preContent, new String[]{"img", "object", "big", "small", "sub", "sup"});
        ArrayList atts = new ArrayList(bigAttrs.size() + 1);
        atts.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(atts, "width");
        HtmlTagDesc td = new HtmlTagDesc("pre", true, true, preContent, atts);
        stSupportedElements.put("pre", td);
    }

    protected static void addScriptElement(Map stSupportedElements) {
        String name = "script";
        ArrayList<HtmlSpecialToken> content = new ArrayList<HtmlSpecialToken>(1);
        content.add(HtmlSpecialToken.PCDATA);
        ArrayList atts = new ArrayList(6);
        Html4TFDocDesc.addSimpleAttribute(atts, "charset");
        Html4TFDocDesc.addSimpleAttribute(atts, "type");
        Html4TFDocDesc.addSimpleAttribute(atts, "language");
        Html4TFDocDesc.addSimpleAttribute(atts, "src");
        Html4TFDocDesc.addSelfAttribute(atts, "defer");
        Html4TFDocDesc.addSimpleAttribute(atts, "event");
        Html4TFDocDesc.addSimpleAttribute(atts, "for");
        HtmlTagDesc td = new HtmlTagDesc("script", true, true, content, atts);
        stSupportedElements.put("script", td);
    }

    protected static void addTableElement(Map stSupportedElements) {
        String name = "table";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(biggerAttrs.size() + 10);
        atts.addAll(biggerAttrs);
        Html4TFDocDesc.addSimpleAttribute(atts, "summary");
        Html4TFDocDesc.addSimpleAttribute(atts, "width");
        Html4TFDocDesc.addSimpleAttribute(atts, "border");
        atts.add(new HtmlAttributeDesc("frame", new String[]{"void", "above", "below", "hsides", "lhs", "rhs", "vsides", "box", "border"}, 4));
        atts.add(new HtmlAttributeDesc("rules", new String[]{"none", "groups", "rows", "cols", "all"}, 4));
        Html4TFDocDesc.addSimpleAttribute(atts, "rules");
        Html4TFDocDesc.addSimpleAttribute(atts, "cellspacing");
        Html4TFDocDesc.addSimpleAttribute(atts, "cellpadding");
        atts.add(new HtmlAttributeDesc("align", new String[]{"left", "center", "right"}, 4));
        Html4TFDocDesc.addSimpleAttribute(atts, "bgcolor");
        Html4TFDocDesc.addSimpleAttribute(atts, "datapagesize");
        List[] contentArray = new List[5];
        int[] contentSequence = new int[]{0, 3, 0, 0, 2};
        ArrayList<String> content = new ArrayList<String>(1);
        content.add("caption");
        contentArray[0] = content;
        content = new ArrayList(2);
        content.add("col");
        content.add("colgroup");
        contentArray[1] = content;
        content = new ArrayList(1);
        content.add("thead");
        contentArray[2] = content;
        content = new ArrayList(1);
        content.add("tfoot");
        contentArray[3] = content;
        content = new ArrayList(1);
        content.add("tbody");
        contentArray[4] = content;
        HtmlTagDesc td = new HtmlTagDesc("table", true, true, contentSequence, contentArray, atts);
        stSupportedElements.put("table", td);
    }

    protected static void addTrElement(Map stSupportedElements) {
        String name = "tr";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 3);
        atts.addAll(bigAttrs);
        atts.add(halignAtt);
        atts.add(valignAtt);
        Html4TFDocDesc.addSimpleAttribute(atts, "bgcolor");
        ArrayList<String> content = new ArrayList<String>(2);
        content.add("th");
        content.add("td");
        HtmlTagDesc td = new HtmlTagDesc("tr", true, false, content, atts);
        td.addImplicitContainer((HtmlTagDesc)stSupportedElements.get("tbody"));
        stSupportedElements.put("tr", td);
    }

    protected static void addUlElement(Map stSupportedElements) {
        String name = "ul";
        ArrayList atts = new ArrayList(bigAttrs.size() + 2);
        atts.addAll(bigAttrs);
        Html4TFDocDesc.addSimpleAttribute(atts, "type");
        Html4TFDocDesc.addSelfAttribute(atts, "compact");
        HtmlTagDesc td = new HtmlTagDesc("ul", true, true, listContent, atts);
        stSupportedElements.put("ul", td);
    }
}

