/*
 * Decompiled with CFR 0.152.
 */
import edu.harvard.hul.ois.jhove.Dump;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffTags;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class TDump
extends Dump {
    private static int _nIFDs;
    private static Map<String, String> _tags;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: java TDump [-bs] file");
            System.exit(-1);
        }
        String tiff = null;
        boolean nobyte = false;
        boolean nosub = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-b")) {
                nobyte = true;
                continue;
            }
            if (args[i].equals("-s")) {
                nosub = true;
                continue;
            }
            if (tiff != null) continue;
            tiff = args[i];
        }
        _tags = new TreeMap<String, String>();
        int err = 0;
        try (RandomAccessFile file = new RandomAccessFile(tiff, "r");){
            boolean bigEndian = true;
            int b1 = ModuleBase.readUnsignedByte((RandomAccessFile)file);
            int b2 = ModuleBase.readUnsignedByte((RandomAccessFile)file);
            if (b1 == 73 && b2 == b1) {
                bigEndian = false;
            }
            int magic = ModuleBase.readUnsignedShort((RandomAccessFile)file, (boolean)bigEndian);
            long offset = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
            _tags.put("00000000", "\"" + (char)b1 + (char)b2 + "\" (" + (bigEndian ? "big" : "little") + " endian) " + magic + " LONG @" + offset);
            _nIFDs = 0;
            while ((offset = TDump.readIFD(file, bigEndian, offset, nobyte, nosub)) > 0L) {
            }
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            err = -2;
        }
        finally {
            for (String os : _tags.keySet()) {
                System.out.println(os + ": " + _tags.get(os));
            }
            if (err != 0) {
                System.exit(err);
            }
        }
    }

    private static long readIFD(RandomAccessFile file, boolean bigEndian, long offset, boolean nobyte, boolean nosub) throws Exception {
        long os;
        int i;
        int nIFD = ++_nIFDs;
        ArrayList<Long> subIFDs = new ArrayList<Long>();
        ArrayList<Long> stripByteCounts = new ArrayList<Long>();
        ArrayList<Long> stripOffsets = new ArrayList<Long>();
        file.seek(offset);
        int nEntries = ModuleBase.readUnsignedShort((RandomAccessFile)file, (boolean)bigEndian);
        _tags.put(TDump.leading((long)offset, (int)8) + offset, "IFD " + nIFD + " with " + nEntries + " entries");
        for (i = 0; i < nEntries; ++i) {
            int sh;
            long denom;
            int j;
            os = offset + 2L + (long)(i * 12);
            file.seek(os);
            int tag = ModuleBase.readUnsignedShort((RandomAccessFile)file, (boolean)bigEndian);
            int type = ModuleBase.readUnsignedShort((RandomAccessFile)file, (boolean)bigEndian);
            long count = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
            StringBuffer buffer = new StringBuffer(tag + " (" + TiffTags.tagName(tag) + ") " + IFD.TYPE[type] + " " + count);
            if (type == 2) {
                if (count > 4L) {
                    long vo = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    file.seek(vo);
                    buffer.append(" @" + vo);
                }
                StringBuffer ascii = new StringBuffer();
                int j2 = 0;
                while ((long)j2 < count - 1L) {
                    ascii.append((char)ModuleBase.readUnsignedByte((RandomAccessFile)file));
                    ++j2;
                }
                buffer.append(" = \"" + ascii.toString() + "\"");
            } else if (type == 1 || type == 7) {
                if (count > 4L) {
                    long vo = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    file.seek(vo);
                    buffer.append(" @" + vo);
                }
                buffer.append(" =");
                long ct = count;
                if (nobyte && count > 8L) {
                    ct = 8L;
                }
                j = 0;
                while ((long)j < ct) {
                    long by = ModuleBase.readUnsignedByte((RandomAccessFile)file);
                    buffer.append(" " + by);
                    ++j;
                }
                if (nobyte && count > 8L) {
                    buffer.append(" ...");
                }
            } else if (type == 12) {
                long vo = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                file.seek(vo);
                buffer.append(" @" + vo + " =");
                j = 0;
                while ((long)j < count) {
                    double db = ModuleBase.readDouble((RandomAccessFile)file, (boolean)bigEndian);
                    buffer.append(" " + db);
                    ++j;
                }
            } else if (type == 11) {
                if (count > 1L) {
                    long vo = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    file.seek(vo);
                    buffer.append(" @" + vo);
                }
                buffer.append(" =");
                int j3 = 0;
                while ((long)j3 < count) {
                    float fl = ModuleBase.readFloat((RandomAccessFile)file, (boolean)bigEndian);
                    buffer.append(" " + fl);
                    ++j3;
                }
            } else if (type == 4 || type == 13) {
                if (count > 1L) {
                    long vo = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    file.seek(vo);
                    buffer.append(" @" + vo + " = ");
                } else if (tag == 330 || tag == 34665 || tag == 34853 || tag == 40965) {
                    buffer.append(" @");
                } else {
                    buffer.append(" = ");
                }
                int j4 = 0;
                while ((long)j4 < count) {
                    long in = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    if (j4 > 0) {
                        buffer.append(" ");
                    }
                    buffer.append(in);
                    if (tag == 330 || tag == 34665 || tag == 34853 || tag == 40965) {
                        subIFDs.add(new Long(in));
                    } else if (tag == 273) {
                        stripOffsets.add(new Long(in));
                    } else if (tag == 279) {
                        stripByteCounts.add(new Long(in));
                    }
                    ++j4;
                }
            } else if (type == 5) {
                long vo = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                file.seek(vo);
                buffer.append(" @" + vo + " =");
                j = 0;
                while ((long)j < count) {
                    long numer = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    denom = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    buffer.append(" " + numer + "/" + denom);
                    ++j;
                }
            } else if (type == 6) {
                if (count > 4L) {
                    long vo = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    file.seek(vo);
                    buffer.append(" @" + vo);
                }
                buffer.append(" =");
                int j5 = 0;
                while ((long)j5 < count) {
                    long by = ModuleBase.readSignedByte((RandomAccessFile)file);
                    buffer.append(" " + by);
                    ++j5;
                }
            } else if (type == 3) {
                if (count > 2L) {
                    long vo = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    file.seek(vo);
                    buffer.append(" @" + vo);
                }
                buffer.append(" =");
                int j6 = 0;
                while ((long)j6 < count) {
                    sh = ModuleBase.readUnsignedShort((RandomAccessFile)file, (boolean)bigEndian);
                    buffer.append(" " + sh);
                    if (tag == 273) {
                        stripOffsets.add(new Long(sh));
                    } else if (tag == 279) {
                        stripByteCounts.add(new Long(sh));
                    }
                    ++j6;
                }
            } else if (type == 9) {
                if (count > 1L) {
                    long vo = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    file.seek(vo);
                    buffer.append(" @" + vo);
                }
                buffer.append(" =");
                int j7 = 0;
                while ((long)j7 < count) {
                    int in = ModuleBase.readSignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    buffer.append(" " + in);
                    ++j7;
                }
            } else if (type == 10) {
                long vo = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                file.seek(vo);
                buffer.append(" @" + vo + " =");
                j = 0;
                while ((long)j < count) {
                    long numer = ModuleBase.readSignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    denom = ModuleBase.readSignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    buffer.append(" " + numer + "/" + denom);
                    ++j;
                }
            } else if (type == 8) {
                if (count > 2L) {
                    long vo = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
                    file.seek(vo);
                    buffer.append(" @" + vo);
                }
                buffer.append(" =");
                int j8 = 0;
                while ((long)j8 < count) {
                    sh = ModuleBase.readSignedShort((RandomAccessFile)file, (boolean)bigEndian);
                    buffer.append(" " + sh);
                    ++j8;
                }
            }
            _tags.put(TDump.leading((long)os, (int)8) + os, buffer.toString());
        }
        if (!nosub) {
            for (i = 0; i < subIFDs.size(); ++i) {
                os = (Long)subIFDs.get(i);
                while ((os = TDump.readIFD(file, bigEndian, os, nobyte, nosub)) > 0L) {
                }
            }
        }
        long os2 = offset + 2L + (long)(nEntries * 12);
        file.seek(os2);
        long next = ModuleBase.readUnsignedInt((RandomAccessFile)file, (boolean)bigEndian);
        _tags.put(TDump.leading((long)os2, (int)8) + os2, "NextIFDOffset LONG @" + next);
        int len = stripOffsets.size();
        if (len > 0) {
            for (int j = 0; j < len; ++j) {
                long start = (Long)stripOffsets.get(j);
                long count = (Long)stripByteCounts.get(j);
                long finish = start + count - 1L;
                _tags.put(TDump.leading((long)start, (int)8) + start, "(Image " + nIFD + ",strip " + (j + 1) + ") IMAGEDATA " + count + ": ... " + TDump.leading((long)finish, (int)8) + finish);
            }
        }
        return next;
    }
}

