/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.MessageConstants;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;

public class ExifIFD
extends IFD {
    protected static final int EXPOSURETIME = 33434;
    protected static final int FNUMBER = 33437;
    protected static final int EXPOSUREPROGRAM = 34850;
    protected static final int SPECTRALSENSITIVITY = 34852;
    protected static final int ISOSPEEDRATINGS = 34855;
    protected static final int OECF = 34856;
    protected static final int EXIFVERSION = 36864;
    protected static final int DATETIMEORIGINAL = 36867;
    protected static final int DATETIMEDIGITIZED = 36868;
    protected static final int COMPONENTSCONFIGURATION = 37121;
    protected static final int COMPRESSEDBITSPERPIXEL = 37122;
    protected static final int SHUTTERSPEEDVALUE = 37377;
    protected static final int APERTUREVALUE = 37378;
    protected static final int BRIGHTNESSVALUE = 37379;
    protected static final int EXPOSUREBIASVALUE = 37380;
    protected static final int MAXAPERTUREVALUE = 37381;
    protected static final int SUBJECTDISTANCE = 37382;
    protected static final int METERINGMODE = 37383;
    protected static final int LIGHTSOURCE = 37384;
    protected static final int FLASH = 37385;
    protected static final int FOCALLENGTH = 37386;
    protected static final int SUBJECTAREA = 37396;
    protected static final int MAKERNOTE = 37500;
    protected static final int USERCOMMENT = 37510;
    protected static final int SUBSECTIME = 37520;
    protected static final int SUBSECTIMEORIGINAL = 37521;
    protected static final int SUBSECTIMEDIGITIZED = 37522;
    protected static final int FLASHPIXVERSION = 40960;
    protected static final int COLORSPACE = 40961;
    protected static final int PIXELXDIMENSION = 40962;
    protected static final int PIXELYDIMENSION = 40963;
    protected static final int RELATEDSOUNDFILE = 40964;
    protected static final int FLASHENERGY = 41483;
    protected static final int SPATIALFREQUENCYRESPONSE = 41484;
    protected static final int FOCALPLANEXRESOLUTION = 41486;
    protected static final int FOCALPLANEYRESOLUTION = 41487;
    protected static final int FOCALPLANERESOLUTIONUNIT = 41488;
    protected static final int SUBJECTLOCATION = 41492;
    protected static final int EXPOSUREINDEX = 41493;
    protected static final int SENSINGMETHOD = 41495;
    protected static final int FILESOURCE = 41728;
    protected static final int SCENETYPE = 41729;
    protected static final int CFAPATTERN = 41730;
    protected static final int CUSTOMRENDERED = 41985;
    protected static final int EXPOSUREMODE = 41986;
    protected static final int WHITEBALANCE = 41987;
    protected static final int DIGITALZOOMRATIO = 41988;
    protected static final int FOCALLENGTHIN35MMFILM = 41989;
    protected static final int SCENECAPTURETYPE = 41990;
    protected static final int GAINCONTROL = 41991;
    protected static final int CONTRAST = 41992;
    protected static final int SATURATION = 41993;
    protected static final int SHARPNESS = 41994;
    protected static final int DEVICESETTINGDESCRIPTION = 41995;
    protected static final int SUBJECTDISTANCERANGE = 41996;
    protected static final int IMAGEUNIQUEID = 42016;
    private static final String[] COLORSPACE_L = new String[]{"sRGB", "uncalibrated"};
    private static final int[] COLORSPACE_INDEX = new int[]{1, 65535};
    public static final String[] COMPONENTSCONFIGURATION_L = new String[]{"Does not exist", "Y", "Cb", "Cr", "R", "G", "B"};
    public static final String[] CONTRAST_L = new String[]{"normal", "soft", "hard"};
    public static final String[] CUSTOMRENDERED_L = new String[]{"normal", "custom"};
    public static final String[] EXPOSUREMODE_L = new String[]{"auto", "manual", "auto bracket"};
    public static final String[] EXPOSUREPROGRAM_L = new String[]{"unidentified", "manual", "program normal", "aperture priority", "shutter priority", "program creative", "program action", "portrait mode", "landscape mode"};
    public static final String[] FILESOURCE_L = new String[]{"", "", "", "DSC"};
    public static final String[] FLASH_L = new String[]{"did not fire", "fired", "strobe return light not detected", "strobe return light detected", "fired, compulsory flash mode", "fired, compulsory flash mode, return light not detected", "fired, compulsory flash mode, return light detected", "did not fire, compulsory flash mode", "did not fire, auto mode", "fired, auto mode", "fired, auto mode, return light not detected", "fired, auto mode, return light detected", "no flash function", "fired, red-eye reduction mode", "fired, red-eye reduction mode, return light not detected", "fired, red-eye reduction mode, return light detected", "fired, compulsory mode", "fired, compulsory mode, return light not detected", "fired, compulsory flash mode, return light detected", "fired, auto mode, red-eye reduction mode", "fired, auto mode, red-eye reduction mode, return light not detected", "fired, auto mode, red-eye reduction mode, return light detected"};
    public static final int[] FLASH_INDEX = new int[]{0, 1, 5, 7, 9, 13, 15, 16, 24, 25, 29, 31, 32, 65, 69, 71, 73, 77, 79, 89, 93, 95};
    public static final String[] FOCALPLANERESOLUTIONUNIT_L = new String[]{"", "", "inches", "centimeters", "millimeters", "micrometers"};
    public static final String[] GAINCONTROL_L = new String[]{"none", "low gain up", "high gain up", "low gain down", "high gain down"};
    public static final String[] LIGHTSOURCE_L = new String[]{"unknown", "daylight", "fluorescent", "tungsten", "flash", "fine weather", "cloudy weather", "shade", "daylight flourescent (D 5700 - 7100K)", "day white flourescent (N 4600 - 5400K)", "cool white flourescent (W 3900 - 4500K)", "white flourescent (WW 3200 - 3700K)", "standard light A", "standard light B", "standard light C", "D55", "D65", "D75", "D50", "ISO studio tungsten", "other"};
    public static final int[] LIGHTSOURCE_INDEX = new int[]{0, 1, 2, 3, 4, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23, 24, 255};
    public static final String[] METERINGMODE_L = new String[]{"unidentified", "average", "centre weighted average", "spot", "multispot", "pattern", "partial", "other"};
    public static final int[] METERINGMODE_INDEX = new int[]{0, 1, 2, 3, 4, 5, 6, 255};
    public static final String[] SATURATION_L = new String[]{"normal", "soft", "hard"};
    public static final String[] SCENECAPTURETYPE_L = new String[]{"standard", "landscape", "portrait", "night"};
    public static final String[] SCENETYPE_L = new String[]{"", "directly photographed image"};
    public static final String[] SENSINGMETHOD_L = new String[]{"", "not defined", "one-chip color area", "two-chip color area", "three-chip color area", "color sequential area", "", "trilinear", "colour sequential linear"};
    public static final String[] SHARPNESS_L = new String[]{"normal", "soft", "hard"};
    public static final String[] SUBJECTDISTANCERANGE_L = new String[]{"unknown", "macro", "close", "distant"};
    public static final String[] WHITEBALANCE_L = new String[]{"auto", "manual"};
    private Rational _apertureValue;
    private Rational _brightnessValue;
    private int[] _cfaPattern;
    protected int _colorSpace = -1;
    private int[] _componentsConfiguration;
    private Rational _compressedBitsPerPixel;
    private int _contrast = 0;
    private int _customRendered = -1;
    private String _dateTimeDigitized;
    private String _dateTimeOriginal;
    private int[] _deviceSettingDescription;
    private Rational _digitalZoomRatio;
    protected String _exifVersion = "0220";
    private Rational _exposureBiasValue;
    private Rational _exposureIndex;
    private int _exposureMode = -1;
    private int _exposureProgram = -1;
    private Rational _exposureTime;
    private int _fileSource = -1;
    private int _flash = -1;
    private Rational _flashEnergy;
    protected String _flashpixVersion = "0100";
    private Rational _fNumber;
    private Rational _focalLength;
    private int _focalLengthIn35mmFilm = -1;
    private Rational _focalPlaneXResolution;
    private Rational _focalPlaneYResolution;
    private int _focalPlaneResolutionUnit = 2;
    private int _gainControl = -1;
    private String _imageUniqueID;
    private int[] _isoSpeedRatings;
    private int _lightSource = -1;
    private int[] _makerNote;
    private Rational _maxApertureValue;
    private int _meteringMode = -1;
    private int[] _oecf;
    private long _pixelXDimension = -1L;
    private long _pixelYDimension = -1L;
    private String _relatedSoundFile;
    private int _saturation = -1;
    private int _sceneCaptureType = -1;
    private int _sceneType = -1;
    private int _sensingMethod = -1;
    private int _sharpness = -1;
    private Rational _shutterSpeedValue;
    private int[] _spatialFrequencyResponse;
    private String _spectralSensitivity;
    private int[] _subjectArea;
    private Rational _subjectDistance;
    private int _subjectDistanceRange = -1;
    private int[] _subjectLocation;
    private String _subSecTime;
    private String _subSecTimeDigitized;
    private String _subSecTimeOriginal;
    private int[] _userComment;
    private int _whiteBalance = -1;
    private String _manufacturer;
    private String _model;
    private String _software;
    private String _artist;
    private int _orientation;
    private NisoImageMetadata _niso = new NisoImageMetadata();

    public ExifIFD(long offset, RepInfo info, RandomAccessFile raf, boolean bigEndian) {
        super(offset, info, raf, bigEndian);
    }

    @Override
    public Property getProperty(boolean rawOutput) {
        Property ucp;
        LinkedList<Property> entries = new LinkedList<Property>();
        entries.add(new Property("ExifVersion", PropertyType.STRING, (Object)this._exifVersion));
        entries.add(new Property("FlashpixVersion", PropertyType.STRING, (Object)this._flashpixVersion));
        if (this._colorSpace != -1) {
            entries.add(this.addIntegerProperty("ColorSpace", this._colorSpace, COLORSPACE_L, COLORSPACE_INDEX, rawOutput));
        }
        if (this._componentsConfiguration != null) {
            entries.add(new Property("ComponentsConfiguration", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._componentsConfiguration));
        }
        if (this._compressedBitsPerPixel != null) {
            entries.add(this.addRationalProperty("CompressedBitsPerPixel", this._compressedBitsPerPixel, rawOutput));
        }
        if (this._pixelXDimension != -1L) {
            entries.add(new Property("PixelXDimension", PropertyType.LONG, (Object)new Long(this._pixelXDimension)));
        }
        if (this._pixelYDimension != -1L) {
            entries.add(new Property("PixelYDimension", PropertyType.LONG, (Object)new Long(this._pixelYDimension)));
        }
        if (this._makerNote != null) {
            entries.add(new Property("MakerNote", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._makerNote));
        }
        if (this._userComment != null && (ucp = this.makeUserCommentProperty(this._userComment, rawOutput)) != null) {
            entries.add(ucp);
        }
        if (this._relatedSoundFile != null) {
            entries.add(new Property("RelatedSoundFile", PropertyType.STRING, (Object)this._relatedSoundFile));
        }
        if (this._dateTimeOriginal != null) {
            entries.add(new Property("DateTimeOriginal", PropertyType.STRING, (Object)this._dateTimeOriginal));
        }
        if (this._dateTimeDigitized != null) {
            entries.add(new Property("DateTimeDigitized", PropertyType.STRING, (Object)this._dateTimeDigitized));
        }
        if (this._subSecTime != null) {
            entries.add(new Property("SubSecTime", PropertyType.STRING, (Object)this._subSecTime));
        }
        if (this._subSecTimeOriginal != null) {
            entries.add(new Property("SubSecTimeOriginal", PropertyType.STRING, (Object)this._subSecTimeOriginal));
        }
        if (this._subSecTimeDigitized != null) {
            entries.add(new Property("SubSecTimeDigitized", PropertyType.STRING, (Object)this._subSecTimeDigitized));
        }
        if (this._imageUniqueID != null) {
            entries.add(new Property("ImageUniqueID", PropertyType.STRING, (Object)this._imageUniqueID));
        }
        if (this._exposureTime != null) {
            entries.add(this.addRationalProperty("ExposureTime", this._exposureTime, rawOutput));
        }
        if (this._fNumber != null) {
            entries.add(this.addRationalProperty("FNumber", this._fNumber, rawOutput));
        }
        if (this._exposureProgram != -1) {
            entries.add(this.addIntegerProperty("ExposureProgram", this._exposureProgram, EXPOSUREPROGRAM_L, rawOutput));
        }
        if (this._spectralSensitivity != null) {
            entries.add(new Property("SpectralSensitivity", PropertyType.STRING, (Object)this._spectralSensitivity));
        }
        if (this._isoSpeedRatings != null) {
            entries.add(new Property("ISOSpeedRatings", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._isoSpeedRatings));
        }
        if (this._oecf != null) {
            entries.add(new Property("OECF", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._oecf));
        }
        if (this._shutterSpeedValue != null) {
            entries.add(this.addRationalProperty("ShutterSpeedValue", this._shutterSpeedValue, rawOutput));
        }
        if (this._apertureValue != null) {
            entries.add(this.addRationalProperty("ApertureValue", this._apertureValue, rawOutput));
        }
        if (this._brightnessValue != null) {
            entries.add(this.addRationalProperty("BrightnessValue", this._brightnessValue, rawOutput));
        }
        if (this._exposureBiasValue != null) {
            entries.add(this.addRationalProperty("ExposureBiasValue", this._exposureBiasValue, rawOutput));
        }
        if (this._maxApertureValue != null) {
            entries.add(this.addRationalProperty("MaxApertureValue", this._maxApertureValue, rawOutput));
        }
        if (this._subjectDistance != null) {
            entries.add(this.addRationalProperty("SubjectDistance", this._subjectDistance, rawOutput));
        }
        if (this._meteringMode != -1) {
            entries.add(this.addIntegerProperty("MeteringMode", this._meteringMode, METERINGMODE_L, METERINGMODE_INDEX, rawOutput));
        }
        if (this._lightSource != -1) {
            entries.add(this.addIntegerProperty("LightSource", this._lightSource, LIGHTSOURCE_L, LIGHTSOURCE_INDEX, rawOutput));
        }
        if (this._flash != -1) {
            entries.add(this.addIntegerProperty("Flash", this._flash, FLASH_L, FLASH_INDEX, rawOutput));
        }
        if (this._focalLength != null) {
            entries.add(this.addRationalProperty("FocalLength", this._focalLength, rawOutput));
        }
        if (this._subjectArea != null) {
            entries.add(new Property("SubjectArea", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._subjectArea));
        }
        if (this._flashEnergy != null) {
            entries.add(this.addRationalProperty("FlashEnergy", this._flashEnergy, rawOutput));
        }
        if (this._spatialFrequencyResponse != null) {
            entries.add(new Property("SubjectArea", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._subjectArea));
        }
        if (this._focalPlaneXResolution != null) {
            entries.add(this.addRationalProperty("FocalPlaneXResolution", this._focalPlaneXResolution, rawOutput));
        }
        if (this._focalPlaneYResolution != null) {
            entries.add(this.addRationalProperty("FocalPlaneYResolution", this._focalPlaneYResolution, rawOutput));
        }
        if (this._focalPlaneResolutionUnit != -1) {
            entries.add(this.addIntegerProperty("FocalPlaneResolutionUnit", this._focalPlaneResolutionUnit, FOCALPLANERESOLUTIONUNIT_L, rawOutput));
        }
        if (this._subjectLocation != null) {
            entries.add(new Property("SubjectLocation", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._subjectLocation));
        }
        if (this._exposureIndex != null) {
            entries.add(this.addRationalProperty("ExposureIndex", this._exposureIndex, rawOutput));
        }
        if (this._sensingMethod != -1) {
            entries.add(this.addIntegerProperty("SensingMethod", this._sensingMethod, SENSINGMETHOD_L, rawOutput));
        }
        if (this._fileSource != -1) {
            entries.add(this.addIntegerProperty("FileSource", this._fileSource, FILESOURCE_L, rawOutput));
        }
        if (this._sceneType != -1) {
            entries.add(this.addIntegerProperty("SceneType", this._sceneType, SCENETYPE_L, rawOutput));
        }
        if (this._cfaPattern != null) {
            entries.add(new Property("CFAPattern", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._cfaPattern));
        }
        if (this._customRendered != -1) {
            entries.add(this.addIntegerProperty("CustomRendered", this._customRendered, CUSTOMRENDERED_L, rawOutput));
        }
        if (this._exposureMode != -1) {
            entries.add(this.addIntegerProperty("ExposureMode", this._exposureMode, EXPOSUREMODE_L, rawOutput));
        }
        if (this._whiteBalance != -1) {
            entries.add(this.addIntegerProperty("WhiteBalance", this._whiteBalance, WHITEBALANCE_L, rawOutput));
        }
        if (this._digitalZoomRatio != null) {
            entries.add(this.addRationalProperty("DigitalZoomRatio", this._digitalZoomRatio, rawOutput));
        }
        if (this._focalLengthIn35mmFilm != -1) {
            entries.add(new Property("FocalLengthIn35mmFilm", PropertyType.INTEGER, (Object)new Integer(this._focalLengthIn35mmFilm)));
        }
        if (this._sceneCaptureType != -1) {
            entries.add(this.addIntegerProperty("SceneCaptureType", this._sceneCaptureType, SCENECAPTURETYPE_L, rawOutput));
        }
        if (this._gainControl != -1) {
            entries.add(this.addIntegerProperty("GainControl", this._gainControl, GAINCONTROL_L, rawOutput));
        }
        if (this._contrast != -1) {
            entries.add(this.addIntegerProperty("Contrast", this._contrast, CONTRAST_L, rawOutput));
        }
        if (this._saturation != -1) {
            entries.add(this.addIntegerProperty("Saturation", this._saturation, SATURATION_L, rawOutput));
        }
        if (this._sharpness != -1) {
            entries.add(this.addIntegerProperty("Sharpness", this._sharpness, SHARPNESS_L, rawOutput));
        }
        if (this._deviceSettingDescription != null) {
            entries.add(new Property("DeviceSettingDescription", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)this._deviceSettingDescription));
        }
        if (this._subjectDistanceRange != -1) {
            entries.add(this.addIntegerProperty("SubjectDistanceRange", this._subjectDistanceRange, SUBJECTDISTANCERANGE_L, rawOutput));
        }
        if (this._manufacturer != null) {
            entries.add(new Property("Make", PropertyType.STRING, (Object)this._manufacturer));
        }
        if (this._model != null) {
            entries.add(new Property("Model", PropertyType.STRING, (Object)this._model));
        }
        if (this._software != null) {
            entries.add(new Property("Software", PropertyType.STRING, (Object)this._software));
        }
        if (this._artist != null) {
            entries.add(new Property("Artist", PropertyType.STRING, (Object)this._artist));
        }
        return this.propertyHeader("Exif", entries);
    }

    public String getExifVersion() {
        return this._exifVersion;
    }

    public NisoImageMetadata getNisoImageMetadata() {
        return this._niso;
    }

    public String getFlashpixVersion() {
        return this._flashpixVersion;
    }

    public int getColorspace() {
        return this._colorSpace;
    }

    public List exifProps(Property pHeader) {
        try {
            Property[] pArr = (Property[])pHeader.getValue();
            Property entries = pArr[2];
            return (List)entries.getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void lookupTag(int tag, int type, long count, long value) throws TiffException {
        try {
            if (tag == 37378) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._apertureValue = this.readRational(count, value);
            } else if (tag == 37379) {
                ExifIFD.checkType(tag, type, 10);
                ExifIFD.checkCount(tag, count, 1);
                this._brightnessValue = this.readRational(count, value);
                this._niso.setBrightness(this._brightnessValue);
            } else if (tag == 41730) {
                ExifIFD.checkType(tag, type, 7);
                this._cfaPattern = this.readByteArray(type, count, value);
            } else if (tag == 40961) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._colorSpace = this.readShort(type, count, value);
                this._niso.setColorSpace(this._colorSpace);
            } else if (tag == 37121) {
                ExifIFD.checkType(tag, type, 7);
                this._componentsConfiguration = this.readByteArray(type, count, value);
            } else if (tag == 37122) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._compressedBitsPerPixel = this.readRational(count, value);
            } else if (tag == 41992) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._contrast = this.readShort(type, count, value);
            } else if (tag == 41985) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._customRendered = this.readShort(type, count, value);
            } else if (tag == 36868) {
                ExifIFD.checkType(tag, type, 2);
                ExifIFD.checkCount(tag, count, 20);
                this._dateTimeDigitized = this.readASCII(count, value);
            } else if (tag == 36867) {
                ExifIFD.checkType(tag, type, 2);
                ExifIFD.checkCount(tag, count, 20);
                this._dateTimeOriginal = this.readASCII(count, value);
            } else if (tag == 41995) {
                ExifIFD.checkType(tag, type, 7);
                this._deviceSettingDescription = this.readByteArray(type, count, value);
            } else if (tag == 41988) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._digitalZoomRatio = this.readRational(count, value);
            } else if (tag == 36864) {
                ExifIFD.checkType(tag, type, 7);
                ExifIFD.checkCount(tag, count, 4);
                int[] iarray = this.readShortArray(type, count, value);
                char[] carray = new char[iarray.length];
                for (int i = 0; i < iarray.length; ++i) {
                    carray[i] = (char)iarray[i];
                }
                this._exifVersion = new String(carray);
                this._niso.setExifVersion(this._exifVersion);
            } else if (tag == 37380) {
                ExifIFD.checkType(tag, type, 10);
                ExifIFD.checkCount(tag, count, 1);
                this._exposureBiasValue = this.readRational(count, value);
                this._niso.setExposureBias(this._exposureBiasValue);
            } else if (tag == 41493) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._exposureIndex = this.readRational(count, value);
                this._niso.setExposureIndex(this._exposureIndex.toDouble());
            } else if (tag == 41986) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._exposureMode = this.readShort(type, count, value);
            } else if (tag == 34850) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._exposureProgram = this.readShort(type, count, value);
                this._niso.setExposureProgram(this._exposureProgram);
            } else if (tag == 33434) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._exposureTime = this.readRational(count, value);
                this._niso.setExposureTime(this._exposureTime.toDouble());
            } else if (tag == 41728) {
                ExifIFD.checkType(tag, type, 7);
                ExifIFD.checkCount(tag, count, 1);
                this._fileSource = this.readByte(type, count, value);
            } else if (tag == 37385) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._flash = this.readShort(type, count, value);
                this._niso.setFlash(this._flash);
            } else if (tag == 41483) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._flashEnergy = this.readRational(count, value);
                this._niso.setFlashEnergy(this._flashEnergy);
            } else if (tag == 40960) {
                ExifIFD.checkType(tag, type, 7);
                ExifIFD.checkCount(tag, count, 4);
                int[] iarray = this.readShortArray(type, count, value);
                char[] carray = new char[iarray.length];
                for (int i = 0; i < iarray.length; ++i) {
                    carray[i] = (char)iarray[i];
                }
                this._flashpixVersion = new String(carray);
            } else if (tag == 33437) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._fNumber = this.readRational(count, value);
                this._niso.setFNumber(this._fNumber.toDouble());
            } else if (tag == 37386) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._focalLength = this.readRational(count, value);
                this._niso.setFocalLength(this._focalLength.toDouble());
            } else if (tag == 41989) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._focalLengthIn35mmFilm = this.readShort(type, count, value);
            } else if (tag == 41486) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._focalPlaneXResolution = this.readRational(count, value);
            } else if (tag == 41487) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._focalPlaneYResolution = this.readRational(count, value);
            } else if (tag == 41488) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._focalPlaneResolutionUnit = this.readShort(type, count, value);
            } else if (tag == 41991) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._gainControl = this.readShort(type, count, value);
            } else if (tag == 42016) {
                ExifIFD.checkType(tag, type, 2);
                ExifIFD.checkCount(tag, count, 33);
                this._imageUniqueID = this.readASCII(count, value);
            } else if (tag == 34855) {
                ExifIFD.checkType(tag, type, 3);
                this._isoSpeedRatings = this.readShortArray(type, count, value);
            } else if (tag == 37384) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._lightSource = this.readShort(type, count, value);
            } else if (tag == 37500) {
                ExifIFD.checkType(tag, type, 7);
                this._makerNote = this.readShortArray(type, count, value);
            } else if (tag == 37381) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._maxApertureValue = this.readRational(count, value);
                this._niso.setMaxApertureValue(this._maxApertureValue);
            } else if (tag == 37383) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._meteringMode = this.readShort(type, count, value);
                this._niso.setMeteringMode(this._meteringMode);
            } else if (tag == 34856) {
                ExifIFD.checkType(tag, type, 3);
                this._oecf = this.readShortArray(type, count, value);
            } else if (tag == 40962) {
                ExifIFD.checkType(tag, type, 4);
                ExifIFD.checkCount(tag, count, 1);
                this._pixelXDimension = this.readLong(type, count, value);
            } else if (tag == 40963) {
                ExifIFD.checkType(tag, type, 4);
                ExifIFD.checkCount(tag, count, 1);
                this._pixelYDimension = this.readLong(type, count, value);
            } else if (tag == 40964) {
                ExifIFD.checkType(tag, type, 2);
                ExifIFD.checkCount(tag, count, 13);
                this._relatedSoundFile = this.readASCII(count, value);
            } else if (tag == 41993) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._saturation = this.readShort(type, count, value);
            } else if (tag == 41990) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._sceneCaptureType = this.readShort(type, count, value);
            } else if (tag == 41729) {
                ExifIFD.checkType(tag, type, 7);
                ExifIFD.checkCount(tag, count, 1);
                this._sceneType = this.readShort(type, count, value);
            } else if (tag == 41495) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._sensingMethod = this.readShort(type, count, value);
            } else if (tag == 41994) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._sharpness = this.readShort(type, count, value);
            } else if (tag == 37377) {
                ExifIFD.checkType(tag, type, 10);
                ExifIFD.checkCount(tag, count, 1);
                this._shutterSpeedValue = this.readRational(count, value);
            } else if (tag == 41484) {
                ExifIFD.checkType(tag, type, 7);
                this._spatialFrequencyResponse = this.readShortArray(type, count, value);
            } else if (tag == 34852) {
                ExifIFD.checkType(tag, type, 2);
                this._spectralSensitivity = this.readASCII(count, value);
            } else if (tag == 37396) {
                ExifIFD.checkType(tag, type, 3);
                this._subjectArea = this.readShortArray(type, count, value);
            } else if (tag == 37382) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._subjectDistance = this.readRational(count, value);
            } else if (tag == 41996) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._subjectDistanceRange = this.readShort(type, count, value);
            } else if (tag == 41492) {
                ExifIFD.checkType(tag, type, 3);
                this._subjectLocation = this.readShortArray(type, count, value);
            } else if (tag == 37520) {
                ExifIFD.checkType(tag, type, 2);
                this._subSecTime = this.readASCII(count, value);
            } else if (tag == 37522) {
                ExifIFD.checkType(tag, type, 2);
                this._subSecTimeDigitized = this.readASCII(count, value);
            } else if (tag == 37521) {
                ExifIFD.checkType(tag, type, 2);
                this._subSecTimeOriginal = this.readASCII(count, value);
            } else if (tag == 37510) {
                ExifIFD.checkType(tag, type, 7);
                this._userComment = this.readByteArray(type, count, value);
            } else if (tag == 41987) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                this._whiteBalance = this.readShort(type, count, value);
            } else if (tag == 271) {
                ExifIFD.checkType(tag, type, 2);
                String make = this.readASCII(count, value);
                this._niso.setScannerManufacturer(make);
                this._manufacturer = make;
            } else if (tag == 272) {
                ExifIFD.checkType(tag, type, 2);
                String model = this.readASCII(count, value);
                this._niso.setScannerModelName(model);
                this._model = model;
            } else if (tag == 274) {
                ExifIFD.checkType(tag, type, 3);
                ExifIFD.checkCount(tag, count, 1);
                int orient = this.readShort(type, count, value);
                this._niso.setOrientation(orient);
                this._orientation = orient;
            } else if (tag == 282) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._niso.setXSamplingFrequency(this.readRational(count, value));
            } else if (tag == 283) {
                ExifIFD.checkType(tag, type, 5);
                ExifIFD.checkCount(tag, count, 1);
                this._niso.setYSamplingFrequency(this.readRational(count, value));
            }
        }
        catch (IOException e) {
            String mess = MessageFormat.format(MessageConstants.TIFF_HUL_13.getMessage(), tag);
            JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_13.getId(), (String)mess);
            throw new TiffException(message, value);
        }
    }

    private Property makeUserCommentProperty(int[] rawValue, boolean rawOutput) {
        String idCode = "Undefined";
        String cmtValue = null;
        try {
            StringBuffer idBuf = new StringBuffer(8);
            int byteLim = 8;
            if (rawValue.length < 8) {
                byteLim = rawValue.length;
            }
            if (rawValue[0] != 0) {
                for (int i = 0; i < byteLim && rawValue[i] != 0; ++i) {
                    idBuf.append((char)rawValue[i]);
                }
                idCode = idBuf.toString();
            }
            if ("ASCII".equals(idCode) || "UNICODE".equals(idCode)) {
                byte[] textBytes = new byte[rawValue.length - 8];
                for (int i = 0; i < rawValue.length - 8; ++i) {
                    textBytes[i] = (byte)rawValue[i + 8];
                }
                String encoding = "ASCII".equals(idCode) ? "ASCII" : "UTF8";
                cmtValue = new String(textBytes, encoding);
            }
            Property[] propArray = rawValue != null && cmtValue != null ? new Property[3] : new Property[2];
            propArray[0] = new Property("IDCode", PropertyType.STRING, (Object)idCode);
            int i = 1;
            if (cmtValue != null) {
                propArray[i++] = new Property("Value", PropertyType.STRING, (Object)idCode);
            }
            if (rawValue != null) {
                propArray[i++] = new Property("RawValue", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)rawValue);
            }
            return new Property("UserComment", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propArray);
        }
        catch (Exception e) {
            return null;
        }
    }
}

