/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.MessageConstants;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.LinkedList;

public class InteroperabilityIFD
extends IFD {
    private static final int INTEROPERABILITYINDEX = 1;
    private String _interoperabilityIndex;

    public InteroperabilityIFD(long offset, RepInfo info, RandomAccessFile raf, boolean bigEndian) {
        super(offset, info, raf, bigEndian);
    }

    public String getInteroperabilityIndex() {
        return this._interoperabilityIndex;
    }

    @Override
    public Property getProperty(boolean rawOutput) {
        LinkedList<Property> entries = new LinkedList<Property>();
        entries.add(new Property("Index", PropertyType.STRING, (Object)this._interoperabilityIndex));
        return this.propertyHeader("Exif Interoperability", entries);
    }

    @Override
    public void lookupTag(int tag, int type, long count, long value) throws TiffException {
        try {
            if (tag == 1) {
                InteroperabilityIFD.checkType(tag, type, 2);
                this._interoperabilityIndex = this.readASCII(count, value);
            } else {
                String subMessage = MessageFormat.format(MessageConstants.TIFF_HUL_15_SUB.getMessage(), tag);
                this._info.setMessage((Message)new ErrorMessage(MessageConstants.TIFF_HUL_15, subMessage, value));
            }
        }
        catch (IOException e) {
            String mess = MessageFormat.format(MessageConstants.TIFF_HUL_16.getMessage(), tag);
            JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_16.getId(), (String)mess);
            throw new TiffException(message, value);
        }
    }
}

