/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public class TiffProfileEP
extends TiffProfile {
    public TiffProfileEP() {
        this._profileText = "TIFF/EP (ISO 12234-2:2001)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        if (niso.getImageWidth() == -1L || niso.getImageLength() == -1L || niso.getBitsPerSample() == null || tifd.getImageDescription() == null || niso.getXSamplingFrequency() == null || niso.getYSamplingFrequency() == null || niso.getScannerManufacturer() == null || niso.getScannerModelName() == null && niso.getScannerModelNumber() == null || niso.getScanningSoftware() == null || tifd.getImageDescription() == null || tifd.getCopyright() == null || niso.getDateTimeCreated() == null || tifd.getDateTime() == null || tifd.getTIFFEPStandardID() == null) {
            return false;
        }
        if (!(niso.getStripOffsets() != null && niso.getRowsPerStrip() != -1L && niso.getStripByteCounts() != null || niso.getTileWidth() != -1L && niso.getTileLength() != -1L && niso.getTileOffsets() != null && niso.getTileByteCounts() != null)) {
            return false;
        }
        long subfile = tifd.getNewSubfileType();
        if (subfile != 0L && subfile != 1L) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tifd, new int[]{1, 2, 3})) {
            return false;
        }
        if (!this.satisfiesOrientation(tifd, new int[]{-1, 1, 3, 6, 8, 9})) {
            return false;
        }
        int pInterpretation = niso.getColorSpace();
        if (pInterpretation != 1 && pInterpretation != 2 && pInterpretation != 6 && pInterpretation != 32803 && pInterpretation <= Short.MAX_VALUE) {
            return false;
        }
        int config = niso.getPlanarConfiguration();
        if (config != 1 && config != 2) {
            return false;
        }
        int method = niso.getSensor();
        if (method == -1 || method < 0 || method > 8) {
            return false;
        }
        if (pInterpretation == 32803) {
            if (tifd.getCFARepeatPatternDim() == null) {
                return false;
            }
            if (tifd.getCFAPattern() == null) {
                return false;
            }
        }
        int samplesPerPixel = niso.getSamplesPerPixel();
        if (pInterpretation != 1 && pInterpretation != 32803 || samplesPerPixel != 1) {
            // empty if block
        }
        if (pInterpretation != 2 && pInterpretation != 6 || samplesPerPixel != 3) {
            // empty if block
        }
        if (pInterpretation == 6 && (niso.getYCbCrCoefficients() == null || niso.getYCbCrSubSampling() == null || niso.getYCbCrPositioning() == -1 || niso.getReferenceBlackWhite() == null)) {
            return false;
        }
        int compression = niso.getCompressionScheme();
        return compression == -1 || compression == 1 || compression == 7 || compression > Short.MAX_VALUE;
    }
}

