/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.utf8;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.utf8.Utf8Block;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class Utf8BlockMarker {
    private Set<Utf8Block> blocksUsed = new HashSet<Utf8Block>();

    public void markBlock(int code) {
        Utf8Block block = Utf8Block.blockFromInt(code);
        if (block == null) {
            return;
        }
        this.blocksUsed.add(block);
    }

    public Property getBlocksUsedProperty(String name) {
        if (this.blocksUsed.isEmpty()) {
            return null;
        }
        ArrayList<String> blocks = new ArrayList<String>();
        for (Utf8Block block : EnumSet.copyOf(this.blocksUsed)) {
            blocks.add(block.name);
        }
        return new Property(name, PropertyType.STRING, PropertyArity.LIST, blocks);
    }

    public void reset() {
        this.blocksUsed.clear();
    }
}

