/*
 * Decompiled with CFR 0.152.
 */
import edu.harvard.hul.ois.jhove.Dump;
import edu.harvard.hul.ois.jhove.ModuleBase;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;

public class WDump
extends Dump {
    private static final int[] sigByte = new int[]{82, 73, 70, 70};
    private static final boolean ENDIAN = false;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: java WDump file");
            System.exit(-1);
        }
        try {
            FileInputStream file = new FileInputStream(args[0]);
            BufferedInputStream buffer = new BufferedInputStream(file);
            DataInputStream stream = new DataInputStream(buffer);
            long os = 0L;
            for (int i = 0; i < 4; ++i) {
                int ch = stream.readUnsignedByte();
                if (ch != sigByte[i]) {
                    System.out.println("No AIFF FORM header");
                    System.exit(-2);
                }
                ++os;
            }
            long ckSize = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)false);
            os += 4L;
            String formType = WDump.read4Chars(stream);
            os += 4L;
            System.out.println("00000000: RIFF " + ckSize + ": " + formType);
            boolean endOfFile = false;
            while (!endOfFile) {
                try {
                    String ckID = WDump.read4Chars(stream);
                    ckSize = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)false);
                    System.out.print(WDump.leading((long)os, (int)8) + os + ": " + ckID + " " + ckSize);
                    long alreadyRead = 0L;
                    if ("fact".equals(ckID)) {
                        long sampleLength = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)false);
                        System.out.print(": " + sampleLength);
                        alreadyRead = 4L;
                    } else if ("fmt ".equals(ckID)) {
                        int formatTag = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)false);
                        int channels = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)false);
                        long samplesPerSec = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)false);
                        long avgBytesPerSec = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)false);
                        int blockAlign = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)false);
                        String hex = Integer.toHexString(formatTag);
                        System.out.print(": 0x" + WDump.leading((String)hex, (int)4) + hex + " " + channels + " " + samplesPerSec + " " + avgBytesPerSec + " " + blockAlign);
                        alreadyRead = 14L;
                        if (ckSize > 14L) {
                            int bitsPerSample = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)false);
                            System.out.print(" " + bitsPerSample);
                            alreadyRead = 16L;
                            if (ckSize > 16L) {
                                int size = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)false);
                                System.out.print(" " + size);
                                alreadyRead = 18L;
                                if (size == 22) {
                                    int validBitsPerSample = ModuleBase.readUnsignedShort((DataInputStream)stream, (boolean)false);
                                    long channelMask = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)false);
                                    hex = Long.toHexString(channelMask);
                                    System.out.print(" " + validBitsPerSample + " 0x" + WDump.leading((String)hex, (int)8) + hex + " 0x");
                                    for (int i = 0; i < 4; ++i) {
                                        long guid = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)false);
                                        hex = Long.toHexString(guid);
                                        System.out.print(WDump.leading((String)hex, (int)8) + hex);
                                    }
                                    alreadyRead = 40L;
                                }
                            }
                        }
                    }
                    System.out.println();
                    if ("list".equals(ckID) || "LIST".equals(ckID)) {
                        WDump.readNestedChunks(ckID, stream, ckSize, os + 8L);
                    } else {
                        stream.skipBytes((int)(ckSize - alreadyRead));
                    }
                    os += ckSize + 8L;
                }
                catch (EOFException e) {
                    endOfFile = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void readNestedChunks(String ckID, DataInputStream stream, long ckSize, long os) throws IOException {
        String listType = WDump.read4Chars(stream);
        System.out.println("List type = " + listType);
        while (ckSize > 0L) {
            String subCkID = WDump.read4Chars(stream);
            long subCkSize = ModuleBase.readUnsignedInt((DataInputStream)stream, (boolean)false, null);
            System.out.println(WDump.leading((long)os, (int)8) + os + ": " + ckID + "/" + subCkID + " " + subCkSize);
            stream.skipBytes((int)subCkSize);
            os += subCkSize + 8L;
            ckSize -= subCkSize + 8L;
        }
    }

    private static String read4Chars(DataInputStream stream) throws IOException {
        StringBuffer sbuf = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            int ch = ModuleBase.readUnsignedByte((DataInputStream)stream, null);
            sbuf.append((char)ch);
        }
        return sbuf.toString();
    }
}

